/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.TableFormat;

public abstract class AggreGateBean {
    private final TableFormat format;

    public AggreGateBean(TableFormat format) {
        this.format = format;
        if (format != null) {
            try {
                DataTableConversion.populateBeanFromRecord(this, new DataRecord(format), format, true);
            }
            catch (DataTableException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public AggreGateBean(TableFormat format, DataRecord data) {
        this.format = format;
        try {
            DataTableConversion.populateBeanFromRecord(this, data, format, true);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public DataTable toDataTable() {
        try {
            return DataTableConversion.beanToTable(this, this.format, true, true);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public DataRecord toDataRecord() {
        try {
            return DataTableConversion.beanToRecord(this, this.format, true, true);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public TableFormat getFormat() {
        return this.format;
    }
}

