/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.AbstractBindingProvider;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.BindingException;
import com.tibbo.aggregate.common.binding.ReferenceListener;
import com.tibbo.aggregate.common.binding.ReferenceWriter;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.ErrorCollector;
import com.tibbo.aggregate.common.util.Util;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractDataTableBindingProvider
extends AbstractBindingProvider {
    public static final String NEW_RECORD_REFERENCE = "record$";
    protected final Map<ReferenceListener, Reference> listeners = new LinkedHashMap<ReferenceListener, Reference>();
    protected final ReentrantReadWriteLock listenersLock = new ReentrantReadWriteLock();

    public AbstractDataTableBindingProvider() {
    }

    public AbstractDataTableBindingProvider(ErrorCollector errorCollector) {
        super(errorCollector);
    }

    public void writeReference(Reference ref, Object value) throws BindingException {
        if (this.isLocalReference(ref) && ref.getServer() == null) {
            int row = ref.getRow() != null ? ref.getRow() : 0;
            String field = ref.getField();
            String property = ref.getProperty();
            if (field == null || field.length() == 0) {
                this.writeToEditor(property, value);
            } else {
                this.writeToField(row, field, property, value);
            }
        } else {
            ReferenceWriter externalReferenceWriter = this.getExternalReferenceWriter();
            if (externalReferenceWriter != null) {
                externalReferenceWriter.writeReference(ref, value);
            } else {
                Log.BINDINGS.debug((Object)("Unable to write value referenced by '" + ref + "': no external reference writer is defined"));
            }
        }
    }

    private void writeToEditor(String property, Object value) {
        if ("enabled".equals(property)) {
            this.setEditorEnabled(Util.convertToBoolean(value, true, false));
        }
    }

    private void writeToField(int row, String field, String property, Object value) throws BindingException {
        if ("enabled".equals(property)) {
            this.setEnabled(value, row, field);
        } else if ("hidden".equals(property)) {
            this.setHidden(value, row, field);
        } else if ("choices".equals(property)) {
            this.setSelectionValues(value, row, field);
        } else if ("options".equals(property)) {
            this.setOptions(value, row, field);
        } else if (property == null) {
            this.setCellValue(value, row, field);
        } else {
            throw new IllegalStateException("Unknown property: '" + property + "'");
        }
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public Map<ReferenceListener, Reference> getListeners() {
        return this.listeners;
    }

    public ReentrantReadWriteLock getListenersLock() {
        return this.listenersLock;
    }

    @Override
    public void addReferenceListener(Reference ref, ReferenceListener listener) throws BindingException {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.put(listener, ref);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    @Override
    public void removeReferenceListener(ReferenceListener listener) {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    public boolean isLocalReference(Reference ref) {
        return ref.getSchema() == null && ref.getContext() == null && ref.getEntity() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBindings(String field, int record, boolean startup, boolean asynchronousProcessing) {
        this.listenersLock.readLock().lock();
        try {
            for (Map.Entry<ReferenceListener, Reference> entry : this.listeners.entrySet()) {
                boolean targetPointsToCurrentField;
                Reference ref = entry.getValue();
                ReferenceListener listener = entry.getKey();
                if (startup && Util.equals(listener.getBinding().getTarget().getSchema(), "table")) continue;
                String rfield = ref.getField();
                boolean nonLocal = !this.isLocalReference(ref);
                String listenerField = listener.getBinding().getTarget().getField();
                boolean bl = targetPointsToCurrentField = listenerField != null && listenerField.equals(field);
                if ((!startup || !nonLocal || !targetPointsToCurrentField) && (rfield == null || !this.isLocalReference(ref) || !rfield.equals(field))) continue;
                if (ref.getRow() != null && ref.getRow() == record) {
                    this.callReferenceChanged(ref, startup ? 1 : 2, listener, asynchronousProcessing);
                }
                if (ref.getRow() != null) continue;
                Reference clone = ref.clone();
                clone.setRow(ref.getSchema() == null || "env".equals(ref.getSchema()) ? Integer.valueOf(record) : null);
                this.callReferenceChanged(clone, startup ? 1 : 2, listener, asynchronousProcessing);
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    @Override
    public List<Reference> getReferences(Binding binding) throws BindingException {
        List<Reference> res = super.getReferences(binding);
        if (res.isEmpty()) {
            res.add(new Reference(NEW_RECORD_REFERENCE));
        }
        return res;
    }

    protected abstract ReferenceWriter getExternalReferenceWriter();

    protected abstract void callReferenceChanged(Reference var1, int var2, ReferenceListener var3, boolean var4);

    protected abstract void setEnabled(Object var1, int var2, String var3) throws BindingException;

    protected abstract void setCellValue(Object var1, int var2, String var3) throws BindingException;

    protected abstract void setOptions(Object var1, int var2, String var3) throws BindingException;

    protected abstract void setSelectionValues(Object var1, int var2, String var3) throws BindingException;

    protected abstract void setHidden(Object var1, int var2, String var3) throws BindingException;

    protected abstract void setEditorEnabled(boolean var1);
}

