/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.google.common.collect.Lists;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.DataTableSorter;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.QueryCondition;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.SortOrder;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.datatable.encoding.KnownFormatCollector;
import com.tibbo.aggregate.common.datatable.field.DataTableFieldFormat;
import com.tibbo.aggregate.common.datatable.field.DateFieldFormat;
import com.tibbo.aggregate.common.datatable.validator.FieldValidator;
import com.tibbo.aggregate.common.datatable.validator.RecordValidator;
import com.tibbo.aggregate.common.datatable.validator.TableValidator;
import com.tibbo.aggregate.common.expression.AbstractReferenceResolver;
import com.tibbo.aggregate.common.expression.DefaultReferenceResolver;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.ElementList;
import com.tibbo.aggregate.common.util.PublicCloneable;
import com.tibbo.aggregate.common.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class AbstractDataTable
implements DataTable,
Cloneable,
PublicCloneable {
    public static final String ELEMENT_ID = "C";
    public static final TableFormat DEFAULT_FORMAT = new TableFormat();
    static final String ELEMENT_RECORD = "R";
    static final String ELEMENT_FIELD_NAME = "N";
    static final String UNSUPPORTED = "This operation is not supported";
    private static final String ELEMENT_FORMAT = "F";
    private static final String ELEMENT_FORMAT_ID = "D";
    private static final String ELEMENT_TIMESTAMP = "T";
    private static final String ELEMENT_QUALITY = "Q";
    private static final String ELEMENT_INVALIDATOR = "I";
    private static final int DEFAULT_ESTIMATE_RECORD_COUNT = 100;
    TableFormat format = DEFAULT_FORMAT;
    Long id = null;
    Integer quality;
    transient Evaluator namingEvaluator;
    transient boolean immutable;
    private Date timestamp;
    private String invalidationMessage;

    void accomplishConstruction(ElementList elements, ClassicEncodingSettings settings, boolean validate) throws DataTableException {
        if (elements == null) {
            return;
        }
        boolean found = false;
        String encodedFormat = null;
        ArrayList<String> fieldNames = null;
        for (Element el : elements) {
            if (el.getName() == null) continue;
            if (el.getName().equals(ELEMENT_FORMAT_ID)) {
                TableFormat format;
                int formatId = Integer.valueOf(el.getValue());
                if (settings.getFormatCache() == null) {
                    throw new IllegalStateException("Can't use format ID - format cache not found");
                }
                if (encodedFormat != null) {
                    format = new TableFormat(encodedFormat, settings, validate);
                    settings.getFormatCache().put(formatId, format);
                    continue;
                }
                format = settings.getFormatCache().get(formatId);
                if (format == null) {
                    throw new IllegalStateException("Format with specified ID not found in the cache: " + formatId);
                }
                this.setFormat(format);
                found = true;
                continue;
            }
            if (el.getName().equals(ELEMENT_FORMAT)) {
                encodedFormat = el.getValue();
                this.setFormat(new TableFormat(encodedFormat, settings, validate));
                found = true;
                continue;
            }
            if (el.getName().equals(ELEMENT_RECORD)) {
                TableFormat format;
                TableFormat tableFormat = found ? this.getFormat() : (format = settings != null ? settings.getFormat() : null);
                if (format == null) {
                    throw new IllegalStateException("Table format is neither found in encoded table nor provided by decoding environment");
                }
                this.addRecord(new DataRecord(format, el.getValue(), settings, validate, fieldNames));
                continue;
            }
            if (el.getName().equals(ELEMENT_FIELD_NAME)) {
                if (fieldNames == null) {
                    fieldNames = new ArrayList<String>();
                }
                fieldNames.add(el.getValue());
                continue;
            }
            if (el.getName().equals(ELEMENT_ID)) {
                this.id = Long.valueOf(el.getValue());
                continue;
            }
            this.decodeAdvancedElement(el, settings);
        }
    }

    void decodeAdvancedElement(Element el, ClassicEncodingSettings settings) {
        if (el.getName().equals(ELEMENT_TIMESTAMP)) {
            if (el.getValue().length() > 4 && el.getValue().charAt(4) == '-') {
                this.timestamp = DateFieldFormat.dateFromString(el.getValue());
            } else {
                Util.convertToDate(el.getValue(), false, false);
            }
        } else if (el.getName().equals(ELEMENT_QUALITY)) {
            this.quality = Util.convertToNumber(el.getValue(), false, false).intValue();
        } else if (el.getName().equals(ELEMENT_INVALIDATOR)) {
            this.invalidationMessage = DataTableUtils.transferDecode(el.getValue(), settings);
        }
    }

    @Override
    public int getFieldCount() {
        return this.format.getFieldCount();
    }

    @Override
    public TableFormat getFormat() {
        return this.format;
    }

    @Override
    public FieldFormat getFormat(int field) {
        return this.getFormat().getField(field);
    }

    @Override
    public FieldFormat getFormat(String name) {
        return this.getFormat().getField(name);
    }

    @Override
    public DataTable setFormat(TableFormat format) {
        if (format != null) {
            this.ensureMutable();
            format.makeImmutable(this);
            this.format = format;
        }
        return this;
    }

    @Override
    public DataTable addRecords(List<DataRecord> records) {
        records.forEach(this::addRecord);
        return this;
    }

    @Override
    public boolean applyCachedFormat(Optional<FormatCache> formatCacheOpt) {
        if (this.format == null) {
            return false;
        }
        if (formatCacheOpt.isPresent()) {
            this.applyCachedFormatRecursively(this, this::getFormat, this::setFormat, formatCacheOpt.get());
            return true;
        }
        return false;
    }

    private void applyCachedFormatRecursively(DataTable source, Supplier<TableFormat> formatGetter, Consumer<TableFormat> formatSetter, FormatCache formatCache) {
        TableFormat tableFormat = formatGetter.get();
        tableFormat.applyCachedFormat(formatCache, formatSetter);
        ArrayList fieldsToBeCached = Lists.newArrayList();
        for (FieldFormat fieldFormat : tableFormat.getFields()) {
            DataTableFieldFormat dataTableFieldFormat;
            if (fieldFormat.getType() != 'T' || (dataTableFieldFormat = (DataTableFieldFormat)fieldFormat).getDefaultValue() == null || DEFAULT_FORMAT == ((DataTable)dataTableFieldFormat.getDefaultValue()).getFormat()) continue;
            fieldsToBeCached.add(fieldFormat.getName());
        }
        for (DataRecord dataRecord : source) {
            for (String tableField : fieldsToBeCached) {
                DataTable innerTable;
                if (!dataRecord.hasField(tableField) || (innerTable = dataRecord.getDataTable(tableField)) == null) continue;
                this.applyCachedFormatRecursively(innerTable, innerTable::getFormat, innerTable::setFormat, formatCache);
            }
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public boolean hasField(String field) {
        return this.format.hasField(field);
    }

    @Override
    public void validate(Context context, ContextManager contextManager, CallerController caller) throws DataTableException {
        if (this.isInvalid()) {
            throw new ValidationException(this.invalidationMessage);
        }
        for (TableValidator tv : this.getFormat().getTableValidators()) {
            tv.validate(this);
        }
        for (DataRecord rec : this) {
            for (RecordValidator rv : this.getFormat().getRecordValidators()) {
                rv.validate(this, rec);
            }
            for (FieldFormat ff : this.getFormat()) {
                List<FieldValidator> fvs = ff.getValidators();
                for (FieldValidator fv : fvs) {
                    try {
                        fv.validate(context, contextManager, caller, rec.getValue(ff.getName()));
                    }
                    catch (ValidationException ex) {
                        throw new ValidationException("Error validating value of field '" + ff + "': " + ex.getMessage(), ex);
                    }
                }
            }
        }
        for (FieldFormat ff : this.getFormat()) {
            if (ff.getType() != 'T') continue;
            for (DataRecord rec : this) {
                DataTable nested = rec.getDataTable(ff.getName());
                if (nested == null) continue;
                nested.validate(context, contextManager, caller);
            }
        }
    }

    @Override
    public void validateRecord(DataRecord record) throws ValidationException {
        for (RecordValidator rv : this.getFormat().getRecordValidators()) {
            rv.validate(this, record);
        }
    }

    void ensureMutable() {
        if (this.immutable) {
            if (Log.DATATABLE.isDebugEnabled()) {
                Log.DATATABLE.warn((Object)"Attempt to change immutable table", (Throwable)new IllegalStateException());
            } else {
                Log.DATATABLE.warn((Object)"Attempt to change immutable table");
            }
            throw new IllegalStateException("Immutable");
        }
    }

    @Override
    public void swapRecords(int index1, int index2) {
        this.ensureMutable();
        DataRecord r1 = this.getRecord(index1);
        DataRecord r2 = this.getRecord(index2);
        this.setRecord(index1, r2);
        this.setRecord(index2, r1);
    }

    @Override
    public List<DataRecord> getRecords() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean isInvalid() {
        return this.invalidationMessage != null;
    }

    @Override
    public String getInvalidationMessage() {
        return this.invalidationMessage;
    }

    @Override
    public void setInvalidationMessage(String invalidationMessage) {
        this.ensureMutable();
        this.invalidationMessage = invalidationMessage;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.ensureMutable();
        this.timestamp = timestamp;
    }

    @Override
    public Integer getQuality() {
        return this.quality;
    }

    @Override
    public void setQuality(Integer quality) {
        this.ensureMutable();
        this.quality = quality;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public DataRecord getRecordById(String id) {
        if (id == null) {
            return null;
        }
        for (DataRecord rec : this) {
            if (rec.getId() == null || !rec.getId().equals(id)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public void removeRecordsByIds(Collection<String> ids) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public DataRecord removeRecord(int index) {
        return this.removeRecordImpl(index);
    }

    protected abstract DataRecord removeRecordImpl(int var1);

    @Override
    public String getEncodedData(ClassicEncodingSettings settings) {
        return this.getEncodedData(new StringBuilder(), settings, false, 1).toString();
    }

    @Override
    public StringBuilder getEncodedData(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        boolean encodeFieldNames;
        boolean bl = encodeFieldNames = settings == null || settings.isEncodeFieldNames();
        if (encodeFieldNames) {
            for (int i = 0; i < this.format.getFieldCount(); ++i) {
                new Element(ELEMENT_FIELD_NAME, this.format.getField(i).getName()).encode(finalSB, settings, isTransferEncode, encodeLevel);
            }
        }
        this.getEncodedRecordsOrTableID(finalSB, settings, isTransferEncode, encodeLevel);
        if (this.quality != null) {
            new Element(ELEMENT_QUALITY, String.valueOf(this.quality)).encode(finalSB, settings, isTransferEncode, encodeLevel);
        }
        if (this.timestamp != null) {
            new Element(ELEMENT_TIMESTAMP, DateFieldFormat.dateToString(this.timestamp)).encode(finalSB, settings, isTransferEncode, encodeLevel);
        }
        return finalSB;
    }

    abstract void getEncodedRecordsOrTableID(StringBuilder var1, ClassicEncodingSettings var2, Boolean var3, Integer var4);

    @Override
    public String encode() {
        return this.encode(new ClassicEncodingSettings(false));
    }

    @Override
    public String encode(boolean useVisibleSeparators) {
        return this.encode(new ClassicEncodingSettings(useVisibleSeparators));
    }

    @Override
    public String encode(ClassicEncodingSettings settings) {
        return this.encode(new StringBuilder(this.getEstimateDataSize()), settings, false, 0).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder encode(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        KnownFormatCollector collector;
        if (finalSB.length() + this.getEstimateDataSize() > finalSB.capacity()) {
            finalSB.ensureCapacity(finalSB.capacity() + this.getEstimateDataSize());
        }
        Integer formatId = null;
        boolean formatWasInserted = false;
        boolean needToInsertFormat = settings != null && settings.isEncodeFormat();
        boolean isKnown = false;
        KnownFormatCollector knownFormatCollector = collector = settings != null ? settings.getKnownFormatCollector() : null;
        if (needToInsertFormat) {
            boolean oldEncodeFormat;
            if (this.getFormat().getFieldCount() > 0 && settings.getFormatCache() != null) {
                formatId = settings.getFormatCache().addIfNotExists(this.getFormat());
                if (collector != null) {
                    needToInsertFormat = false;
                    if (collector.isKnown(formatId) && collector.isMarked(formatId)) {
                        new Element(ELEMENT_FORMAT_ID, formatId.toString()).encode(finalSB, settings, isTransferEncode, encodeLevel);
                        isKnown = true;
                    } else {
                        oldEncodeFormat = settings.isEncodeFormat();
                        try {
                            settings.setEncodeFormat(true);
                            new Element(ELEMENT_FORMAT, this.getFormat()).encode(finalSB, settings, isTransferEncode, encodeLevel);
                            new Element(ELEMENT_FORMAT_ID, formatId.toString()).encode(finalSB, settings, isTransferEncode, encodeLevel);
                            formatWasInserted = true;
                        }
                        finally {
                            settings.setEncodeFormat(oldEncodeFormat);
                        }
                    }
                }
            }
            if (needToInsertFormat) {
                oldEncodeFormat = settings.isEncodeFormat();
                try {
                    settings.setEncodeFormat(true);
                    new Element(ELEMENT_FORMAT, this.getFormat()).encode(finalSB, settings, isTransferEncode, encodeLevel);
                    formatWasInserted = true;
                }
                finally {
                    settings.setEncodeFormat(oldEncodeFormat);
                }
            }
        }
        Boolean oldEncodeFormat = settings != null ? Boolean.valueOf(settings.isEncodeFormat()) : null;
        try {
            if (settings != null && formatWasInserted) {
                settings.setEncodeFormat(false);
            }
            this.getEncodedData(finalSB, settings, isTransferEncode, encodeLevel + 1);
        }
        finally {
            if (oldEncodeFormat != null) {
                settings.setEncodeFormat(oldEncodeFormat);
            }
        }
        if (this.isInvalid()) {
            new Element(ELEMENT_FORMAT, this.invalidationMessage).encode(finalSB, settings, isTransferEncode, encodeLevel);
        }
        if (!isKnown && formatId != null && collector != null) {
            collector.makeKnown(formatId, true);
        }
        return finalSB;
    }

    int getEstimateDataSize() {
        Integer knownRecordCount = this.getRecordCount();
        int recordCount = knownRecordCount != null ? knownRecordCount : 100;
        return this.getFieldCount() * recordCount * 3 + this.getFieldCount() * 7;
    }

    @Override
    public String toString() {
        if (this.getNamingExpression() != null && !this.getNamingExpression().getText().isEmpty()) {
            return this.getDescription();
        }
        return this.toDefaultString();
    }

    @Override
    public String getDescription() {
        Object name;
        Expression namingExpression = this.getNamingExpression();
        if (namingExpression == null || this.getRecordCount() == 0) {
            return this.toDefaultString();
        }
        Evaluator evaluator = this.ensureEvaluator();
        try {
            name = evaluator.evaluate(namingExpression);
        }
        catch (Exception ex) {
            Log.CORE.info((Object)("Error evaluating naming expression of table '" + this.toDefaultString() + "'"), (Throwable)ex);
            return this.toDefaultString();
        }
        return name == null ? null : name.toString();
    }

    private Evaluator ensureEvaluator() {
        if (this.namingEvaluator == null) {
            DefaultReferenceResolver defaultResolver = new DefaultReferenceResolver();
            defaultResolver.setDefaultTable(this);
            this.namingEvaluator = new Evaluator(defaultResolver);
            this.namingEvaluator.setResolver("env", new DataTableReferenceResolver());
        }
        return this.namingEvaluator;
    }

    private Expression getNamingExpression() {
        return this.format == null ? null : this.format.getNamingExpression();
    }

    @Override
    public void fixRecords() {
        this.getFormat().fixRecords(this);
    }

    @Override
    public String dataAsString() {
        return this.dataAsString(true, false, false);
    }

    @Override
    public String dataAsString(boolean showFieldNames, boolean showHiddenFields) {
        return this.dataAsString(showFieldNames, showHiddenFields, false);
    }

    @Override
    public boolean conform(TableFormat rf) {
        return this.conformMessage(rf) == null;
    }

    @Override
    public String conformMessage(TableFormat rf) {
        if (this.getRecordCount() != null && this.getRecordCount() < rf.getMinRecords()) {
            return "Number of records too small: need " + rf.getMinRecords() + " or more, found " + this.getRecordCount();
        }
        if (this.getRecordCount() != null && this.getRecordCount() > rf.getMaxRecords()) {
            return "Number of records too big: need " + rf.getMaxRecords() + " or less, found " + this.getRecordCount();
        }
        return this.getFormat().extendMessage(rf);
    }

    @Override
    public List<DataRecord> selectAll(DataTableQuery query) {
        ArrayList<DataRecord> r = new ArrayList<DataRecord>();
        for (DataRecord rec : this) {
            boolean meet = true;
            for (QueryCondition cond : query.getConditions()) {
                if (rec.meetToCondition(cond)) continue;
                meet = false;
            }
            if (!meet) continue;
            r.add(rec);
        }
        return r;
    }

    @Override
    public DataRecord select(DataTableQuery query) {
        for (DataRecord rec : this) {
            boolean meet = true;
            for (QueryCondition cond : query.getConditions()) {
                if (rec.meetToCondition(cond)) continue;
                meet = false;
            }
            if (!meet) continue;
            return rec;
        }
        return null;
    }

    @Override
    public DataRecord select(String field, Object value) {
        return this.select(new DataTableQuery(new QueryCondition(field, value)));
    }

    @Override
    public Integer findIndex(String field, Object value) {
        return this.findIndex(new DataTableQuery(new QueryCondition(field, value)));
    }

    @Override
    public Integer findIndex(DataRecord record) {
        int index = 0;
        for (DataRecord currentRecord : this) {
            if (currentRecord.equals(record)) {
                return index;
            }
            ++index;
        }
        return null;
    }

    @Override
    public void sort(String field, boolean ascending) {
        this.sort(new DataTableSorter(new SortOrder(field, ascending)));
    }

    @Override
    public DataRecord rec() {
        return this.getRecord(0);
    }

    @Override
    public Object get() {
        return this.rec().getValue(0);
    }

    @Override
    public void splitFormat() {
        for (DataRecord rec : this) {
            rec.cloneFormatFromTable();
        }
    }

    @Override
    public void joinFormats() {
        for (DataRecord rec : this) {
            rec.setFormat(this.getFormat());
        }
    }

    @Override
    public DataTable clone() {
        try {
            return (DataTable)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public void append(DataTable src) {
        for (DataRecord rec : src) {
            this.addRecord(rec);
        }
    }

    @Override
    public DataTable cloneIfImmutable() {
        if (this.isImmutable()) {
            return this.clone();
        }
        return this;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    SimpleDataTable toSimpleDataTable() {
        SimpleDataTable simpleDataTable = new SimpleDataTable(this.format);
        for (DataRecord record : this) {
            simpleDataTable.addRecord(record.clone());
        }
        if (this.getTimestamp() != null) {
            simpleDataTable.setTimestamp(this.getTimestamp());
        }
        if (this.getQuality() != null) {
            simpleDataTable.setQuality(this.getQuality());
        }
        return simpleDataTable;
    }

    @Override
    public void close() {
    }

    @Override
    public Stream<DataRecord> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    static {
        DEFAULT_FORMAT.makeImmutable(null);
    }

    private class DataTableReferenceResolver
    extends AbstractReferenceResolver {
        private DataTableReferenceResolver() {
        }

        @Override
        public Object resolveReference(Reference ref, EvaluationEnvironment resolvingEnvironment) {
            if ("short".equals(ref.getField())) {
                return AbstractDataTable.this.dataAsString(false, false);
            }
            if ("full".equals(ref.getField())) {
                return AbstractDataTable.this.dataAsString(true, false);
            }
            return null;
        }
    }
}

