/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.AbstractDataTable;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;

public abstract class AbstractBigDataTable
extends AbstractDataTable {
    private Integer recordCount;

    @Override
    public Integer getRecordCount() {
        return this.recordCount;
    }

    protected void setRecordCount(Integer recordCount) {
        if (recordCount != null && recordCount < 0) {
            throw new IllegalArgumentException("Record count cannot be negative");
        }
        this.recordCount = recordCount;
    }

    protected void incrementRecordCount() {
        if (this.recordCount == null) {
            return;
        }
        if (this.recordCount == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot increment record count, as it is already equal to the maximum integer value");
        }
        this.recordCount = this.recordCount + 1;
    }

    protected void decrementRecordCount() {
        if (this.recordCount == null) {
            return;
        }
        if (this.recordCount == 0) {
            throw new IllegalStateException("Cannot decrement record count, as it is already equal to zero");
        }
        this.recordCount = this.recordCount - 1;
    }

    @Override
    public void setId(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (this.id == null) {
            this.id = id;
        } else {
            Log.DATATABLE.warn((Object)("An attempt was made to reset table id " + this.id + " with " + id), (Throwable)new Exception());
        }
    }

    @Override
    public int compareTo(DataTable other) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public DataTable makeImmutable() {
        if (this.immutable) {
            return this;
        }
        this.immutable = true;
        this.format.makeImmutable(this);
        return this;
    }

    @Override
    public DataTable clone() {
        SimpleDataTable clone = this.toSimpleDataTable();
        clone.namingEvaluator = null;
        clone.immutable = false;
        if (Log.DATATABLE.isDebugEnabled()) {
            Log.DATATABLE.debug((Object)("The clone method was called; a SimpleDataTable copy of this Data Table was created: " + clone));
        }
        return clone;
    }

    @Override
    protected SimpleDataTable toSimpleDataTable() {
        SimpleDataTable simpleDataTable = new SimpleDataTable(this.format);
        for (DataRecord record : this) {
            simpleDataTable.addRecord(record.clone());
        }
        if (this.getTimestamp() != null) {
            simpleDataTable.setTimestamp(this.getTimestamp());
        }
        if (this.getQuality() != null) {
            simpleDataTable.setQuality(this.getQuality());
        }
        return simpleDataTable;
    }

    @Override
    public boolean isSimple() {
        return false;
    }
}

