/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.data;

import com.tibbo.aggregate.common.Cres;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;

public class TimeZones {
    public static final String DEFAULT_TIME_ZONE_ID = "GMT";
    private static final Map<String, String> ZONES;
    private static final Map<Object, String> SELECTION_VALUES;

    public static Map<String, String> getTimeZones() {
        return ZONES;
    }

    private static String getZoneDesc(String zoneId) {
        TimeZone tz = TimeZone.getTimeZone(zoneId);
        int rawOffset = tz.getRawOffset();
        int hour = rawOffset / 3600000;
        int min = Math.abs(rawOffset / 60000) % 60;
        boolean hasDST = tz.useDaylightTime();
        DecimalFormat form = new DecimalFormat("00");
        return DEFAULT_TIME_ZONE_ID + (hour >= 0 ? "+" : "-") + form.format(Math.abs(hour)) + ":" + form.format(min) + ", " + zoneId + (hasDST ? ", with DST" : "");
    }

    static String getZoneDescSimple(int offset) {
        DecimalFormat form = new DecimalFormat("00");
        return DEFAULT_TIME_ZONE_ID + (offset >= 0 ? "+" : "-") + form.format(Math.abs(offset)) + ":" + form.format(0L);
    }

    public static Map<Object, String> getSelectionValues(boolean allowNotSelected) {
        LinkedHashMap<Object, String> sv = new LinkedHashMap<Object, String>();
        if (allowNotSelected) {
            sv.put(null, Cres.get().getString("notSelected"));
        }
        sv.putAll(SELECTION_VALUES);
        return sv;
    }

    public static final String getDefaultTimezoneId() {
        return Arrays.asList(TimeZone.getAvailableIDs()).contains(TimeZone.getDefault().getID()) ? TimeZone.getDefault().getID() : DEFAULT_TIME_ZONE_ID;
    }

    static {
        int i;
        ZONES = new LinkedHashMap<String, String>();
        SELECTION_VALUES = new LinkedHashMap<Object, String>();
        String[] zoneIds = TimeZone.getAvailableIDs();
        for (i = 0; i < zoneIds.length; ++i) {
            ZONES.put(zoneIds[i], TimeZones.getZoneDesc(zoneIds[i]));
            SELECTION_VALUES.put(zoneIds[i], TimeZones.getZoneDesc(zoneIds[i]));
        }
        for (i = -12; i <= 14; ++i) {
            String desc = TimeZones.getZoneDescSimple(i);
            ZONES.put(desc, desc);
            SELECTION_VALUES.put(desc, desc);
        }
    }
}

