/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.data;

import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.event.PersistenceBinding;
import com.tibbo.aggregate.common.event.PersistenceOptions;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PersistentEvent
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1206684793970688104L;
    public static final String KEY_NAME_PREFIX = "key_";
    private Long id;
    private Date creationtime;
    private Date expirationtime;
    private String context;
    private String name;
    private int level;
    private String permissions;
    private int count;
    private byte[] ack;
    private byte[] format;
    private byte[] data;
    private byte[] enrichments;
    private final Map<String, Object> keys = new HashMap<String, Object>();

    public PersistentEvent() {
    }

    public PersistentEvent(Event event, EventDefinition ed) {
        this();
        PersistenceOptions po = ed != null ? ed.getPersistenceOptions() : null;
        this.id = event.getId();
        this.creationtime = event.getCreationtime();
        this.expirationtime = event.getExpirationtime();
        this.context = event.getContext();
        this.name = event.getName();
        this.level = event.getLevel();
        this.permissions = po != null && po.isPersistPermissions() && event.getPermissions() != null ? event.getPermissions().encode() : null;
        this.count = event.getCount();
        if (po != null && po.isPersistAcknowledgements() && event.getAcknowledgements().size() != 0) {
            this.ack = event.getAcknowledgementsTable().encode().getBytes(StringUtils.UTF8_CHARSET);
        }
        if (po != null && po.isPersistEnrichments() && event.getEnrichments().size() != 0) {
            this.enrichments = event.getEnrichmentsTable().encode().getBytes(StringUtils.UTF8_CHARSET);
        }
        boolean includeFormat = po != null && po.isPersistFormat() ? (ed != null ? ed.getFormat() == null : true) : false;
        this.format = includeFormat ? event.getData().getFormat().encode(false).getBytes(StringUtils.UTF8_CHARSET) : null;
        this.data = po != null && po.isPersistData() ? event.getData().getEncodedData(new ClassicEncodingSettings(false, true)).getBytes(StringUtils.UTF8_CHARSET) : new byte[]{};
    }

    public Long getId() {
        return this.id;
    }

    public Date getCreationtime() {
        return this.creationtime;
    }

    public String getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Date getExpirationtime() {
        return this.expirationtime;
    }

    public byte[] getAck() {
        return this.ack;
    }

    public void setAck(byte[] ack) {
        this.ack = ack;
    }

    public byte[] getEnrichments() {
        return this.enrichments;
    }

    public void setEnrichments(byte[] enrichments) {
        this.enrichments = enrichments;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreationtime(Date creationtime) {
        this.creationtime = creationtime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setExpirationtime(Date expirationtime) {
        this.expirationtime = expirationtime;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String perms) {
        this.permissions = perms;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count != null ? count : 1;
    }

    public byte[] getFormat() {
        return this.format;
    }

    public void setFormat(byte[] format) {
        this.format = format;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Object getKey(String name) {
        return this.keys.get(name);
    }

    public void setKey(String name, Object value) {
        this.keys.put(name, value);
    }

    public Map<String, Object> getKeys() {
        return this.keys;
    }

    public PersistentEvent clone() {
        try {
            return (PersistentEvent)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentEvent other = (PersistentEvent)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "PersistentEvent [id=" + this.id + ", context=" + this.context + ", name=" + this.name + "]";
    }

    public static String createPersistentFieldName(String databaseField) {
        return KEY_NAME_PREFIX + databaseField;
    }

    public static PersistenceBinding createPersistenceBinding(String databaseFieldName, String databaseFieldType, String databaseIndexName, String eventFieldName) {
        return new PersistenceBinding(databaseFieldName, databaseFieldType, databaseIndexName, eventFieldName != null ? new Expression(new Reference(eventFieldName)).toString() : null);
    }
}

