/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.data;

import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.event.Acknowledgement;
import com.tibbo.aggregate.common.event.Enrichment;
import com.tibbo.aggregate.common.security.Permissions;
import com.tibbo.aggregate.common.util.CloneUtils;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class Event
implements Cloneable {
    public static final long DEFAULT_EVENT_EXPIRATION_PERIOD = 8640000000L;
    private Long id;
    private final Date instantiationtime = new Date();
    private Date creationtime;
    private Date expirationtime;
    private String context;
    private String name;
    private List<Acknowledgement> acknowledgements = new LinkedList<Acknowledgement>();
    private DataTable data = null;
    private Integer listener;
    private int level;
    private Permissions permissions;
    private int count = 1;
    private List<Enrichment> enrichments = new LinkedList<Enrichment>();
    private Object originator;
    private String deduplicationId;
    private Long sessionID;
    private String serverID = null;
    private String userSessionId;

    public Event() {
        this.setCreationtime(new Date(System.currentTimeMillis()));
    }

    public Event(String context, EventDefinition def, int level, DataTable data, Long id, Date creationtime, Permissions permissions) {
        this();
        this.init(context, def.getName(), level, data, id);
        this.name = def.getName();
        this.permissions = permissions;
        if (creationtime != null) {
            this.creationtime = creationtime;
        }
        if (def.getExpirationPeriod() > 0L) {
            this.setExpirationtime(new Date(System.currentTimeMillis() + def.getExpirationPeriod()));
        }
    }

    public Event(String context, String name, int level, DataTable data, Long id) {
        this();
        this.init(context, name, level, data, id);
    }

    private void init(String context, String name, int level, DataTable data, Long id) {
        this.context = context;
        this.name = name;
        this.level = level;
        this.data = data;
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public Date getInstantiationtime() {
        return this.instantiationtime;
    }

    public Date getCreationtime() {
        return this.creationtime;
    }

    public String getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Date getExpirationtime() {
        return this.expirationtime;
    }

    public DataTable getAcknowledgementsTable() {
        try {
            return DataTableConversion.beansToTable(this.acknowledgements, Acknowledgement.FORMAT, false);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public DataTable getEnrichmentsTable() {
        try {
            return DataTableConversion.beansToTable(this.enrichments, Enrichment.FORMAT, false);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setAcknowledgementsTable(DataTable data) {
        try {
            this.acknowledgements = DataTableConversion.beansFromTable(data, Acknowledgement.class, Acknowledgement.FORMAT, false);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setEnrichmentsTable(DataTable data) {
        try {
            this.enrichments = DataTableConversion.beansFromTable(data, Enrichment.class, Enrichment.FORMAT, false);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void addAcknowledgement(Acknowledgement ack) {
        this.acknowledgements.add(ack);
    }

    public List<Acknowledgement> getAcknowledgements() {
        return this.acknowledgements;
    }

    public void addEnrichment(Enrichment enrichment) {
        this.enrichments.add(enrichment);
    }

    public List<Enrichment> getEnrichments() {
        return this.enrichments;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreationtime(Date creationtime) {
        this.creationtime = creationtime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setExpirationtime(Date expirationtime) {
        this.expirationtime = expirationtime;
    }

    public void setData(DataTable data) {
        this.data = data;
    }

    public void setListener(Integer listener) {
        this.listener = listener;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setOriginator(Object originator) {
        this.originator = originator;
    }

    public DataTable getData() {
        return this.data;
    }

    public Integer getListener() {
        return this.listener;
    }

    public int getLevel() {
        return this.level;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public Object getOriginator() {
        return this.originator;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getDeduplicationId() {
        return this.deduplicationId;
    }

    public void setDeduplicationId(String deduplicationId) {
        this.deduplicationId = deduplicationId;
    }

    public Long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(Long sessionID) {
        this.sessionID = sessionID;
    }

    public String getServerID() {
        return this.serverID;
    }

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    @Nullable
    public String getUserSessionId() {
        return this.userSessionId;
    }

    public void setUserSessionId(String userSessionId) {
        this.userSessionId = userSessionId;
    }

    public Event clone() {
        try {
            Event clone = (Event)super.clone();
            clone.acknowledgements = (List)CloneUtils.deepClone(this.acknowledgements);
            clone.enrichments = (List)CloneUtils.deepClone(this.enrichments);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (this.id == null || other.id == null) {
            return false;
        }
        return this.id.equals(other.id);
    }

    public String toString() {
        String dataSting = this.data != null ? (!this.data.isSimple() ? this.data.dataAsString() : this.data.toString()) : "no data";
        return "Event '" + this.name + "' in context '" + this.context + "' with ID " + this.id + ": " + dataSting + (this.listener != null ? ", for listener '" + this.listener + "'" : "");
    }
}

