/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.data;

import com.google.common.base.Splitter;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.util.CloneUtils;
import com.tibbo.aggregate.common.util.PublicCloneable;
import com.tibbo.aggregate.common.util.StringEncodable;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.net.util.Base64;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Data
implements Cloneable,
PublicCloneable,
StringEncodable {
    private static final int TRANSCODER_VERSION = 0;
    public static final Float BUFFER_MULTIPLIER = Float.valueOf(1.15f);
    private static final char SEPARATOR = '/';
    private static final String NULL = "null";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PREVIEW = "preview";
    private static final String DATA = "data";
    private static final String SHALLOW_COPY = "shallowCopy";
    private Long id;
    private String name;
    private byte[] preview;
    private byte[] data;
    private boolean shallowCopy = false;
    private Map<String, Object> attachments = new HashMap<String, Object>();

    public Data() {
    }

    public Data(Long id) {
        this.id = id;
    }

    public Data(byte[] data) {
        this.data = data;
    }

    public Data(String name, byte[] data) {
        this(data);
        this.name = name;
    }

    public Data(String value) {
        int dataLen;
        int previewLen;
        if (value.length() == 0) {
            return;
        }
        if (this.isJson(value)) {
            this.fromJsonString(value);
            return;
        }
        List parts = Splitter.on((char)'/').limit(6).splitToList((CharSequence)value);
        if (!((String)parts.get(1)).equals(DataTableUtils.DATA_TABLE_NULL)) {
            this.setId(Long.valueOf((String)parts.get(1)));
        }
        if (!((String)parts.get(2)).equals(DataTableUtils.DATA_TABLE_NULL)) {
            this.setName((String)parts.get(2));
        }
        if ((previewLen = Integer.valueOf((String)parts.get(3)).intValue()) != -1 && previewLen <= ((String)parts.get(5)).length()) {
            this.setPreview(((String)parts.get(5)).substring(0, previewLen).getBytes(StringUtils.ASCII_CHARSET));
        }
        if ((dataLen = Integer.valueOf((String)parts.get(4)).intValue()) != -1 && previewLen <= ((String)parts.get(5)).length()) {
            this.setData(((String)parts.get(5)).substring(previewLen <= 0 ? 0 : previewLen).getBytes(StringUtils.ASCII_CHARSET));
        }
    }

    private boolean isJson(String value) {
        try {
            JSONParser parser = new JSONParser();
            parser.parse(value);
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    private void fromJsonString(String json) {
        String data2;
        String preview;
        String name;
        String id;
        HashMap dataMap = new HashMap();
        String formattedString = json.replace("{", "").replace("}", "").replace("\"", "").replace(" ", "");
        List<String> dataList = Arrays.asList(formattedString.split(","));
        dataList.forEach(data -> {
            String[] pair = data.split(":");
            if (pair.length == 2) {
                dataMap.put(pair[0], pair[1]);
            }
        });
        if (dataMap.containsKey(ID) && !(id = (String)dataMap.get(ID)).equals(NULL)) {
            this.setId(Long.parseLong(id));
        }
        if (dataMap.containsKey(NAME) && !(name = (String)dataMap.get(NAME)).equals(NULL)) {
            this.setName((String)dataMap.get(NAME));
        }
        if (dataMap.containsKey(PREVIEW) && !(preview = (String)dataMap.get(PREVIEW)).equals(NULL)) {
            this.setPreview(((String)dataMap.get(PREVIEW)).getBytes());
        }
        if (dataMap.containsKey(DATA) && !(data2 = (String)dataMap.get(DATA)).equals(NULL) && Base64.isArrayByteBase64((byte[])data2.getBytes())) {
            this.setData(Base64.decodeBase64((String)((String)dataMap.get(DATA))));
        }
        if (dataMap.containsKey(SHALLOW_COPY) && !(data2 = (String)dataMap.get(SHALLOW_COPY)).equals(NULL)) {
            this.setShallowCopy(Boolean.parseBoolean((String)dataMap.get(SHALLOW_COPY)));
        }
    }

    public void setPreview(byte[] preview) {
        this.preview = preview;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setBlob(byte[] blob) {
        this.data = blob;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getPreview() {
        return this.preview;
    }

    public String getName() {
        return this.name;
    }

    public Long getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getBlob() {
        return this.data;
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    public void setShallowCopy(boolean shallowCopy) {
        this.shallowCopy = shallowCopy;
    }

    public boolean isShallowCopy() {
        return this.shallowCopy;
    }

    public byte[] fetchData(ContextManager cm, CallerController cc) throws ContextException {
        if (this.getData() != null) {
            return this.getData();
        }
        if (this.getId() == null) {
            return null;
        }
        if (cm == null) {
            return null;
        }
        DataTable dt = cm.get("utilities", cc).callFunction("getData", cc, this.getId());
        byte[] receivedData = dt.rec().getData(DATA).getData();
        this.setData(receivedData);
        return receivedData;
    }

    public byte[] fetchPreviewData(ContextManager cm, CallerController cc) throws ContextException {
        if (this.getPreview() != null) {
            return this.getPreview();
        }
        if (this.getId() == null) {
            return null;
        }
        if (cm == null) {
            return null;
        }
        DataTable dt = cm.get("utilities", cc).callFunction("getData", cc, this.getId());
        byte[] receivedData = dt.rec().getData(DATA).getPreview();
        this.setPreview(receivedData);
        return receivedData;
    }

    private int checksum(byte[] bytes) {
        int sum = 0;
        for (byte b : bytes) {
            sum += b;
        }
        return sum;
    }

    public String toDetailedString() {
        return "Data [id: " + (this.id != null ? this.id : NULL) + ", name: " + (this.name != null ? this.id : NULL) + ", preview: " + (this.preview != null ? "len=" + this.preview.length + " checksum=" + this.checksum(this.preview) : NULL) + ", data: " + (this.data != null ? "len=" + this.data.length + " checksum=" + this.checksum(this.data) : NULL) + "]";
    }

    public String toString() {
        return "Data [id: " + (this.id != null ? this.id : NULL) + ", name: " + (this.name != null ? this.name : NULL) + ", preview: " + (this.preview != null ? "len=" + this.preview.length : NULL) + ", data: " + (this.data != null ? "len=" + this.data.length : "null, shallow copy: " + this.shallowCopy) + "]";
    }

    public String toJsonString() {
        return "{\"id\": " + (this.id != null ? "\"" + this.id + "\"" : NULL) + ", \"name\": " + (this.name != null ? "\"" + this.name + "\"" : NULL) + ", \"preview\": \"" + (this.preview != null ? "len=" + this.preview.length : NULL) + "\", \"data\": " + (this.data != null ? "\"" + Base64.encodeBase64StringUnChunked((byte[])this.data) + "\"" : NULL) + ", \"shallow copy\": " + this.shallowCopy + "}";
    }

    public String toCleanString() {
        return this.toCleanString(StandardCharsets.ISO_8859_1);
    }

    public String toCleanString(Charset charset) {
        return this.data != null ? new String(this.data, charset) : NULL;
    }

    @Override
    public Data clone() {
        Data cl = null;
        try {
            cl = (Data)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        if (!this.isShallowCopy()) {
            cl.preview = (byte[])CloneUtils.deepClone(this.preview);
            cl.data = (byte[])CloneUtils.deepClone(this.data);
        }
        return cl;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Data) {
            Data od = (Data)obj;
            return Util.equals(this.id, od.id) && Util.equals(this.name, od.name) && Arrays.equals(od.preview, this.preview) && Arrays.equals(this.data, od.data);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.preview == null ? 0 : this.preview.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public void setAttachments(Map<String, Object> attachments) {
        this.attachments = attachments;
    }

    public String encode() {
        return this.encode(new StringBuilder(), null, false, 0).toString();
    }

    @Override
    public StringBuilder encode(StringBuilder sb, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        if ((float)sb.length() + (float)this.estimateDataSize() * BUFFER_MULTIPLIER.floatValue() > (float)sb.capacity()) {
            sb.ensureCapacity((int)((float)sb.capacity() + (float)this.estimateDataSize() * BUFFER_MULTIPLIER.floatValue()));
        }
        StringBuilder tempSB = new StringBuilder();
        tempSB.append(0);
        tempSB.append('/');
        tempSB.append(this.getId() != null ? String.valueOf(this.getId()) : DataTableUtils.DATA_TABLE_NULL);
        tempSB.append('/');
        tempSB.append(this.getName() != null ? this.getName() : DataTableUtils.DATA_TABLE_NULL);
        tempSB.append('/');
        tempSB.append(this.getPreview() != null ? String.valueOf(this.getPreview().length) : String.valueOf(-1));
        tempSB.append('/');
        tempSB.append(this.getData() != null ? String.valueOf(this.getData().length) : String.valueOf(-1));
        tempSB.append('/');
        if (isTransferEncode.booleanValue()) {
            sb.append(DataTableUtils.transferEncode(tempSB.toString()));
        } else {
            sb.append((CharSequence)tempSB);
        }
        this.appendBytes(sb, this.getPreview(), isTransferEncode, encodeLevel);
        this.appendBytes(sb, this.getData(), isTransferEncode, encodeLevel);
        return sb;
    }

    public int estimateDataSize() {
        Integer size = String.valueOf(Long.MAX_VALUE).length();
        if (this.getName() != null) {
            size = size + this.getName().length();
        }
        if (this.getPreview() != null) {
            size = size + (this.getPreview().length + String.valueOf(this.getPreview().length).length());
        }
        if (this.getData() != null) {
            size = size + (this.getData().length + String.valueOf(this.getData().length).length());
        }
        return size;
    }

    private void appendBytes(StringBuilder sb, byte[] data, boolean isTransferEncode, Integer encodeLevel) {
        if (data != null) {
            Integer newLength = (int)((float)(data.length + sb.length()) * BUFFER_MULTIPLIER.floatValue());
            if (Log.DATATABLE.isDebugEnabled()) {
                Log.DATATABLE.debug((Object)("Data length: " + data.length));
                Log.DATATABLE.debug((Object)("Buffer length: " + sb.length()));
                Log.DATATABLE.debug((Object)("Buffer new length: " + newLength));
            }
            sb.ensureCapacity(newLength);
            for (int i = 0; i <= data.length; i += 0x3200000) {
                int end = i + 0x3200000;
                if (end > data.length) {
                    end = data.length;
                }
                String tempString = new String(ArrayUtils.subarray((byte[])data, (int)i, (int)end), StringUtils.ASCII_CHARSET);
                if (isTransferEncode) {
                    TransferEncodingHelper.encode(tempString, sb, encodeLevel);
                    continue;
                }
                sb.append(tempString);
            }
        }
    }

    public void releaseData() {
        this.data = null;
        this.preview = null;
    }
}

