/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.loader.ContextValidator;
import com.tibbo.aggregate.common.context.loader.ExpressionContextValidator;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import javax.annotation.Nonnull;

public class SmartFilterExpressionValidator
extends ExpressionContextValidator
implements ContextValidator {
    public static final String NAME = "name";
    private final String[] variablesForEvaluation = new String[]{"childInfo", "visibleInfo"};

    public SmartFilterExpressionValidator(@Nonnull ContextManager contextManager, @Nonnull CallerController caller, @Nonnull Expression smartFilterExpression, @Nonnull Reference reference) {
        super(contextManager, caller, smartFilterExpression, reference);
    }

    @Override
    protected boolean evaluate(String contextPath, Context context, Evaluator evaluator) {
        DataTable defaultTable = this.prepareDefaultTableForPath(context.getPath());
        evaluator.setDefaultTable(defaultTable);
        try {
            if (evaluator.evaluateToBoolean(this.validityExpression, context, this.reference).booleanValue()) {
                return true;
            }
        }
        catch (EvaluationException | SyntaxErrorException e) {
            Log.CONTEXT_CHILDREN.debug((Object)("Unable to evaluate children filter expression fo the context: " + contextPath), (Throwable)e);
        }
        for (String variable : this.variablesForEvaluation) {
            try {
                defaultTable = context.getVariable(variable, this.caller).clone();
            }
            catch (ContextException e) {
                Log.CONTEXT_CHILDREN.debug((Object)("Unable to get defaultTable for the context: " + contextPath), (Throwable)e);
                continue;
            }
            evaluator.setDefaultTable(defaultTable);
            try {
                if (!evaluator.evaluateToBoolean(this.validityExpression, context, this.reference).booleanValue()) continue;
                return true;
            }
            catch (Exception ex) {
                Log.CONTEXT_CHILDREN.debug((Object)("Unable to evaluate children filter expression fo the context: " + contextPath), (Throwable)ex);
            }
        }
        return false;
    }

    private DataTable prepareDefaultTableForPath(String path) {
        TableFormat format = new TableFormat(1, 1);
        format.addField(FieldFormat.create(NAME, 'S'));
        SimpleDataTable dataTable = new SimpleDataTable(format);
        dataTable.addRecord(path);
        return dataTable;
    }
}

