/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.loader.ContextValidator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RecursiveContextValidator
implements ContextValidator {
    private final ContextManager contextManager;
    private final CallerController callerController;
    private final ContextValidator contextValidator;

    public RecursiveContextValidator(@Nonnull ContextManager contextManager, @Nonnull CallerController callerController, @Nonnull ContextValidator contextValidator) {
        this.contextManager = contextManager;
        this.callerController = callerController;
        this.contextValidator = contextValidator;
    }

    @Override
    public boolean validate(String contextPath) {
        if (this.contextValidator.validate(contextPath)) {
            return true;
        }
        Object context = this.contextManager.get(contextPath, this.callerController);
        if (context == null) {
            return false;
        }
        return this.checkChildrenRecursively((Context)context);
    }

    private boolean checkChildrenRecursively(Context context) {
        List visibleChildren = context.getVisibleChildren(this.callerController);
        for (Context visibleChild : visibleChildren) {
            if (this.contextValidator.validate(visibleChild.getPath())) {
                return true;
            }
            if (!this.checkChildrenRecursively(visibleChild)) continue;
            return true;
        }
        return false;
    }
}

