/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.google.common.base.Strings;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.loader.ContextValidator;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.function.table.UnionFunction;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PropertyVisibleInfoValidator
implements ContextValidator {
    public static final String SEPARATOR = ",";
    private final ContextManager contextManager;
    private final CallerController callerController;
    private final Map<String, List<String>> propertyFilters;

    public PropertyVisibleInfoValidator(@Nonnull ContextManager contextManager, @Nonnull CallerController callerController, @Nonnull Map<String, List<String>> propertyFilters) {
        this.contextManager = contextManager;
        this.callerController = callerController;
        this.propertyFilters = propertyFilters;
    }

    @Override
    public boolean validate(String contextPath) {
        Object context = this.contextManager.get(contextPath, this.callerController);
        if (context == null) {
            return false;
        }
        if (this.propertyFilters.isEmpty()) {
            return true;
        }
        block10: for (String property : this.propertyFilters.keySet()) {
            List<String> filters = this.propertyFilters.get(property);
            if (filters.isEmpty()) continue;
            switch (property) {
                case "name": {
                    if (!PropertyVisibleInfoValidator.isNotMatched(filters, context.getName())) continue block10;
                    return false;
                }
                case "description": {
                    if (!PropertyVisibleInfoValidator.isNotMatched(filters, context.getDescription())) continue block10;
                    return false;
                }
            }
            if (context.getVariableDefinition("childInfo") == null) continue;
            try {
                Object value;
                DataTable childInfo;
                DataTable unionInfo = childInfo = context.getVariable("childInfo", this.callerController);
                if (context.getVariableDefinition("visibleInfo") != null) {
                    DataTable visibleInfo = context.getVariable("visibleInfo", this.callerController);
                    unionInfo = (DataTable)new UnionFunction().execute(null, null, childInfo, visibleInfo);
                }
                if (!unionInfo.hasField(property) || !((value = unionInfo.rec().getValue(property)) instanceof String) || !PropertyVisibleInfoValidator.isNotMatched(filters, (String)value)) continue;
                return false;
            }
            catch (ContextException | EvaluationException e) {
                Log.CONTEXT_CHILDREN.debug((Object)("Unable to evaluate children filter expression fo the context: " + contextPath), (Throwable)e);
            }
        }
        return true;
    }

    private static boolean isNotMatched(List<String> filters, String value) {
        return filters.stream().noneMatch(s -> Stream.of(s.split(SEPARATOR, -1)).anyMatch(Strings.nullToEmpty((String)value)::contains));
    }
}

