/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.tibbo.aggregate.common.context.AbstractContext;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.loader.LoadedContexts;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PageableLoadedContexts
implements LoadedContexts {
    private final List<Context> contexts;
    private final int count;

    public PageableLoadedContexts(@Nonnull List<Context> contexts, int count) {
        this.contexts = contexts;
        this.count = count;
    }

    @Override
    public LoadedContexts getPage(int offset, int count) throws ContextException {
        ArrayList<Context> result = new ArrayList<Context>();
        if (this.count == 0) {
            return new PageableLoadedContexts(result, this.count);
        }
        int lastIndex = Math.min(offset + count, this.count);
        if (offset > this.count - 1) {
            throw new ContextException("Offset cannot be greater then total count!");
        }
        for (int i = offset; i < lastIndex; ++i) {
            result.add(this.contexts.get(i));
        }
        return new PageableLoadedContexts(result, this.count);
    }

    @Override
    public DataTable asDataTable() {
        SimpleDataTable children = new SimpleDataTable(AbstractContext.VFT_VISIBLE_CHILDREN);
        for (Context visibleChild : this.contexts) {
            children.addRecord(visibleChild.getPath());
        }
        SimpleDataTable result = new SimpleDataTable(AbstractContext.FOFT_VISIBLE_CHILDREN);
        result.addRecord(children, this.count);
        return result;
    }

    @Override
    public int getTotalCount() {
        return this.count;
    }

    @Override
    public List<Context> getContexts() {
        return this.contexts;
    }
}

