/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.google.common.base.Strings;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.loader.ContextValidator;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.function.table.UnionFunction;
import java.util.Map;

public class GlobalVisibleInfoValidator
implements ContextValidator {
    private final ContextManager contextManager;
    private final CallerController callerController;
    private final Map<String, String> propertyFilter;

    public GlobalVisibleInfoValidator(ContextManager contextManager, CallerController callerController, Map<String, String> propertyFilter) {
        this.contextManager = contextManager;
        this.callerController = callerController;
        this.propertyFilter = propertyFilter;
    }

    @Override
    public boolean validate(String contextPath) {
        Object context = this.contextManager.get(contextPath, this.callerController);
        if (context == null) {
            return false;
        }
        if (this.propertyFilter.isEmpty()) {
            return true;
        }
        block10: for (Map.Entry<String, String> property : this.propertyFilter.entrySet()) {
            switch (property.getKey()) {
                case "name": {
                    if (!Strings.nullToEmpty((String)context.getName()).contains(property.getValue())) continue block10;
                    return true;
                }
                case "description": {
                    if (!Strings.nullToEmpty((String)context.getDescription()).contains(property.getValue())) continue block10;
                    return true;
                }
            }
            if (context.getVariableDefinition("childInfo") == null) continue;
            try {
                Object value;
                DataTable childInfo;
                DataTable unionInfo = childInfo = context.getVariable("childInfo", this.callerController);
                if (context.getVariableDefinition("visibleInfo") != null) {
                    DataTable visibleInfo = context.getVariable("visibleInfo", this.callerController);
                    unionInfo = (DataTable)new UnionFunction().execute(null, null, childInfo, visibleInfo);
                }
                if (!unionInfo.hasField(property.getKey()) || !((value = unionInfo.rec().getValue(property.getKey())) instanceof String) || !Strings.nullToEmpty((String)((String)value)).contains(property.getValue())) continue;
                return true;
            }
            catch (ContextException | EvaluationException e) {
                Log.CONTEXT_CHILDREN.debug((Object)("Unable to evaluate children filter expression fo the context: " + contextPath), (Throwable)e);
            }
        }
        return false;
    }
}

