/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.loader.ContextLoader;
import com.tibbo.aggregate.common.context.loader.ContextValidator;
import com.tibbo.aggregate.common.context.loader.LoadedContexts;
import com.tibbo.aggregate.common.context.loader.PageableLoadedContexts;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class FilteredContextLoader
implements ContextLoader {
    private final ContextLoader origin;
    private final ContextValidator validator;

    public FilteredContextLoader(@Nonnull ContextLoader origin, @Nonnull ContextValidator validator) {
        this.origin = origin;
        this.validator = validator;
    }

    @Override
    public LoadedContexts load(String parent) throws ContextException {
        LoadedContexts loadedContexts = this.origin.load(parent);
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : loadedContexts.getContexts()) {
            String contextPath = context.getPath();
            if (!this.validator.validate(contextPath)) continue;
            result.add(context);
        }
        return new PageableLoadedContexts(result, result.size());
    }
}

