/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.loader.ContextValidator;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.expression.DefaultReferenceResolver;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.ReferenceResolver;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExpressionContextValidator
implements ContextValidator {
    protected final ContextManager contextManager;
    protected final CallerController caller;
    protected final Expression validityExpression;
    protected final Reference reference;

    public ExpressionContextValidator(@Nonnull ContextManager contextManager, @Nonnull CallerController caller, @Nonnull Expression validityExpression, @Nonnull Reference reference) {
        this.contextManager = contextManager;
        this.caller = caller;
        this.validityExpression = validityExpression;
        this.reference = reference;
    }

    protected DataTable getDefaultTable(Context context) throws ContextException {
        return null;
    }

    @Override
    public boolean validate(String contextPath) {
        Evaluator evaluator = new Evaluator(new DefaultReferenceResolver());
        evaluator.getDefaultResolver().setContextManager(this.contextManager);
        evaluator.getDefaultResolver().setCallerController(this.caller);
        if (this.validityExpression.getText().isEmpty()) {
            return true;
        }
        ReferenceResolver defaultResolver = evaluator.getDefaultResolver();
        CallerController caller = defaultResolver.getCallerController();
        Object context = defaultResolver.getContextManager().get(contextPath, caller);
        if (context == null) {
            return false;
        }
        evaluator.setDefaultContext((Context)context);
        return this.evaluate(contextPath, (Context)context, evaluator);
    }

    protected boolean evaluate(String contextPath, Context context, Evaluator evaluator) {
        DataTable defaultTable = null;
        try {
            defaultTable = this.getDefaultTable(context);
        }
        catch (ContextException e) {
            Log.CONTEXT_CHILDREN.debug((Object)("Unable to get defaultTable for the context: " + contextPath), (Throwable)e);
        }
        if (defaultTable != null) {
            evaluator.setDefaultTable(defaultTable);
        }
        try {
            return evaluator.evaluateToBoolean(this.validityExpression, context, this.reference);
        }
        catch (Exception ex) {
            Log.CONTEXT_CHILDREN.debug((Object)("Unable to evaluate children filter expression fo the context: " + contextPath), (Throwable)ex);
            return false;
        }
    }
}

