/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.google.common.collect.ImmutableMap;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.loader.BaseContextChildrenLoader;
import com.tibbo.aggregate.common.context.loader.BaseContextLoader;
import com.tibbo.aggregate.common.context.loader.ContextLoader;
import com.tibbo.aggregate.common.context.loader.DecoratedContextValidator;
import com.tibbo.aggregate.common.context.loader.ExpressionContextValidator;
import com.tibbo.aggregate.common.context.loader.FilteredContextLoader;
import com.tibbo.aggregate.common.context.loader.GlobalVisibleInfoValidator;
import com.tibbo.aggregate.common.context.loader.LazyContextLoader;
import com.tibbo.aggregate.common.context.loader.MaskContextValidator;
import com.tibbo.aggregate.common.context.loader.PropertyVisibleInfoValidator;
import com.tibbo.aggregate.common.context.loader.RecursiveContextValidator;
import com.tibbo.aggregate.common.context.loader.SmartFilterExpressionValidator;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ContextLoaders {
    public static final TableFormat VFT_PROPERTY_FILTERS = new TableFormat();

    public static ContextLoader createLazyFilteredContextLoader(@Nonnull ContextManager contextManager, @Nonnull CallerController caller, @Nonnull String expression, @Nonnull String mask, @Nonnull Integer offset, @Nonnull Integer count) {
        DecoratedContextValidator validator = ContextLoaders.createDecoratedContextValidator(contextManager, caller, expression, mask, (Map<String, List<String>>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), "");
        return new LazyContextLoader(new FilteredContextLoader(new BaseContextLoader(contextManager, caller), validator), offset, count);
    }

    public static ContextLoader createFilteredChildrenContextLoader(@Nonnull ContextManager contextManager, @Nonnull CallerController caller, @Nonnull String expression, @Nonnull String mask, @Nonnull Map<String, List<String>> propertyFilters, @Nonnull Map<String, String> globalFilters, @Nonnull String smartFilterExpression) {
        RecursiveContextValidator validator = new RecursiveContextValidator(contextManager, caller, ContextLoaders.createDecoratedContextValidator(contextManager, caller, expression, mask, propertyFilters, globalFilters, smartFilterExpression));
        return new FilteredContextLoader(new BaseContextChildrenLoader(contextManager, caller), validator);
    }

    private static DecoratedContextValidator createDecoratedContextValidator(@Nonnull ContextManager contextManager, @Nonnull CallerController caller, @Nonnull String expression, @Nonnull String mask, @Nonnull Map<String, List<String>> propertyFilters, @Nonnull Map<String, String> globalFilters, @Nonnull String smartFilterExpression) {
        return new DecoratedContextValidator(new ExpressionContextValidator(contextManager, caller, new Expression(expression), new Reference()), new MaskContextValidator(mask), new PropertyVisibleInfoValidator(contextManager, caller, propertyFilters), new GlobalVisibleInfoValidator(contextManager, caller, globalFilters), new SmartFilterExpressionValidator(contextManager, caller, new Expression(smartFilterExpression), new Reference()));
    }

    static {
        VFT_PROPERTY_FILTERS.addField("<propertyName><S>");
        VFT_PROPERTY_FILTERS.addField("<propertyValue><S>");
    }
}

