/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context.loader;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.DefaultContextVisitor;
import com.tibbo.aggregate.common.context.loader.ContextLoader;
import com.tibbo.aggregate.common.context.loader.LoadedContexts;
import com.tibbo.aggregate.common.context.loader.PageableLoadedContexts;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class BaseContextLoader
implements ContextLoader {
    protected final ContextManager contextManager;
    protected final CallerController callerController;

    public BaseContextLoader(@Nonnull ContextManager contextManager, @Nonnull CallerController callerController) {
        this.contextManager = contextManager;
        this.callerController = callerController;
    }

    @Override
    public LoadedContexts load(String parent) throws ContextException {
        Object parentNode = this.contextManager.get(parent, this.callerController);
        if (parentNode == null) {
            throw new ContextException(Cres.get().getString("conNotAvail") + parentNode);
        }
        final ArrayList<Context> result = new ArrayList<Context>();
        parentNode.accept(new DefaultContextVisitor<Context>(){

            @Override
            public void visit(Context context) {
                result.add(context);
            }
        });
        return new PageableLoadedContexts(result, result.size());
    }
}

