/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.AbstractEntityDefinition;
import com.tibbo.aggregate.common.context.CompatibilityConverter;
import com.tibbo.aggregate.common.context.CompatibilityValidator;
import com.tibbo.aggregate.common.context.VariableGetter;
import com.tibbo.aggregate.common.context.VariableSetter;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.security.Permissions;
import java.util.LinkedList;
import java.util.List;

public class VariableDefinition
extends AbstractEntityDefinition
implements Cloneable,
Comparable<VariableDefinition> {
    public static final int HISTORY_RATE_CHANGES = -1;
    public static final int HISTORY_RATE_ALL = 0;
    public static final int CACHING_NONE = 0;
    public static final int CACHING_HARD = 1;
    public static final int CACHING_SOFT = 2;
    private TableFormat format;
    private boolean readable;
    private boolean writable;
    private boolean hidden;
    private Permissions readPermissions;
    private Permissions writePermissions;
    private String helpId;
    private VariableGetter getter;
    private VariableSetter setter;
    private boolean allowUpdateEvents;
    private Long changeEventsExpirationPeriod;
    private int localCachingMode = 2;
    private Long remoteCacheTime;
    private boolean addPreviousValueToVariableUpdateEvent;
    private Class valueClass;
    private List<CompatibilityConverter> compatibilityConverters = null;
    private boolean persistent = true;
    private DataTable defaultValue;
    private Integer historyRate = 0;
    private CompatibilityValidator compatibilityValidator = null;

    public VariableDefinition(String name, TableFormat format, boolean readable, boolean writable) {
        this.init(name, format, readable, writable, null);
    }

    public VariableDefinition(String name, TableFormat format, boolean readable, boolean writable, String description) {
        this.init(name, format, readable, writable, description);
    }

    public VariableDefinition(String name, TableFormat format, boolean readable, boolean writable, String description, String group) {
        this.init(name, format, readable, writable, description);
        this.setGroup(group);
    }

    private void init(String name, TableFormat format, boolean readable, boolean writable, String description) {
        this.setName(name);
        this.setFormat(format);
        this.readable = readable;
        this.writable = writable;
        this.setDescription(description != null ? description : name);
    }

    public void setFormat(TableFormat format) {
        if (format != null) {
            format.makeImmutable(null);
        }
        this.format = format;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public void setGroup(String group) {
        super.setGroup(group);
        if (group != null) {
            this.allowUpdateEvents = true;
        }
    }

    public void setReadPermissions(Permissions readPermissions) {
        this.readPermissions = readPermissions;
    }

    public void setWritePermissions(Permissions writePermissions) {
        this.writePermissions = writePermissions;
    }

    public void setSetter(VariableSetter setter) {
        this.setter = setter;
    }

    public void setGetter(VariableGetter getter) {
        this.getter = getter;
    }

    public TableFormat getFormat() {
        return this.format;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Permissions getReadPermissions() {
        return this.readPermissions;
    }

    public Permissions getWritePermissions() {
        return this.writePermissions;
    }

    public VariableSetter getSetter() {
        return this.setter;
    }

    public VariableGetter getGetter() {
        return this.getter;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class valueClass) {
        this.valueClass = valueClass;
    }

    public Long getChangeEventsExpirationPeriod() {
        return this.changeEventsExpirationPeriod;
    }

    public void setChangeEventsExpirationPeriod(Long changeEventsExpirationPeriod) {
        this.changeEventsExpirationPeriod = changeEventsExpirationPeriod;
    }

    public boolean isLocalCachingEnabled() {
        return this.localCachingMode != 0;
    }

    public int getLocalCachingMode() {
        return this.localCachingMode;
    }

    public void setLocalCachingMode(int value) {
        this.localCachingMode = value;
    }

    public Long getRemoteCacheTime() {
        return this.remoteCacheTime;
    }

    public void setRemoteCacheTime(Long remoteCacheTime) {
        this.remoteCacheTime = remoteCacheTime;
    }

    public Boolean isAddPreviousValueToVariableUpdateEvent() {
        return this.addPreviousValueToVariableUpdateEvent;
    }

    public void setAddPreviousValueToVariableUpdateEvent(boolean addPreviousValueToVariableUpdateEvent) {
        this.addPreviousValueToVariableUpdateEvent = addPreviousValueToVariableUpdateEvent;
    }

    public DataTable getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(DataTable defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isAllowUpdateEvents() {
        return this.allowUpdateEvents;
    }

    public void setAllowUpdateEvents(boolean allowUpdateEvents) {
        this.allowUpdateEvents = allowUpdateEvents;
    }

    public Integer getHistoryRate() {
        return this.historyRate;
    }

    public void setHistoryRate(Integer historyRate) {
        this.historyRate = historyRate;
    }

    public boolean storeChangesOnlyInHistory() {
        return -1 == this.historyRate;
    }

    public void addCompatibilityConverter(CompatibilityConverter converter) {
        if (this.compatibilityConverters == null) {
            this.compatibilityConverters = new LinkedList<CompatibilityConverter>();
        }
        this.compatibilityConverters.add(converter);
    }

    public List<CompatibilityConverter> getCompatibilityConverters() {
        return this.compatibilityConverters;
    }

    public CompatibilityValidator getCompatibilityValidator() {
        return this.compatibilityValidator;
    }

    public void setCompatibilityValidator(CompatibilityValidator compatibilityValidator) {
        this.compatibilityValidator = compatibilityValidator;
    }

    public VariableDefinition clone() {
        try {
            return (VariableDefinition)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public VariableDefinition cloneIfImmutable() {
        if (this.isImmutable()) {
            return this.clone();
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        result = 31 * result + (this.getHelp() == null ? 0 : this.getHelp().hashCode());
        result = 31 * result + (this.hidden ? 1231 : 1237);
        result = 31 * result + (this.getIconId() == null ? 0 : this.getIconId().hashCode());
        result = 31 * result + (this.helpId == null ? 0 : this.helpId.hashCode());
        result = 31 * result + (this.getIndex() == null ? 0 : this.getIndex().hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.readable ? 1231 : 1237);
        result = 31 * result + (this.writable ? 1231 : 1237);
        result = 31 * result + (this.changeEventsExpirationPeriod == null ? 0 : this.changeEventsExpirationPeriod.hashCode());
        result = 31 * result + (this.readPermissions == null ? 0 : this.readPermissions.hashCode());
        result = 31 * result + (this.writePermissions == null ? 0 : this.writePermissions.hashCode());
        result = 31 * result + (this.persistent ? 1231 : 1237);
        result = 31 * result + (this.historyRate == null ? 0 : this.historyRate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableDefinition other = (VariableDefinition)obj;
        if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        if (this.getGroup() == null ? other.getGroup() != null : !this.getGroup().equals(other.getGroup())) {
            return false;
        }
        if (this.getHelp() == null ? other.getHelp() != null : !this.getHelp().equals(other.getHelp())) {
            return false;
        }
        if (this.hidden != other.hidden) {
            return false;
        }
        if (this.getIconId() == null ? other.getIconId() != null : !this.getIconId().equals(other.getIconId())) {
            return false;
        }
        if (this.helpId == null ? other.helpId != null : !this.helpId.equals(other.helpId)) {
            return false;
        }
        if (this.getIndex() == null ? other.getIndex() != null : !this.getIndex().equals(other.getIndex())) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.changeEventsExpirationPeriod == null ? other.changeEventsExpirationPeriod != null : !this.changeEventsExpirationPeriod.equals(other.changeEventsExpirationPeriod)) {
            return false;
        }
        if (this.readable != other.readable) {
            return false;
        }
        if (this.writable != other.writable) {
            return false;
        }
        if (this.readPermissions == null ? other.readPermissions != null : !this.readPermissions.equals(other.readPermissions)) {
            return false;
        }
        if (this.writePermissions == null ? other.writePermissions != null : !this.writePermissions.equals(other.writePermissions)) {
            return false;
        }
        if (this.persistent != other.persistent) {
            return false;
        }
        return !(this.historyRate == null ? other.historyRate != null : !this.historyRate.equals(other.historyRate));
    }

    @Override
    public int compareTo(VariableDefinition d) {
        if (this.getIndex() != null || d.getIndex() != null) {
            Integer my = this.getIndex() != null ? this.getIndex() : Integer.valueOf(0);
            Integer other = d.getIndex() != null ? d.getIndex() : Integer.valueOf(0);
            return other.compareTo(my);
        }
        return 0;
    }

    @Override
    public Integer getEntityType() {
        return 1;
    }
}

