/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PropertiesLock {
    private final Context context;
    private final Set<String> lockingPropertiesEditorUUIDs = new HashSet<String>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private CallerController lockedBy;

    public PropertiesLock(Context context) {
        this.context = context;
    }

    public String lockedBy() {
        this.rwLock.readLock().lock();
        try {
            String string = this.lockedBy != null ? this.getLockOwnerName(this.lockedBy) : null;
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lock(CallerController caller, String propertiesEditorUUID) throws ContextException {
        Objects.requireNonNull(caller, "Caller must not be null");
        Objects.requireNonNull(propertiesEditorUUID, "Properties Editor UUID must not be null");
        this.rwLock.writeLock().lock();
        try {
            if (this.lockedBy != null && !this.lockedBy.equals(caller)) {
                throw new ContextException(this.getLockedMessage());
            }
            this.lockingPropertiesEditorUUIDs.add(propertiesEditorUUID);
            if (this.lockedBy != null && this.lockedBy.equals(caller)) {
                String string = this.getLockOwnerName(this.lockedBy);
                return string;
            }
            Log.CONTEXT.debug((Object)("Lock for context '" + this.context.getPath() + "' was acquired by: '" + caller + "'"));
            this.lockedBy = caller;
            caller.addLockedContext(this.context);
            String string = this.getLockOwnerName(this.lockedBy);
            return string;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private String getLockedMessage() {
        return MessageFormat.format(Cres.get().getString("conPropLockErrLocked"), this.context.getPath(), this.lockedBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(CallerController caller, String propertiesEditorUUID) throws ContextException {
        Objects.requireNonNull(caller, "Caller must not be null");
        Objects.requireNonNull(propertiesEditorUUID, "Properties Editor UUID must not be null");
        this.rwLock.writeLock().lock();
        try {
            if (!caller.equals(this.lockedBy)) {
                throw new ContextException(this.getLockedMessage());
            }
            this.lockingPropertiesEditorUUIDs.remove(propertiesEditorUUID);
            if (!this.lockingPropertiesEditorUUIDs.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Log.CONTEXT.debug((Object)("Lock for context '" + this.context.getPath() + "' held by '" + this.lockedBy + "' was released"));
            this.lockedBy = null;
            caller.removeLockedContext(this.context);
            boolean bl = true;
            return bl;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void breakLock() {
        this.rwLock.writeLock().lock();
        try {
            if (this.lockedBy != null) {
                Log.CONTEXT.debug((Object)("Lock for context '" + this.context.getPath() + "' held by '" + this.lockedBy + "' was forced"));
                this.lockedBy.removeLockedContext(this.context);
            }
            this.lockedBy = null;
            this.lockingPropertiesEditorUUIDs.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private String getLockOwnerName(CallerController caller) {
        return caller.getEffectiveUsername();
    }
}

