/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.AbstractEntityDefinition;
import com.tibbo.aggregate.common.context.FunctionImplementation;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.security.Permissions;

public class FunctionDefinition
extends AbstractEntityDefinition
implements Cloneable,
Comparable<FunctionDefinition> {
    private TableFormat inputFormat;
    private TableFormat outputFormat;
    private boolean hidden = false;
    private Permissions permissions = null;
    private FunctionImplementation implementation;
    private boolean concurrent = false;

    public FunctionDefinition(String name, TableFormat inputFormat, TableFormat outputFormat) {
        this.init(name, inputFormat, outputFormat, null, null);
    }

    public FunctionDefinition(String name, TableFormat inputFormat, TableFormat outputFormat, String description) {
        this.init(name, inputFormat, outputFormat, description, null);
    }

    public FunctionDefinition(String name, TableFormat inputFormat, TableFormat outputFormat, String description, String group) {
        this.init(name, inputFormat, outputFormat, description, group);
    }

    private void init(String name, TableFormat inputFormat, TableFormat outputFormat, String description, String group) {
        this.setName(name);
        this.setInputFormat(inputFormat);
        this.setOutputFormat(outputFormat);
        this.setDescription(description);
        this.setGroup(group);
    }

    public TableFormat getInputFormat() {
        return this.inputFormat;
    }

    public TableFormat getOutputFormat() {
        return this.outputFormat;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public FunctionImplementation getImplementation() {
        return this.implementation;
    }

    public void setInputFormat(TableFormat inputFormat) {
        if (inputFormat != null) {
            inputFormat.makeImmutable(null);
        }
        this.inputFormat = inputFormat;
    }

    public void setOutputFormat(TableFormat outputFormat) {
        if (outputFormat != null) {
            outputFormat.makeImmutable(null);
        }
        this.outputFormat = outputFormat;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public void setImplementation(FunctionImplementation implementation) {
        this.implementation = implementation;
    }

    public FunctionDefinition clone() {
        try {
            return (FunctionDefinition)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public int compareTo(FunctionDefinition d) {
        if (this.getIndex() != null || d.getIndex() != null) {
            Integer my = this.getIndex() != null ? this.getIndex() : new Integer(0);
            Integer other = d.getIndex() != null ? d.getIndex() : new Integer(0);
            return other.compareTo(my);
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        result = 31 * result + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        result = 31 * result + (this.getHelp() == null ? 0 : this.getHelp().hashCode());
        result = 31 * result + (this.hidden ? 1231 : 1237);
        result = 31 * result + (this.getIndex() == null ? 0 : this.getIndex().hashCode());
        result = 31 * result + (this.inputFormat == null ? 0 : this.inputFormat.hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.outputFormat == null ? 0 : this.outputFormat.hashCode());
        result = 31 * result + (this.implementation == null ? 0 : this.implementation.hashCode());
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionDefinition other = (FunctionDefinition)obj;
        if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (this.getGroup() == null ? other.getGroup() != null : !this.getGroup().equals(other.getGroup())) {
            return false;
        }
        if (this.getHelp() == null ? other.getHelp() != null : !this.getHelp().equals(other.getHelp())) {
            return false;
        }
        if (this.hidden != other.hidden) {
            return false;
        }
        if (this.getIndex() == null ? other.getIndex() != null : !this.getIndex().equals(other.getIndex())) {
            return false;
        }
        if (this.inputFormat == null ? other.inputFormat != null : !this.inputFormat.equals(other.inputFormat)) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.outputFormat == null ? other.outputFormat != null : !this.outputFormat.equals(other.outputFormat)) {
            return false;
        }
        if (this.implementation == null ? other.implementation != null : !this.implementation.equals(other.implementation)) {
            return false;
        }
        return !(this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions));
    }

    @Override
    public Integer getEntityType() {
        return 2;
    }
}

