/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.google.common.base.Strings;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.EntityReference;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.event.EventUtils;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import java.util.Objects;

public class FilteringEntityReference
extends EntityReference {
    protected String filterExpression;

    public FilteringEntityReference(String context, String entity, String filterExpression) {
        super(context, entity);
        this.filterExpression = filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilteringEntityReference that = (FilteringEntityReference)o;
        return Objects.equals(this.filterExpression, that.filterExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filterExpression);
    }

    public boolean pass(Event ev, ContextManager<Context<?>> contextManager, CallerController caller) {
        try {
            if (Strings.isNullOrEmpty((String)this.filterExpression)) {
                return true;
            }
            if (EventUtils.matchesToMask(this.entity, ev.getName()) && ContextUtils.matchesToMask(this.context, ev.getContext())) {
                Evaluator evaluator = new Evaluator(contextManager, caller);
                Context<?> dc = contextManager.get(ev.getContext(), caller);
                evaluator.setDefaultContext(dc);
                evaluator.setDefaultTable(ev.getData());
                return evaluator.evaluateToBoolean(new Expression(this.filterExpression));
            }
        }
        catch (Exception e) {
            Log.EVENTLOG.warn((Object)("Unable to filter an event: " + ev.toString()), (Throwable)e);
        }
        return false;
    }
}

