/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.expression.AbstractReferenceResolver;
import com.tibbo.aggregate.common.expression.EnvironmentReferenceResolver;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.util.Map;

public class EventEnvironmentResolver
extends AbstractReferenceResolver {
    private EnvironmentReferenceResolver resolver;
    private Event ev;

    public EventEnvironmentResolver(EnvironmentReferenceResolver environmentResolver, Event ev) {
        this.resolver = environmentResolver;
        this.ev = ev;
    }

    @Override
    public Object resolveReference(Reference ref, EvaluationEnvironment environment) throws SyntaxErrorException, EvaluationException, ContextException {
        if (ref.getField() != null) {
            switch (ref.getField()) {
                case "id": {
                    return this.ev.getId();
                }
                case "context": {
                    return this.ev.getContext();
                }
                case "event": {
                    return this.ev.getName();
                }
                case "level": {
                    return this.ev.getLevel();
                }
                case "time": {
                    return this.ev.getCreationtime();
                }
                case "acknowledgements": {
                    return this.ev.getAcknowledgementsTable();
                }
                case "enrichments": {
                    return this.ev.getEnrichmentsTable();
                }
                case "value": {
                    return this.ev.getData();
                }
            }
        }
        return this.resolver.resolveReference(ref, environment);
    }

    @Override
    public CallerController getCallerController() {
        return this.resolver.getCallerController();
    }

    @Override
    public Context getDefaultContext() {
        return this.resolver.getDefaultContext();
    }

    @Override
    public ContextManager getContextManager() {
        return this.resolver.getContextManager();
    }

    @Override
    public Integer getDefaultRow() {
        return this.resolver.getDefaultRow();
    }

    @Override
    public DataTable getDefaultTable() {
        return this.resolver.getDefaultTable();
    }

    @Override
    public Evaluator getEvaluator() {
        return this.resolver.getEvaluator();
    }

    @Override
    public void addContextManager(String schema, ContextManager cm) {
        this.resolver.addContextManager(schema, cm);
    }

    @Override
    public void setCallerController(CallerController callerController) {
        this.resolver.setCallerController(callerController);
    }

    @Override
    public void setDefaultContext(Context defaultContext) {
        this.resolver.setDefaultContext(defaultContext);
    }

    @Override
    public void setContextManager(ContextManager contextManager) {
        this.resolver.setContextManager(contextManager);
    }

    @Override
    public void setDefaultRow(Integer defaultRow) {
        this.resolver.setDefaultRow(defaultRow);
    }

    @Override
    public void setDefaultTable(DataTable defaultTable) {
        this.resolver.setDefaultTable(defaultTable);
    }

    public void set(String variable, Object value) {
        this.resolver.set(variable, value);
    }

    @Override
    public void setEvaluator(Evaluator evaluator) {
        this.resolver.setEvaluator(evaluator);
    }

    public Object get(String variable) {
        return this.resolver.get(variable);
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.resolver.setEnvironment(environment);
    }

    public Map<String, Object> getEnvironment() {
        return this.resolver.getEnvironment();
    }
}

