/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.QueuedEvent;
import com.tibbo.aggregate.common.event.FireEventRequestController;
import com.tibbo.aggregate.common.util.NamedThreadFactory;
import com.tibbo.aggregate.common.util.WatchdogHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class EventDispatcher
extends Thread {
    public static final int CONCURRENT_DISPATCHER_KEEP_ALIVE_SECONDS = 10;
    public static final int DEFAULT_DISPATCHER_POOL_SIZE = 50;
    private static final long EVENTS_QUEUING_TIMEOUT = Integer.getInteger("common.context.EventDispatcher.eventsQueuingTimeoutSeconds", 15).intValue();
    private final AtomicLong eventsScheduled = new AtomicLong(0L);
    private final AtomicLong eventsProcessed = new AtomicLong(0L);
    private final String parentThreadName = Thread.currentThread().getName();
    private final BlockingQueue<QueuedEvent> undispatchedEvents;
    private volatile ThreadPoolExecutor dispatcherPool = null;
    private Supplier<ThreadPoolExecutor> concurrentDispatcherSupplier;

    public EventDispatcher(int queueLength, Supplier<ThreadPoolExecutor> concurrentDispatcherSupplier) {
        this(queueLength);
        if (concurrentDispatcherSupplier != null) {
            this.concurrentDispatcherSupplier = concurrentDispatcherSupplier;
        }
    }

    public static ThreadPoolExecutor createConcurrentEventDispatcherPool(int coreSize, int maxCoreSize, int queueLength, String parentThreadName) {
        ThreadPoolExecutor dispatcherPool = new ThreadPoolExecutor(coreSize, maxCoreSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueLength), new NamedThreadFactory("ConcurrentEventDispatcher/" + parentThreadName), new ThreadPoolExecutor.CallerRunsPolicy());
        dispatcherPool.allowCoreThreadTimeOut(true);
        return dispatcherPool;
    }

    private EventDispatcher(int queueLength) {
        this.setName("EventDispatcher/" + this.parentThreadName);
        this.setPriority(9);
        this.undispatchedEvents = new LinkedBlockingQueue<QueuedEvent>(queueLength);
        this.concurrentDispatcherSupplier = () -> EventDispatcher.createConcurrentEventDispatcherPool(50, 50, queueLength, this.parentThreadName);
    }

    public void queue(QueuedEvent ev, FireEventRequestController request) throws InterruptedException {
        int concurrency = ev.getEventData().getDefinition().getConcurrency();
        if (concurrency == EventDefinition.CONCURRENCY_CONCURRENT) {
            this.queueConcurrently(ev);
        } else if (concurrency == EventDefinition.CONCURRENCY_SEQUENTIAL) {
            this.queueSequentially(ev, request);
        } else {
            ev.getEventData().dispatch(ev.getEvent());
            this.registerProcessedEvent();
        }
    }

    private void queueSequentially(QueuedEvent ev, FireEventRequestController request) throws InterruptedException {
        if (Thread.currentThread() == this) {
            this.getDispatcherPool().submit(() -> {
                try {
                    this.queueInternal(ev, request);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        } else {
            this.queueInternal(ev, request);
        }
    }

    private void queueInternal(QueuedEvent ev, FireEventRequestController request) throws InterruptedException {
        if (request != null && request.isSuppressIfNotEnoughMemory()) {
            if (WatchdogHolder.getInstance().isEnoughMemory()) {
                this.enqueueWithTimeout(this.undispatchedEvents, ev);
            } else {
                Log.CONTEXT_EVENTS.warn((Object)("Event '" + ev.getEvent().getName() + "' in context '" + ev.getEvent().getContext() + "' was suppressed due to lack of RAM"));
            }
        } else {
            WatchdogHolder.getInstance().awaitForEnoughMemory();
            this.enqueueWithTimeout(this.undispatchedEvents, ev);
        }
    }

    private void enqueueWithTimeout(BlockingQueue<QueuedEvent> queue, QueuedEvent ev) throws InterruptedException {
        boolean isEventTaken = queue.offer(ev, EVENTS_QUEUING_TIMEOUT, TimeUnit.SECONDS);
        if (!isEventTaken) {
            int remainingCapacity = queue.remainingCapacity();
            int totalCapacity = queue.size() + remainingCapacity;
            throw new RuntimeException(String.format("Failed to enqueue event (id=%d, name=%s, context=%s) within %d seconds. Queue's remaining capacity is %d of %d. If this error repeats, consider increasing extMaxEventQueueLength in server.xml.", ev.getEvent().getId(), ev.getEvent().getName(), ev.getEvent().getContext(), EVENTS_QUEUING_TIMEOUT, remainingCapacity, totalCapacity));
        }
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                QueuedEvent ev;
                try {
                    ev = this.undispatchedEvents.take();
                }
                catch (InterruptedException ex) {
                    break;
                }
                ev.dispatch();
                this.registerProcessedEvent();
            }
            catch (Throwable ex) {
                Log.CONTEXT_EVENTS.fatal((Object)"Unexpected critical error in event dispatcher", ex);
            }
        }
        if (this.dispatcherPool != null) {
            this.dispatcherPool.shutdown();
        }
        Log.CONTEXT_EVENTS.debug((Object)"Stopping event dispatcher");
    }

    private void queueConcurrently(QueuedEvent ev) {
        ev.getEventData().queue(ev);
        if (!ev.getEventData().isDispatching()) {
            ev.getEventData().setDispatching(true);
            this.getDispatcherPool().submit(() -> ev.getEventData().dispatchAll(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolExecutor getDispatcherPool() {
        if (this.dispatcherPool == null) {
            EventDispatcher eventDispatcher = this;
            synchronized (eventDispatcher) {
                if (this.dispatcherPool == null) {
                    this.dispatcherPool = this.concurrentDispatcherSupplier.get();
                }
            }
        }
        return this.dispatcherPool;
    }

    public int getQueueLength() {
        return this.undispatchedEvents.size();
    }

    public long getEventsProcessed() {
        return this.eventsProcessed.get();
    }

    public long getEventsScheduled() {
        return this.eventsScheduled.get();
    }

    public Map<String, Long> getEventQueueStatistics() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (QueuedEvent event : this.undispatchedEvents) {
            String context = event.getEvent().getContext();
            Long count = (Long)result.get(context);
            if (count == null) {
                count = 1L;
            } else {
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
            }
            result.put(context, count);
        }
        return result;
    }

    public void registerIncomingEvent() {
        this.eventsScheduled.incrementAndGet();
    }

    public void registerProcessedEvent() {
        this.eventsProcessed.incrementAndGet();
    }
}

