/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.AbstractEntityDefinition;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.event.PersistenceOptions;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.security.Permissions;
import java.lang.ref.SoftReference;

public class EventDefinition
extends AbstractEntityDefinition
implements Cloneable,
Comparable<EventDefinition> {
    public static int CONCURRENCY_SYNCHRONOUS = 0;
    public static int CONCURRENCY_SEQUENTIAL = 1;
    public static int CONCURRENCY_CONCURRENT = 2;
    private TableFormat format;
    private boolean hidden;
    private Permissions permissions;
    private long expirationPeriod;
    private int level;
    private Permissions firePermissions;
    private int queueLength = 10000;
    private int concurrency = CONCURRENCY_SEQUENTIAL;
    private PersistenceOptions persistenceOptions = new PersistenceOptions();
    private Integer memoryStorageSize;
    private boolean sessionBound = false;
    private String fingerprintExpression;
    private SoftReference<Expression> cachedFingerprintExpression;

    public EventDefinition(String name, TableFormat format) {
        this.init(name, format, null);
    }

    public EventDefinition(String name, TableFormat format, String description) {
        this.init(name, format, description);
    }

    public EventDefinition(String name, TableFormat format, String description, String group) {
        this.init(name, format, description);
        this.setGroup(group);
    }

    private void init(String name, TableFormat format, String description) {
        this.setName(name);
        this.setFormat(format);
        this.setDescription(description);
    }

    public void setFormat(TableFormat format) {
        if (format != null) {
            format.makeImmutable(null);
        }
        this.format = format;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public void setExpirationPeriod(long expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public TableFormat getFormat() {
        return this.format;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public long getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public int getLevel() {
        return this.level;
    }

    public Permissions getFirePermissions() {
        return this.firePermissions;
    }

    public void setFirePermissions(Permissions firePermissions) {
        this.firePermissions = firePermissions;
    }

    public PersistenceOptions getPersistenceOptions() {
        return this.persistenceOptions;
    }

    public Integer getMemoryStorageSize() {
        return this.memoryStorageSize;
    }

    public void setMemoryStorageSize(Integer memoryStorageSize) {
        this.memoryStorageSize = memoryStorageSize;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setSessionBound(boolean sessionBound) {
        this.sessionBound = sessionBound;
    }

    public boolean isSessionBound() {
        return this.sessionBound;
    }

    public EventDefinition clone() {
        try {
            EventDefinition clone = (EventDefinition)super.clone();
            clone.persistenceOptions = this.persistenceOptions.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public int compareTo(EventDefinition d) {
        if (this.getIndex() != null || d.getIndex() != null) {
            Integer my = this.getIndex() != null ? this.getIndex() : new Integer(0);
            Integer other = d.getIndex() != null ? d.getIndex() : new Integer(0);
            return other.compareTo(my);
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        result = 31 * result + (int)(this.expirationPeriod ^ this.expirationPeriod >>> 32);
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        result = 31 * result + (this.getHelp() == null ? 0 : this.getHelp().hashCode());
        result = 31 * result + (this.hidden ? 1231 : 1237);
        result = 31 * result + (this.getIconId() == null ? 0 : this.getIconId().hashCode());
        result = 31 * result + (this.getIndex() == null ? 0 : this.getIndex().hashCode());
        result = 31 * result + this.level;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        result = 31 * result + (this.firePermissions == null ? 0 : this.firePermissions.hashCode());
        result = 31 * result + (this.sessionBound ? 1231 : 1237);
        result = 31 * result + (this.fingerprintExpression == null ? 0 : this.fingerprintExpression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventDefinition other = (EventDefinition)obj;
        if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (this.expirationPeriod != other.expirationPeriod) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        if (this.getGroup() == null ? other.getGroup() != null : !this.getGroup().equals(other.getGroup())) {
            return false;
        }
        if (this.getHelp() == null ? other.getHelp() != null : !this.getHelp().equals(other.getHelp())) {
            return false;
        }
        if (this.hidden != other.hidden) {
            return false;
        }
        if (this.getIconId() == null ? other.getIconId() != null : !this.getIconId().equals(other.getIconId())) {
            return false;
        }
        if (this.getIndex() == null ? other.getIndex() != null : !this.getIndex().equals(other.getIndex())) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions)) {
            return false;
        }
        if (this.firePermissions == null) {
            if (other.firePermissions != null) {
                return false;
            }
        } else {
            if (!this.firePermissions.equals(other.firePermissions)) {
                return false;
            }
            if (this.sessionBound != other.sessionBound) {
                return false;
            }
        }
        if (this.fingerprintExpression == null) {
            return other.fingerprintExpression == null;
        }
        return this.fingerprintExpression.equals(other.fingerprintExpression);
    }

    public String getFingerprintExpression() {
        return this.fingerprintExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFingerprintExpression(String expression) {
        this.fingerprintExpression = expression;
        EventDefinition eventDefinition = this;
        synchronized (eventDefinition) {
            this.cachedFingerprintExpression = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression cacheFingerprintExpression() {
        EventDefinition eventDefinition = this;
        synchronized (eventDefinition) {
            Expression expression;
            Expression expression2 = expression = this.cachedFingerprintExpression != null ? this.cachedFingerprintExpression.get() : null;
            if (expression == null) {
                expression = new Expression(this.fingerprintExpression);
                this.cachedFingerprintExpression = new SoftReference<Expression>(expression);
            }
            return expression;
        }
    }

    public Expression getCachedFingerprintExpression() {
        Expression expression = this.cachedFingerprintExpression != null ? this.cachedFingerprintExpression.get() : null;
        return expression == null ? this.cacheFingerprintExpression() : expression;
    }

    @Override
    public Integer getEntityType() {
        return 4;
    }

    public int getQueueLength() {
        return this.queueLength;
    }

    public void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    public boolean isDebuggingEvaluations() {
        return "evaluation".equals(this.getName());
    }
}

