/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.AbstractContext;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.EventDispatcher;
import com.tibbo.aggregate.common.context.QueuedEvent;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.field.DateFieldFormat;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.ContextEventListenerInfo;
import com.tibbo.aggregate.common.event.ContextEventListenerSet;
import com.tibbo.aggregate.common.event.Enrichment;
import com.tibbo.aggregate.common.util.Util;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public class EventData
implements Comparable<EventData> {
    public static final int UNDISPATCHED_EVENTS_QUEUE_LENGTH = 10000;
    private EventDefinition definition;
    private final ContextEventListenerSet listeners;
    private long subscribeCount;
    private long unsubscribeCount;
    private final List<Event> history = Collections.synchronizedList(new LinkedList());
    private long fireCount;
    private final ReentrantReadWriteLock duplicateProcessingLock = new ReentrantReadWriteLock();
    private BlockingQueue<QueuedEvent> undispatchedEvents;
    private volatile boolean dispatching;
    private long handleOffers;
    private long handleExecutions;

    public EventData(EventDefinition definition, ContextManager contextManager) {
        this.definition = definition;
        this.listeners = new ContextEventListenerSet(contextManager);
    }

    public EventData(EventDefinition definition, AbstractContext context) {
        this.definition = definition;
        this.listeners = new ContextEventListenerSet(context);
    }

    public void registerFiredEvent() {
        ++this.fireCount;
    }

    public void registerHandleOffer() {
        ++this.handleOffers;
    }

    public void registerHandleExecution() {
        ++this.handleExecutions;
    }

    public EventDefinition getDefinition() {
        return this.definition;
    }

    public long getFireCount() {
        return this.fireCount;
    }

    public ReentrantReadWriteLock getDuplicateProcessingLock() {
        return this.duplicateProcessingLock;
    }

    public boolean addListener(ContextEventListener listener, boolean weak) {
        boolean actuallyAdded = this.listeners.addListener(listener, weak);
        if (actuallyAdded) {
            ++this.subscribeCount;
        }
        return actuallyAdded;
    }

    public boolean removeListener(ContextEventListener listener) {
        boolean actuallyRemoved = this.listeners.removeListener(listener);
        if (actuallyRemoved) {
            ++this.unsubscribeCount;
        }
        return actuallyRemoved;
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public boolean hasListeners() {
        return this.listeners.hasListeners();
    }

    public void dispatch(Event event) {
        this.listeners.dispatch(event, this.getDefinition(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event store(Event event, Integer customMemoryStorageSize) {
        Integer memoryStorageSize;
        Integer n = memoryStorageSize = customMemoryStorageSize != null ? customMemoryStorageSize : this.definition.getMemoryStorageSize();
        if (memoryStorageSize == null) {
            return null;
        }
        Event duplicate = null;
        List<Event> list = this.history;
        synchronized (list) {
            Iterator<Event> iterator = this.history.iterator();
            while (iterator.hasNext()) {
                Event cur = iterator.next();
                if (cur.getExpirationtime() != null && cur.getExpirationtime().getTime() < System.currentTimeMillis()) {
                    iterator.remove();
                    continue;
                }
                if (this.history.size() > memoryStorageSize) {
                    iterator.remove();
                    continue;
                }
                if (event.getDeduplicationId() == null || !Util.equals(event.getDeduplicationId(), cur.getDeduplicationId())) continue;
                if (duplicate != null) {
                    Log.CONTEXT_EVENTS.warn((Object)("Event history of event " + event + " contains more than one duplicate with ID: " + event.getDeduplicationId()));
                }
                duplicate = cur;
            }
        }
        if (duplicate == null) {
            if (this.history.size() < memoryStorageSize) {
                this.history.add(event);
            }
            return null;
        }
        Log.CONTEXT_EVENTS.debug((Object)("Found duplicate of event " + event + " (duplicate ID: " + event.getDeduplicationId() + "): " + duplicate));
        if (duplicate.getCount() == 1) {
            duplicate.addEnrichment(new Enrichment("firstOccurrence", DateFieldFormat.dateToString(duplicate.getCreationtime()), duplicate.getCreationtime(), null));
        }
        duplicate.setCreationtime(event.getCreationtime());
        duplicate.setCount(duplicate.getCount() + 1);
        return duplicate;
    }

    public void updateContext(String oldPath, String newPath) {
        for (Event ev : this.history) {
            if (!ev.getContext().equals(oldPath)) continue;
            ev.setContext(newPath);
        }
    }

    public List<Event> getHistory() {
        return new LinkedList<Event>(this.history);
    }

    public String toString() {
        return this.definition + " - " + this.listeners.size() + " listeners";
    }

    @Override
    public int compareTo(EventData d) {
        return this.definition.compareTo(d.getDefinition());
    }

    public void queue(QueuedEvent ev) {
        if (this.undispatchedEvents == null) {
            this.undispatchedEvents = new LinkedBlockingQueue<QueuedEvent>(this.definition.getQueueLength());
        }
        try {
            this.undispatchedEvents.put(ev);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatchAll(EventDispatcher ed) {
        try {
            BlockingQueue<QueuedEvent> blockingQueue = this.undispatchedEvents;
            synchronized (blockingQueue) {
                while (true) {
                    QueuedEvent ev;
                    if (this.undispatchedEvents.size() <= 1) {
                        this.dispatching = false;
                    }
                    if ((ev = (QueuedEvent)this.undispatchedEvents.poll()) == null) {
                        return;
                    }
                    ev.dispatch();
                    ed.registerProcessedEvent();
                }
            }
        }
        finally {
            this.dispatching = false;
        }
    }

    public boolean isDispatching() {
        return this.dispatching;
    }

    public void setDispatching(boolean dispatching) {
        this.dispatching = dispatching;
    }

    public void setDefinition(EventDefinition eventDefinition) {
        this.definition = eventDefinition;
    }

    public long getHandleOffers() {
        return this.handleOffers;
    }

    public long getHandleExecutions() {
        return this.handleExecutions;
    }

    public long getListenersCount() {
        return this.listeners.size();
    }

    public long getSubscribeCount() {
        return this.subscribeCount;
    }

    public long getUnsubscribeCount() {
        return this.unsubscribeCount;
    }

    public long getQueueLength() {
        return this.undispatchedEvents == null ? 0L : (long)this.undispatchedEvents.size();
    }

    public boolean shouldHandle(Event event) {
        return this.listeners.shouldHandle(event);
    }

    public void addListeners(ContextEventListenerSet targetListeners) {
        this.listeners.executeForEachListener(li -> targetListeners.addListener(li.getListener(), li.isWeak()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWithListeners(Consumer<ContextEventListenerInfo> action) {
        ContextEventListenerSet contextEventListenerSet = this.listeners;
        synchronized (contextEventListenerSet) {
            this.listeners.executeForEachListener(action);
        }
    }

    public boolean contains(ContextEventListener listener) {
        return this.listeners.contains(listener);
    }
}

