/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.EntityReference;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class EntityList
implements Cloneable,
Iterable<EntityReference> {
    public static final String FIELD_CONTEXT = "context";
    public static final String FIELD_ENTITY = "entity";
    public static final TableFormat FORMAT = new TableFormat();
    private List<EntityReference> entities = new LinkedList<EntityReference>();

    public EntityList() {
    }

    public EntityList(DataTable data) {
        for (DataRecord rec : data) {
            this.entities.add(new EntityReference(rec.getString(FIELD_CONTEXT), rec.getString(FIELD_ENTITY)));
        }
    }

    public EntityList(String context, String entity) {
        this.add(context, entity);
    }

    public EntityList(EntityReference ref) {
        this.entities.add(ref);
    }

    public boolean includes(EntityReference ref) {
        return this.includes(ref.getContext(), ref.getEntity());
    }

    public boolean includes(String context, String entity) {
        for (EntityReference ref : this.entities) {
            if (!ref.getContext().equals(context) || !ref.getEntity().equals(entity)) continue;
            return true;
        }
        return false;
    }

    public synchronized DataTable toDataTable() {
        SimpleDataTable tab = new SimpleDataTable(FORMAT);
        for (EntityReference ref : this.entities) {
            tab.addRecord().addString(ref.getContext()).addString(ref.getEntity());
        }
        return tab;
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    public EntityReference add(String context, String entity) {
        if (!this.includes(context, entity)) {
            return this.add(new EntityReference(context, entity));
        }
        return null;
    }

    public EntityReference add(EntityReference ref) {
        if (!this.includes(ref)) {
            this.entities.add(ref);
            return ref;
        }
        return null;
    }

    public List<EntityReference> getEntities() {
        return this.entities;
    }

    @Override
    @Nonnull
    public Iterator<EntityReference> iterator() {
        return this.entities.iterator();
    }

    public String toString() {
        return this.entities.toString();
    }

    public EntityList clone() {
        try {
            EntityList clone = (EntityList)super.clone();
            clone.entities = new LinkedList<EntityReference>();
            for (EntityReference er : this.entities) {
                clone.entities.add(er.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entities == null ? 0 : this.entities.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityList other = (EntityList)obj;
        if (this.entities == null) {
            return other.entities == null;
        }
        return this.entities.equals(other.entities);
    }

    static {
        FORMAT.addField("<context><S>");
        FORMAT.addField("<entity><S>");
    }
}

