/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.google.common.base.Preconditions;
import com.tibbo.aggregate.common.context.DefaultRequestOriginator;
import com.tibbo.aggregate.common.context.Originator;
import com.tibbo.aggregate.common.context.RequestController;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.structure.Pinpoint;
import java.util.Optional;
import javax.annotation.Nullable;

public class DefaultRequestController
implements RequestController {
    private final Originator originator = new DefaultRequestOriginator();
    private Long lockTimeout;
    private Evaluator evaluator;
    private String queue;
    private boolean replyRequired = true;
    private boolean loggerRequest;
    @Nullable
    private Pinpoint pinpoint;

    public DefaultRequestController() {
    }

    public DefaultRequestController(boolean loggerRequest) {
        this.loggerRequest = loggerRequest;
    }

    public DefaultRequestController(Long lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public DefaultRequestController(Object originatorObject) {
        this.originator.setOriginatorObject(originatorObject);
    }

    public DefaultRequestController(Evaluator evaluator) {
        this.evaluator = evaluator;
        if (evaluator != null) {
            this.loggerRequest = evaluator.isLoggerRequest();
        }
    }

    public DefaultRequestController(String queue) {
        this.queue = queue;
    }

    @Override
    public Originator getOriginator() {
        return this.originator;
    }

    @Override
    public Long getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    @Override
    public boolean isReplyRequired() {
        return this.replyRequired;
    }

    public void setReplyRequired(boolean replyRequired) {
        this.replyRequired = replyRequired;
    }

    @Override
    public boolean isLoggerRequest() {
        return this.loggerRequest;
    }

    @Override
    public void assignPinpoint(Pinpoint pinpoint) throws IllegalStateException {
        Preconditions.checkState((this.pinpoint == null ? 1 : 0) != 0, (String)"This '%s' already contains pinpoint '%s' but somebody attempted to assign another one: '%s'", (Object)this, (Object)this.pinpoint, (Object)pinpoint);
        this.pinpoint = pinpoint;
    }

    @Override
    public Optional<Pinpoint> obtainPinpoint() {
        return Optional.ofNullable(this.pinpoint);
    }
}

