/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextVisitor;
import java.util.LinkedList;
import java.util.concurrent.Callable;

public abstract class DefaultContextVisitor<T extends Context>
implements ContextVisitor<T> {
    private final boolean concurrent;
    private final boolean visitThenAcceptOrder;
    public LinkedList<Callable<Object>> tasks = new LinkedList();
    private boolean startContext = true;

    public DefaultContextVisitor() {
        this(false);
    }

    public DefaultContextVisitor(boolean concurrent) {
        this(concurrent, true);
    }

    public DefaultContextVisitor(boolean concurrent, boolean visitThenAcceptOrder) {
        this.concurrent = concurrent;
        this.visitThenAcceptOrder = visitThenAcceptOrder;
    }

    @Override
    public boolean isConcurrent() {
        return this.concurrent;
    }

    @Override
    public boolean isCurrentThenChildrenOrder() {
        return this.visitThenAcceptOrder;
    }

    @Override
    public boolean shouldVisit(T context) throws ContextException {
        return !context.isProxy();
    }

    @Override
    public LinkedList<Callable<Object>> getTasks() {
        return this.tasks;
    }

    @Override
    public boolean isStartContext() {
        boolean res = this.startContext;
        this.startContext = false;
        return res;
    }
}

