/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextEventListenerSetProcessor;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextMaskListenersProcessor;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.DefaultContextVisitor;
import com.tibbo.aggregate.common.context.EventData;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.EventDispatcher;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.QueuedEvent;
import com.tibbo.aggregate.common.context.UncheckedCallerController;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.ContextEventListenerSet;
import com.tibbo.aggregate.common.event.EventUtils;
import com.tibbo.aggregate.common.event.FireEventRequestController;
import com.tibbo.aggregate.common.plugin.PluginDirector;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class DefaultContextManager<T extends Context>
implements ContextManager<T> {
    private final boolean async;
    private T rootContext = null;
    private final CallerController callerController = new UncheckedCallerController();
    private EventDispatcher eventDispatcher;
    private boolean eventDispatcherOwner = true;
    private final Map<String, Map<String, ContextEventListenerSet>> eventListeners = new ConcurrentHashMap<String, Map<String, ContextEventListenerSet>>();
    private final Map<String, Map<String, ContextEventListenerSet>> maskListeners = new ConcurrentHashMap<String, Map<String, ContextEventListenerSet>>();
    private final Map<String, Map<String, ContextEventListenerSet>> univocalListeners = new ConcurrentHashMap<String, Map<String, ContextEventListenerSet>>();
    private final ReentrantReadWriteLock maskListenersLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock eventListenersLock = new ReentrantReadWriteLock();
    private ThreadPoolExecutor executorService;
    private boolean started;

    public DefaultContextManager(boolean async) {
        this(async, Integer.MAX_VALUE, null);
    }

    public DefaultContextManager(boolean async, EventDispatcher eventDispatcher) {
        this(async, Integer.MAX_VALUE, null, eventDispatcher);
    }

    public DefaultContextManager(boolean async, int eventQueueLength, Supplier<ThreadPoolExecutor> concurrentDispatcherSupplier) {
        this(async, eventQueueLength, concurrentDispatcherSupplier, null);
    }

    public DefaultContextManager(boolean async, int eventQueueLength, Supplier<ThreadPoolExecutor> concurrentDispatcherSupplier, EventDispatcher eventDispatcher) {
        this.async = async;
        if (eventDispatcher != null) {
            this.eventDispatcher = eventDispatcher;
            this.eventDispatcherOwner = false;
        }
        if (async) {
            this.ensureDispatcher(eventQueueLength, concurrentDispatcherSupplier);
        }
    }

    public DefaultContextManager(T rootContext, boolean async, EventDispatcher eventDispatcher) {
        this(async, eventDispatcher);
        this.setRoot(rootContext);
        this.start();
    }

    public DefaultContextManager(T rootContext, boolean async) {
        this(rootContext, async, null);
    }

    @Override
    public void start() {
        if (this.async && this.eventDispatcherOwner) {
            this.ensureDispatcher(Integer.MAX_VALUE, null);
            this.eventDispatcher.start();
        }
        if (this.rootContext != null) {
            this.rootContext.start();
        }
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
        if (this.eventDispatcher != null && this.eventDispatcherOwner) {
            this.eventDispatcher.interrupt();
            this.eventDispatcher = null;
        }
        if (this.rootContext != null) {
            this.rootContext.stop();
        }
    }

    @Override
    public void restart() {
        this.stop();
        this.start();
    }

    private void ensureDispatcher(int eventQueueLength, Supplier<ThreadPoolExecutor> concurrentDispatcherSupplier) {
        if (this.eventDispatcher == null) {
            this.eventDispatcher = new EventDispatcher(eventQueueLength, concurrentDispatcherSupplier);
        }
    }

    @Override
    public T getRoot() {
        return this.rootContext;
    }

    public void setRoot(T newRoot) {
        this.rootContext = newRoot;
        this.rootContext.setup(this);
        this.contextAdded(newRoot);
    }

    @Override
    public T get(String contextName, CallerController caller) {
        T root = this.getRoot();
        return root != null ? (T)root.get(contextName, caller) : null;
    }

    @Override
    public T get(String contextName) {
        T root = this.getRoot();
        return root != null ? (T)root.get(contextName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addEventListener(String context, String event, ContextEventListener listener, boolean mask, boolean weak) {
        T con = this.get(context, listener.getCallerController());
        if (con != null) {
            List<EventDefinition> events = EventUtils.getEvents(con, event, listener.getCallerController());
            for (EventDefinition ed : events) {
                if (Log.CONTEXT_EVENTS.isDebugEnabled()) {
                    Log.CONTEXT_EVENTS.debug((Object)("Listener: '" + listener + "' was added to the context: '" + context + "' for event: ;" + event + "'"));
                }
                this.addListenerToContext(con, ed.getName(), listener, mask, weak);
            }
            return;
        } else {
            if (mask) return;
            this.eventListenersLock.writeLock().lock();
            try {
                ContextEventListenerSet eel = this.getListeners(context, event);
                if (eel.contains(listener)) return;
                Log.CONTEXT_EVENTS.debug((Object)("Listener: '" + listener + "' was added to the context: '" + context + "' for event: ;" + event + "'"));
                eel.addListener(listener, weak);
                return;
            }
            finally {
                this.eventListenersLock.writeLock().unlock();
            }
        }
    }

    protected void addListenerToContext(T con, String event, ContextEventListener listener, boolean mask, boolean weak) {
        EventDefinition ed = con.getEventDefinition(event, listener.getCallerController());
        if (ed != null) {
            con.addEventListener(event, listener, weak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEventListener(String context, String event, ContextEventListener listener, boolean mask) {
        T con = this.get(context, listener.getCallerController());
        if (con != null) {
            if (con.getEventDefinition(event) != null) {
                this.removeListenerFromContext(con, event, listener, mask);
            }
        } else if (!mask) {
            this.eventListenersLock.writeLock().lock();
            try {
                ContextEventListenerSet eel = this.getListeners(context, event);
                if (eel != null) {
                    eel.removeListener(listener);
                }
            }
            finally {
                this.eventListenersLock.writeLock().unlock();
            }
        }
    }

    protected void removeListenerFromContext(T con, String event, ContextEventListener listener, boolean mask) {
        con.removeEventListener(event, listener);
    }

    @Override
    public void addMaskEventListener(String mask, String event, ContextEventListener listener) {
        this.addMaskEventListener(mask, event, listener, false);
    }

    @Override
    public void addMaskEventListener(String mask, String event, ContextEventListener listener, boolean weak) {
        List<String> contexts = ContextUtils.expandMaskToPaths(mask, this, listener.getCallerController());
        for (String con : contexts) {
            this.addEventListener(con, event, listener, true, weak);
        }
        this.processMaskListeners(mask, event, listeners -> {
            if (Log.CONTEXT_EVENTS.isDebugEnabled()) {
                Log.CONTEXT_EVENTS.debug((Object)("Listener: '" + listener + "' was added to the mask: '" + mask + "' for event: ;" + event + "'"));
            }
            listeners.addListener(listener, weak);
        });
    }

    @Override
    public void removeMaskEventListener(String mask, String event, ContextEventListener listener) {
        List<Context> contexts = ContextUtils.expandMaskToContexts(mask, this, listener.getCallerController());
        for (Context con : contexts) {
            if (!con.isInitializedEvents()) continue;
            List<EventDefinition> events = EventUtils.getEvents(con, event, listener.getCallerController());
            for (EventDefinition ed : events) {
                this.removeEventListener(con.getPath(), ed.getName(), listener, true);
            }
        }
        this.processMaskListeners(mask, event, listeners -> listeners.removeListener(listener));
    }

    protected ContextEventListenerSet getListeners(String context, String event) {
        Map<String, ContextEventListenerSet> cel = this.getContextListeners(context);
        ContextEventListenerSet cels = cel.get(event);
        if (cels == null) {
            cels = new ContextEventListenerSet(this);
            cel.put(event, cels);
        }
        return cels;
    }

    private Map<String, ContextEventListenerSet> getContextListeners(String context) {
        Map<String, ContextEventListenerSet> cel = this.eventListeners.get(context);
        if (cel == null) {
            cel = new ConcurrentHashMap<String, ContextEventListenerSet>();
            this.eventListeners.put(context, cel);
        }
        return cel;
    }

    private void processMaskListeners(String mask, String event, ContextEventListenerSetProcessor processor) {
        this.processContextMaskListeners(mask, cel -> {
            ContextEventListenerSet eel = (ContextEventListenerSet)cel.get(event);
            if (eel == null) {
                eel = new ContextEventListenerSet(this);
                cel.put(event, eel);
            }
            processor.process(eel);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContextMaskListeners(String mask, ContextMaskListenersProcessor contextMaskListenersProcessor) {
        Map<String, Map<String, ContextEventListenerSet>> localListeners = this.maskListeners;
        this.maskListenersLock.writeLock().lock();
        try {
            Map<String, ContextEventListenerSet> cel;
            if (!ContextUtils.isMask(mask)) {
                localListeners = this.univocalListeners;
            }
            if ((cel = localListeners.get(mask)) == null && (cel = localListeners.get(mask)) == null) {
                cel = new ConcurrentHashMap<String, ContextEventListenerSet>();
                localListeners.put(mask, cel);
            }
            contextMaskListenersProcessor.process(cel);
        }
        finally {
            this.maskListenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextAdded(T con) {
        this.eventListenersLock.writeLock().lock();
        try {
            Map<String, ContextEventListenerSet> cel = this.eventListeners.get(con.getPath());
            if (cel != null) {
                for (String event : cel.keySet()) {
                    ContextEventListenerSet cels = cel.get(event);
                    if (con.getEventData(event) == null) continue;
                    cels.executeForEachListener(li -> con.addEventListener(event, li.getListener(), li.isWeak()));
                }
            }
        }
        finally {
            this.eventListenersLock.writeLock().unlock();
        }
        this.processContextListeners(con, contextEventListeners -> this.addMaskListenerToContext(con, contextEventListeners));
    }

    public void addMaskListenerToContext(String mask, T context) {
        this.processContextMaskListeners(mask, contextEventListeners -> this.addMaskListenerToContext(context, contextEventListeners));
    }

    private void addMaskListenerToContext(T con, Map<String, ContextEventListenerSet> contextEventListeners) {
        for (String eventMask : contextEventListeners.keySet()) {
            ContextEventListenerSet listeners = contextEventListeners.get(eventMask);
            listeners.executeForEachListener(li -> {
                List<EventDefinition> events = EventUtils.getEvents(con, eventMask, li.getListener().getCallerController());
                for (EventDefinition ed : events) {
                    this.addListenerToContext(con, ed.getName(), li.getListener(), true, li.isWeak());
                }
            });
        }
    }

    public Set<String> getMaskListenersMasks() {
        this.maskListenersLock.readLock().lock();
        try {
            Sets.SetView setView = Sets.union(this.maskListeners.keySet(), this.univocalListeners.keySet());
            return setView;
        }
        finally {
            this.maskListenersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected int getMaskListenersSize(String mask, String event) {
        int result = 0;
        this.maskListenersLock.readLock().lock();
        try {
            ContextEventListenerSet contextEventListenerSet;
            Map<String, ContextEventListenerSet> cel = this.maskListeners.get(mask);
            if (cel != null && (contextEventListenerSet = cel.get(event)) != null) {
                result += contextEventListenerSet.size();
            }
            if ((cel = this.univocalListeners.get(mask)) != null && (contextEventListenerSet = cel.get(event)) != null) {
                result += contextEventListenerSet.size();
            }
            int n = result;
            return n;
        }
        finally {
            this.maskListenersLock.readLock().unlock();
        }
    }

    @Override
    public void contextRemoved(T con) {
        try {
            con.accept(new DefaultContextVisitor((Context)con){
                final /* synthetic */ Context val$con;
                {
                    this.val$con = context;
                }

                @Override
                public void visit(Context vc) {
                    DefaultContextManager.this.processContextListeners(this.val$con, contextEventListeners -> this.removeListeners(vc, contextEventListeners));
                }

                private void removeListeners(Context vc, Map<String, ContextEventListenerSet> contextMaskListeners) {
                    for (String event : contextMaskListeners.keySet()) {
                        ContextEventListenerSet listeners = contextMaskListeners.get(event);
                        listeners.executeForEachListener(li -> {
                            List<EventDefinition> events = EventUtils.getEvents(vc, event, li.getListener().getCallerController());
                            for (EventDefinition ed : events) {
                                vc.removeEventListener(ed.getName(), li.getListener());
                            }
                        });
                    }
                }
            });
            con.accept(new DefaultContextVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void visit(Context vc) {
                    DefaultContextManager.this.eventListenersLock.writeLock().lock();
                    try {
                        Map cel = DefaultContextManager.this.getContextListeners(vc.getPath());
                        List<EventDefinition> eventDefinitions = vc.getEventDefinitions(DefaultContextManager.this.callerController);
                        for (EventDefinition ed : eventDefinitions) {
                            EventData edata = vc.getEventData(ed.getName());
                            ContextEventListenerSet listeners = (ContextEventListenerSet)cel.get(ed.getName());
                            if (listeners == null) continue;
                            ContextEventListenerSet contextEventListenerSet = listeners;
                            synchronized (contextEventListenerSet) {
                                edata.addListeners(listeners);
                            }
                        }
                        return;
                    }
                    finally {
                        DefaultContextManager.this.eventListenersLock.writeLock().unlock();
                    }
                }
            });
        }
        catch (ContextException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public void contextInfoChanged(T con) {
    }

    @Override
    public void variableAdded(Context con, VariableDefinition vd) {
    }

    @Override
    public void variableRemoved(Context con, VariableDefinition vd) {
    }

    @Override
    public void functionAdded(Context con, FunctionDefinition fd) {
    }

    @Override
    public void functionRemoved(Context con, FunctionDefinition fd) {
    }

    @Override
    public void eventAdded(T con, EventDefinition ed) {
        this.processContextListeners(con, contextEventListeners -> this.addListenerToContext(con, ed, contextEventListeners));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContextListeners(T con, ContextMaskListenersProcessor processor) {
        this.maskListenersLock.writeLock().lock();
        try {
            for (String mask : this.maskListeners.keySet()) {
                if (!ContextUtils.matchesToMask(mask, con.getPath())) continue;
                Map<String, ContextEventListenerSet> contextEventListenerSet = this.maskListeners.get(mask);
                processor.process(contextEventListenerSet);
            }
            if (this.univocalListeners.containsKey(con.getPath())) {
                Map<String, ContextEventListenerSet> contextEventListenerSet = this.univocalListeners.get(con.getPath());
                processor.process(contextEventListenerSet);
            }
        }
        finally {
            this.maskListenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListenerToContext(T con, EventDefinition ed, Map<String, ContextEventListenerSet> contextEventListeners) {
        for (String eventMask : contextEventListeners.keySet()) {
            ContextEventListenerSet listeners;
            if (!EventUtils.matchesToMask(eventMask, ed)) continue;
            ContextEventListenerSet contextEventListenerSet = listeners = contextEventListeners.get(eventMask);
            synchronized (contextEventListenerSet) {
                listeners.executeForEachListener(li -> this.addListenerToContext(con, ed.getName(), li.getListener(), true, li.isWeak()));
            }
        }
    }

    @Override
    public void eventRemoved(Context con, EventDefinition ed) {
    }

    @Override
    public void queue(EventData ed, Event ev, FireEventRequestController request) {
        EventDispatcher dispatcher = this.eventDispatcher;
        if (dispatcher != null) {
            dispatcher.registerIncomingEvent();
        }
        if (!this.async || ed.getDefinition().getConcurrency() == EventDefinition.CONCURRENCY_SYNCHRONOUS) {
            ed.dispatch(ev);
            if (dispatcher != null) {
                dispatcher.registerProcessedEvent();
            }
        } else {
            if (!this.haveToBeProcessed(ed, ev)) {
                if (dispatcher != null) {
                    dispatcher.registerProcessedEvent();
                }
                return;
            }
            QueuedEvent qe = new QueuedEvent(ed, ev);
            try {
                if (dispatcher != null) {
                    dispatcher.queue(qe, request);
                }
            }
            catch (InterruptedException ex1) {
                Log.CONTEXT_EVENTS.debug((Object)("Interrupted while queueing event: " + ev));
            }
            catch (NullPointerException ex1) {
                Log.CONTEXT_EVENTS.debug((Object)("Cannot queue event '" + ev + "': context manager is not running"));
            }
        }
    }

    private boolean haveToBeProcessed(EventData eventData, Event event) {
        if (!this.isStarted()) {
            return true;
        }
        if (!eventData.hasListeners()) {
            return false;
        }
        return eventData.shouldHandle(event);
    }

    protected void setExecutorService(ThreadPoolExecutor executorService) {
        this.executorService = executorService;
    }

    @Override
    public ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    @Override
    public CallerController getCallerController() {
        return this.callerController;
    }

    @Override
    public int getEventQueueLength() {
        return this.eventDispatcher != null ? this.eventDispatcher.getQueueLength() : 0;
    }

    @Override
    public long getEventsScheduled() {
        return this.eventDispatcher != null ? this.eventDispatcher.getEventsScheduled() : 0L;
    }

    @Override
    public long getEventsProcessed() {
        return this.eventDispatcher != null ? this.eventDispatcher.getEventsProcessed() : 0L;
    }

    @Override
    public Map<String, Long> getEventQueueStatistics() {
        return this.eventDispatcher.getEventQueueStatistics();
    }

    @Override
    public PluginDirector getPluginDirector() {
        return null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }
}

