/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.EventEnvironmentResolver;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.EventHandlingException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;

public abstract class DefaultContextEventListener<T extends CallerController>
implements ContextEventListener {
    private T callerController;
    private ContextManager contextManager;
    private Integer listenerCode;
    private Expression filter;
    private boolean acceptEventsWithoutListenerCode;
    private String fingerprint;

    public DefaultContextEventListener() {
    }

    public DefaultContextEventListener(T callerController) {
        this();
        this.callerController = callerController;
    }

    public DefaultContextEventListener(T callerController, Integer listenerCode) {
        this(callerController);
        this.listenerCode = listenerCode;
    }

    public DefaultContextEventListener(T callerController, ContextManager contextManager, Integer listenerCode, Expression filter) {
        this(callerController, listenerCode);
        this.contextManager = contextManager;
        this.filter = filter;
    }

    public DefaultContextEventListener(T callerController, ContextManager contextManager, Integer listenerCode, Expression filter, String fingerprint) {
        this(callerController, contextManager, listenerCode, filter);
        this.fingerprint = fingerprint;
    }

    public DefaultContextEventListener(Integer listenerCode) {
        this();
        this.listenerCode = listenerCode;
    }

    public DefaultContextEventListener(Integer listenerCode, boolean acceptEventsWithoutListenerCode) {
        this();
        this.listenerCode = listenerCode;
        this.acceptEventsWithoutListenerCode = acceptEventsWithoutListenerCode;
    }

    @Override
    public boolean shouldHandle(Event ev) throws EventHandlingException {
        if (this.filter != null) {
            Evaluator evaluator = new Evaluator(this.getLocalContextManager(), null, null, null);
            evaluator.getDefaultResolver().setContextManager(this.contextManager);
            this.prepareEvaluator(evaluator, ev);
            try {
                if (!evaluator.evaluateToBoolean(this.filter).booleanValue()) {
                    return false;
                }
            }
            catch (Exception ex) {
                throw new EventHandlingException(ex.getMessage(), ex);
            }
        }
        if (this.listenerCode != null) {
            if (ev.getListener() != null && !this.listenerCode.equals(ev.getListener())) {
                return false;
            }
            return ev.getListener() != null || this.acceptEventsWithoutListenerCode;
        }
        return ev.getListener() == null || this.acceptEventsWithoutListenerCode;
    }

    private void prepareEvaluator(Evaluator evaluator, Event ev) {
        EventEnvironmentResolver resolver = new EventEnvironmentResolver(evaluator.getEnvironmentResolver(), ev);
        evaluator.setResolver("env", resolver);
        evaluator.getDefaultResolver().setDefaultTable(ev.getData());
        evaluator.getDefaultResolver().setCallerController((CallerController)this.getCallerController());
    }

    public T getCallerController() {
        return this.callerController;
    }

    public ContextManager getLocalContextManager() {
        return this.contextManager;
    }

    @Override
    public Integer getListenerCode() {
        return this.listenerCode;
    }

    @Override
    public void setListenerCode(Integer listenerCode) {
        this.listenerCode = listenerCode;
    }

    public void setCallerController(T callerController) {
        this.callerController = callerController;
    }

    public void setAcceptEventsWithoutListenerCode(boolean acceptEventsWithoutListenerCode) {
        this.acceptEventsWithoutListenerCode = acceptEventsWithoutListenerCode;
    }

    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Override
    public Expression getFilter() {
        return this.filter;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    public void setContextManager(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    @Override
    public void handle(Event event, EventDefinition ed) throws EventHandlingException {
        this.handle(event);
    }
}

