/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.Log;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

public class CpuChecker {
    private static final String CPU_CHECKER = "CpuChecker";
    private static final Map<Long, Long> threadCpuTime = new HashMap<Long, Long>();
    private static final Map<Long, Double> threadCpuLoad = new HashMap<Long, Double>();
    private static Thread thread;

    public static void start() {
        if (thread == null) {
            CpuCheckerTask task = new CpuCheckerTask();
            thread = new Thread((Runnable)task, CPU_CHECKER);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static Map<Long, Double> getThreadCpuLoad() {
        return threadCpuLoad;
    }

    private static class CpuCheckerTask
    implements Runnable {
        private CpuCheckerTask() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ThreadMXBean tmb;
                        if ((tmb = ManagementFactory.getThreadMXBean()).isThreadCpuTimeSupported() && tmb.isThreadCpuTimeEnabled()) {
                            HashMap oldCpuTime = new HashMap(threadCpuTime);
                            HashMap<Long, Long> deltas = new HashMap<Long, Long>();
                            threadCpuTime.clear();
                            threadCpuLoad.clear();
                            long[] threads = tmb.getAllThreadIds();
                            long totalDelta = 0L;
                            for (long threadId : threads) {
                                long newThreadTime = tmb.getThreadCpuTime(threadId);
                                if (newThreadTime == -1L) continue;
                                Long oldThreadTime = (Long)oldCpuTime.get(threadId);
                                if (oldThreadTime != null) {
                                    long delta = newThreadTime - oldThreadTime;
                                    totalDelta += delta;
                                    deltas.put(threadId, delta);
                                }
                                threadCpuTime.put(threadId, newThreadTime);
                            }
                            Object object = deltas.entrySet().iterator();
                            while (object.hasNext()) {
                                Map.Entry entry = (Map.Entry)object.next();
                                Long cpuTime = (Long)entry.getValue();
                                Double cpuLoad = cpuTime != null && totalDelta > 0L ? Double.valueOf(cpuTime.doubleValue() / new Long(totalDelta).doubleValue()) : null;
                                if (cpuLoad == null) continue;
                                threadCpuLoad.put(entry.getKey(), cpuLoad * 100.0);
                            }
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Throwable t) {
                    Log.CORE.fatal((Object)t.getMessage(), t);
                    continue;
                }
                break;
            }
        }
    }
}

