/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.google.common.base.CharMatcher;
import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextRuntimeException;
import com.tibbo.aggregate.common.context.ContextVisitor;
import com.tibbo.aggregate.common.context.DefaultContextVisitor;
import com.tibbo.aggregate.common.context.EventData;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContextUtils {
    public static final String CONTEXT_NAME_PATTERN = "\\w*";
    public static final String CONTEXT_PATH_PATTERN = "[\\w|\\.]+";
    public static final String CONTEXT_MASK_PATTERN = "[\\w|\\.|\\*]*";
    public static final String CONTEXT_TYPE_PATTERN = "[\\w|\\.]+";
    public static final String ENTITY_NAME_PATTERN = "\\w+";
    public static final String IDENTIFIER_PATTERN = "\\w*";
    private static final String CONTEXT_CLASS_SUFFIX = "Context";
    public static final String CONTEXT_NAME_SEPARATOR = ".";
    public static final String CONTEXT_TYPE_SEPARATOR = ".";
    public static final String CONTEXT_GROUP_MASK = "*";
    public static final String ENTITY_GROUP_MASK = "*";
    public static final String CONTEXT_TYPE_ANY = "*";
    public static final String ENTITY_ANY = "";
    public static final String ENTITY_GROUP_SEPARATOR = "|";
    public static final String MASK_LIST_SEPARATOR = " ";
    public static final String GROUP_DEFAULT = "default";
    public static final String GROUP_SYSTEM = "system";
    public static final String GROUP_REMOTE = "remote";
    public static final String GROUP_CUSTOM = "custom";
    public static final String GROUP_STATUS = "status";
    public static final String GROUP_CONTEXT_DATA = "contextData";
    public static final String GROUP_ACCESS = "access";
    public static final int ENTITY_ANY_TYPE = 0;
    public static final int ENTITY_VARIABLE = 1;
    public static final int ENTITY_FUNCTION = 2;
    public static final int ENTITY_EVENT = 4;
    public static final int ENTITY_ACTION = 8;
    public static final int ENTITY_INSTANCE = 100;
    public static final int ENTITY_GROUP_SHIFT = 200;
    public static final int ENTITY_VARIABLE_GROUP = 201;
    public static final int ENTITY_FUNCTION_GROUP = 202;
    public static final int ENTITY_EVENT_GROUP = 204;
    public static final int ENTITY_ACTION_GROUP = 208;
    public static final String USERNAME_PATTERN = "%";
    public static final String VARIABLES_GROUP_DS_SETTINGS = "ds_settings";
    public static final String ENTITY_GROUP_SUFFIX = ".*";
    public static final String SRV_MORE_CONTEXT = "srvMoreContext";
    public static final Set<String> RESERVED_CONTEXT_NAMES = new HashSet<String>();
    private static final Pattern MASK_ENDED_BY_DOT_AND_STAR_PATTERN = Pattern.compile("(.*)\\.\\*$");
    public static final Set<String> CONTEXT_TYPES = new TreeSet<String>();

    public ContextUtils() {
        RESERVED_CONTEXT_NAMES.add(SRV_MORE_CONTEXT);
    }

    public static String userContextPath(String username) {
        return ContextUtils.createName("users", username);
    }

    public static String deviceServersContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "deviceservers");
    }

    public static String dsGroupsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "dsgroups");
    }

    public static String dsGroupContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.dsGroupsContextPath(owner), name);
    }

    public static String deviceGroupsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "devgroups");
    }

    public static String deviceGroupContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.deviceGroupsContextPath(owner), name);
    }

    public static String groupContextPath(String username, String containerContextName, String name) {
        return ContextUtils.createName(ContextUtils.groupsContextPath(username, containerContextName), name);
    }

    public static String groupsContextPath(String username, String containerContextName) {
        return ContextUtils.createName(ContextUtils.userContextPath(username), ContextUtils.groupsContextName(containerContextName));
    }

    public static String groupsContextName(String containerContextName) {
        return containerContextName + "_" + "groups";
    }

    public static String alertContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.alertsContextPath(owner), name);
    }

    public static String alertsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "alerts");
    }

    public static String jobsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "jobs");
    }

    public static String jobContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.jobsContextPath(owner), name);
    }

    public static String queriesContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "queries");
    }

    public static String queryContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.queriesContextPath(owner), name);
    }

    public static String compliancePoliciesContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "compliancePolicies");
    }

    public static String compliancePolicyContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.compliancePoliciesContextPath(owner), name);
    }

    public static String reportsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "reports");
    }

    public static String reportContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.reportsContextPath(owner), name);
    }

    public static String trackersContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "trackers");
    }

    public static String trackerContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.trackersContextPath(owner), name);
    }

    public static String commonDataContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "common");
    }

    public static String commonTableContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.commonDataContextPath(owner), name);
    }

    public static String eventFiltersContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "filters");
    }

    public static String eventFilterContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.eventFiltersContextPath(owner), name);
    }

    public static String widgetContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.widgetsContextPath(owner), name);
    }

    public static String widgetsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "widgets");
    }

    public static String processControlContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.processesControlContextPath(owner), name);
    }

    public static String processesControlContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "processControl");
    }

    public static String machineLearningContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.machineLearningContextPath(owner), name);
    }

    public static String machineLearningContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "machineLearning");
    }

    public static String dashboardsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "dashboards");
    }

    public static String dashboardContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.dashboardsContextPath(owner), name);
    }

    public static String autorunActionsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "autorun");
    }

    public static String autorunActionContextName(String owner, String name) {
        return ContextUtils.createName(ContextUtils.autorunActionsContextPath(owner), name);
    }

    public static String favouritesContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "favourites");
    }

    public static String favouriteContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.favouritesContextPath(owner), name);
    }

    public static String scriptContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.scriptsContextPath(owner), name);
    }

    public static String scriptsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "scripts");
    }

    public static String modelsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "models");
    }

    public static String modelContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.modelsContextPath(owner), name);
    }

    public static String eventCorrelatorsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "correlators");
    }

    public static String eventCorrelatorContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.eventCorrelatorsContextPath(owner), name);
    }

    public static String classesContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "classes");
    }

    public static String classContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.classesContextPath(owner), name);
    }

    public static String workflowsContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "workflows");
    }

    public static String workflowContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.workflowsContextPath(owner), name);
    }

    public static String deviceServerContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.deviceServersContextPath(owner), name);
    }

    public static String pluginGlobalConfigContextPath(String pluginId) {
        return ContextUtils.createName("plugins", ContextUtils.pluginIdToContextName(pluginId));
    }

    public static String pluginsUserConfigContextPath(String username) {
        return ContextUtils.createName(ContextUtils.userContextPath(username), "plugins");
    }

    public static String pluginUserConfigContextPath(String username, String pluginId) {
        return ContextUtils.createName(ContextUtils.userContextPath(username), "plugins", ContextUtils.pluginIdToContextName(pluginId));
    }

    public static String pluginConfigContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.deviceServersContextPath(owner), name, "plugin_config");
    }

    public static String devicesContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "devices");
    }

    public static String deviceContextPath(String owner, String device) {
        return ContextUtils.createName(ContextUtils.devicesContextPath(owner), device);
    }

    public static String uiComponentContextPath(String owner) {
        return ContextUtils.createName(ContextUtils.userContextPath(owner), "uiComponents");
    }

    public static String uiComponentContextPath(String owner, String device) {
        return ContextUtils.createName(ContextUtils.uiComponentContextPath(owner), device);
    }

    public static String applicationContextPath(String owner, String name) {
        return ContextUtils.createName(ContextUtils.applicationsContextPath(owner), name);
    }

    public static String applicationsContextPath(String owner) {
        return ContextUtils.applicationsContextPathByUserContext(ContextUtils.userContextPath(owner));
    }

    public static String applicationsContextPathByUserContext(String userContextPath) {
        return ContextUtils.createName(userContextPath, "applications");
    }

    public static String getAggregationContainer(String path) {
        Pattern pattern = Pattern.compile("users\\.[\\w]+\\.[\\w]+");
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String replaceUsernameToPattern(String path) {
        String regex = "users\\.[\\w]+";
        String replacement = "users.%";
        return path.replaceFirst(regex, replacement);
    }

    public static String removeContextNameFromPath(String path) {
        return path.replaceFirst("\\.[\\w]+$", ENTITY_ANY);
    }

    public static String createName(String ... parts) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                res.append(".");
            }
            res.append(parts[i]);
        }
        return res.toString();
    }

    public static String createGroup(String ... parts) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < parts.length && (i != parts.length - 1 || parts[i] != null); ++i) {
            if (i > 0) {
                res.append(ENTITY_GROUP_SEPARATOR);
            }
            res.append(parts[i]);
        }
        return res.toString();
    }

    public static String pluginIdToContextName(String pluginId) {
        return pluginId.replace(".", "_").replace("-", ENTITY_ANY);
    }

    public static String getChildFullName(String parent, String childShortName) {
        if (parent.equals(ENTITY_ANY)) {
            return childShortName;
        }
        return parent + "." + childShortName;
    }

    public static String contextPathToContextName(String path) {
        return path.replace(".".charAt(0), '_');
    }

    public static List<Context> expandMaskListToContexts(String masks, ContextManager contextManager) {
        return ContextUtils.expandMaskListToContexts(masks, contextManager, null, false);
    }

    public static List<Context> expandMaskListToContexts(String masks, ContextManager contextManager, CallerController caller) {
        return ContextUtils.expandMaskListToContexts(masks, contextManager, caller, false);
    }

    public static List<Context> expandMaskListToContexts(String masks, ContextManager contextManager, CallerController caller, boolean useVisibleChildren) {
        LinkedList<Context> result = new LinkedList<Context>();
        List<String> maskList = StringUtils.split(masks, MASK_LIST_SEPARATOR.charAt(0));
        for (String mask : maskList) {
            List<Context> contexts = ContextUtils.expandMaskToContexts(mask, contextManager, caller, useVisibleChildren);
            result.addAll(contexts);
        }
        return result;
    }

    public static List<Context> expandMaskToContexts(String mask, ContextManager contextManager) {
        return ContextUtils.expandMaskToContexts(mask, contextManager, null, false);
    }

    public static List<Context> expandMaskToContexts(String mask, ContextManager contextManager, CallerController caller) {
        return ContextUtils.expandMaskToContexts(mask, contextManager, caller, false);
    }

    public static List<Context> expandMaskToContexts(String mask, ContextManager contextManager, CallerController caller, boolean useVisibleChildren) {
        LinkedList<Context> res = new LinkedList<Context>();
        List<String> paths = ContextUtils.expandMaskToPaths(mask, contextManager, caller, useVisibleChildren);
        for (String path : paths) {
            Object con = contextManager.get(path, caller);
            if (con == null) continue;
            res.add((Context)con);
        }
        return res;
    }

    public static List<String> expandMaskToPaths(String mask, ContextManager contextManager) {
        return ContextUtils.expandMaskToPaths(mask, contextManager, null, false);
    }

    public static List<String> expandMaskToPaths(String mask, ContextManager contextManager, CallerController caller) {
        return ContextUtils.expandMaskToPaths(mask, contextManager, caller, false);
    }

    public static List<String> expandMaskToPaths(String mask, ContextManager contextManager, CallerController caller, boolean useVisibleChildren) {
        if (mask == null) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        List<String> parts = StringUtils.split(mask, ".".charAt(0));
        for (int i = 0; i < parts.size(); ++i) {
            if (!parts.get(i).equals("*")) continue;
            StringBuffer head = new StringBuffer();
            for (int j = 0; j < i; ++j) {
                if (j > 0) {
                    head.append(".");
                }
                head.append(parts.get(j));
            }
            StringBuffer tail = new StringBuffer();
            for (int j = i + 1; j < parts.size(); ++j) {
                tail.append(".");
                tail.append(parts.get(j));
            }
            List<String> res = ContextUtils.expandMaskPart(head.toString(), tail.toString(), contextManager, caller, useVisibleChildren);
            result.addAll(res);
            return result;
        }
        if (contextManager.get(mask, caller) != null) {
            result.add(mask);
        }
        return result;
    }

    private static List<String> expandMaskPart(String head, String tail, ContextManager contextManager, CallerController caller, boolean useVisibleChildren) {
        LinkedList<String> result = new LinkedList<String>();
        Object con = contextManager.get(head, caller);
        if (con == null) {
            return result;
        }
        if (con.isMapped()) {
            List mappedChildren = con.getMappedChildren(caller);
            for (Context child : mappedChildren) {
                result.add(child.getPath());
            }
        } else {
            List children = useVisibleChildren ? con.getVisibleChildren(caller) : con.getChildren(caller);
            for (Context child : children) {
                Object realChild;
                if (useVisibleChildren && ((realChild = con.getChild(child.getName())) == null || !realChild.getPath().equals(child.getPath()))) {
                    List<String> res = ContextUtils.expandMaskToPaths(child.getPath() + tail, contextManager, caller, useVisibleChildren);
                    result.addAll(res);
                    continue;
                }
                result.addAll(ContextUtils.expandMaskToPaths(head + "." + child.getName() + tail, contextManager, caller, useVisibleChildren));
            }
        }
        return result;
    }

    public static List<Context> findChildren(String rootsMask, Class contextClass, ContextManager manager, CallerController caller, boolean resolveGroups) {
        return ContextUtils.findChildren(rootsMask, ContextUtils.getTypeForClass(contextClass), manager, caller, resolveGroups);
    }

    public static List<Context> findChildren(String rootsMask, final String type, ContextManager manager, CallerController caller, boolean resolveGroups) {
        final ArrayList<Context> res = new ArrayList<Context>();
        DefaultContextVisitor visitor = new DefaultContextVisitor(){

            @Override
            public void visit(Context context) {
                if (ContextUtils.isDerivedFrom(context.getType(), type)) {
                    res.add(context);
                }
            }
        };
        List<Context> roots = ContextUtils.expandMaskToContexts(rootsMask, manager, caller);
        for (Context root : roots) {
            try {
                ContextUtils.acceptFinder(root, visitor, caller, resolveGroups);
            }
            catch (Throwable ex) {
                throw new ContextRuntimeException(ex.getMessage(), ex);
            }
        }
        return res;
    }

    private static void acceptFinder(Context context, ContextVisitor visitor, CallerController caller, boolean resolveGroups) throws ContextException {
        visitor.visit(context);
        List children = resolveGroups ? context.getMappedChildren(caller) : context.getChildren(caller);
        for (Context child : children) {
            ContextUtils.acceptFinder(child, visitor, caller, resolveGroups);
        }
    }

    public static boolean matchesToMask(String mask, String name) {
        return ContextUtils.matchesToMask(mask, name, false, false);
    }

    public static boolean matchesToType(String type, Collection<String> requiredTypes) {
        if (requiredTypes == null || requiredTypes.isEmpty() || type == null) {
            return true;
        }
        if (requiredTypes.contains("*")) {
            return true;
        }
        for (String contextType : requiredTypes) {
            if (!ContextUtils.isDerivedFrom(type, contextType)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesToType(Collection<String> types, Collection<String> requiredTypes) {
        boolean result = true;
        for (String type : types) {
            result &= ContextUtils.matchesToType(type, requiredTypes);
        }
        return result;
    }

    public static boolean matchesToMaskWithGroups(String mask, String context, boolean contextMayExtendMask, boolean maskMayExtendContext, ContextManager contextManager) {
        if (!ContextUtils.matchesToMask(mask, context, contextMayExtendMask, maskMayExtendContext)) {
            Matcher matcher = MASK_ENDED_BY_DOT_AND_STAR_PATTERN.matcher(mask);
            if (matcher.matches()) {
                if (CharMatcher.is((char)"*".charAt(0)).countIn((CharSequence)mask) == 1) {
                    String group = matcher.group(1);
                    Object con = contextManager.get(group, contextManager.getCallerController());
                    if (con == null) {
                        return false;
                    }
                    if (con.isMapped()) {
                        return con.hasMappedChild(context, contextManager.getCallerController());
                    }
                    return false;
                }
                List<String> paths = ContextUtils.expandMaskToPaths(mask, contextManager, contextManager.getCallerController());
                return paths.contains(context);
            }
            return false;
        }
        return true;
    }

    public static boolean matchesToMask(String mask, String context, boolean contextMayExtendMask, boolean maskMayExtendContext) {
        if (mask == null || context == null) {
            return true;
        }
        if (!ContextUtils.isMask(mask)) {
            if (contextMayExtendMask && maskMayExtendContext) {
                int length = Math.min(mask.length(), context.length());
                return mask.substring(0, length).equals(context.substring(0, length));
            }
            boolean equals = mask.equals(context);
            if (maskMayExtendContext) {
                return equals || mask.length() > context.length() && mask.startsWith(context) && mask.charAt(context.length()) == ".".charAt(0);
            }
            if (contextMayExtendMask) {
                return equals || context.length() > mask.length() && context.startsWith(mask) && context.charAt(mask.length()) == ".".charAt(0);
            }
            return equals;
        }
        List<String> maskParts = StringUtils.split(mask, ".".charAt(0));
        List<String> nameParts = StringUtils.split(context, ".".charAt(0));
        if (maskParts.size() > nameParts.size() && !maskMayExtendContext) {
            return false;
        }
        if (maskParts.size() < nameParts.size() && !contextMayExtendMask) {
            return false;
        }
        return ContextUtils.straightMatching(maskParts, nameParts);
    }

    private static boolean straightMatching(List<String> maskParts, List<String> nameParts) {
        for (int i = 0; i < Math.min(maskParts.size(), nameParts.size()); ++i) {
            if (maskParts.get(i).equals("*") && !nameParts.get(i).equals("*") || maskParts.get(i).equals(nameParts.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean masksIntersect(String mask1, String mask2, boolean mask2MayExtendMask1, boolean mask1MayExtendMask2) {
        List<String> mask1Parts = StringUtils.split(mask1, ".".charAt(0));
        List<String> mask2Parts = StringUtils.split(mask2, ".".charAt(0));
        if (mask1Parts.size() > mask2Parts.size() && !mask1MayExtendMask2) {
            return false;
        }
        if (mask1Parts.size() < mask2Parts.size() && !mask2MayExtendMask1) {
            return false;
        }
        for (int i = 0; i < Math.min(mask1Parts.size(), mask2Parts.size()); ++i) {
            if (mask1Parts.get(i).equals("*") || mask2Parts.get(i).equals("*") || mask1Parts.get(i).equals(mask2Parts.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isRelative(String name) {
        return name.startsWith(".");
    }

    public static boolean isMask(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf("*".charAt(0)) > -1;
    }

    public static boolean isValidContextType(String s) {
        return "*".equals(s) || Pattern.matches("[\\w|\\.]+", s);
    }

    public static boolean isValidContextName(String s) {
        if (s == null) {
            return false;
        }
        return Pattern.matches("\\w*", s) && !RESERVED_CONTEXT_NAMES.contains(s);
    }

    public static boolean isValidContextMask(String s) {
        if (s == null) {
            return false;
        }
        return Pattern.matches(CONTEXT_MASK_PATTERN, s);
    }

    public static boolean isValidIdentifier(String s) {
        if (s == null) {
            return false;
        }
        return Pattern.matches("\\w*", s);
    }

    public static boolean isDerivedFrom(String childType, String parentType) {
        StringTokenizer pst = new StringTokenizer(parentType, ".");
        StringTokenizer cst = new StringTokenizer(childType, ".");
        if (cst.countTokens() < pst.countTokens()) {
            return false;
        }
        while (pst.hasMoreTokens()) {
            if (pst.nextToken().equals(cst.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static String getParentPath(String path) {
        if (ContextUtils.isRelative(path)) {
            throw new IllegalArgumentException("Cannot find parent of a relative path: " + path);
        }
        int index = path.lastIndexOf(".");
        return index != -1 ? path.substring(0, index) : null;
    }

    public static String getContextName(String path) {
        if (ContextUtils.isRelative(path)) {
            throw new IllegalArgumentException("Cannot find parent of a relative path: " + path);
        }
        int index = path.lastIndexOf(".");
        return index != -1 ? path.substring(index + 1) : null;
    }

    public static String getBaseGroup(String group) {
        if (group == null) {
            return null;
        }
        int index = group.indexOf(ENTITY_GROUP_SEPARATOR.charAt(0));
        return index == -1 ? group : group.substring(0, index);
    }

    public static String getActualGroup(String group) {
        if (group == null) {
            return null;
        }
        int index = group.lastIndexOf(ENTITY_GROUP_SEPARATOR.charAt(0));
        return index == -1 ? group : group.substring(index + 1);
    }

    public static String getVisualGroup(String group) {
        if (group == null) {
            return null;
        }
        int index = group.indexOf(ENTITY_GROUP_SEPARATOR.charAt(0));
        return index == -1 ? null : group.substring(index + 1);
    }

    public static String getBaseType(String type) {
        StringTokenizer st = new StringTokenizer(type, ".");
        return st.nextToken();
    }

    public static String getSubtype(String type) {
        if (type == null) {
            return null;
        }
        int index = type.lastIndexOf(".".charAt(0));
        return index == -1 ? null : type.substring(index + 1, type.length());
    }

    public static String getTypeForClass(Class clazz) {
        String name = clazz.getSimpleName();
        return ContextUtils.getTypeForClassSimpleName(name);
    }

    public static String getTypeForClassSimpleName(String name) {
        if (name.length() == 0) {
            return name;
        }
        if ((name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1, name.length())).endsWith(CONTEXT_CLASS_SUFFIX)) {
            name = name.substring(0, name.length() - CONTEXT_CLASS_SUFFIX.length());
        }
        return name;
    }

    public static Map<String, String> getEventFields(String mask, String event, CallerController caller, ContextManager contextManager) {
        List<Context> contexts = ContextUtils.expandMaskToContexts(mask, contextManager, caller);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        for (Context con : contexts) {
            TableFormat rf;
            EventData edata = con.getEventData(event);
            if (edata == null || (rf = edata.getDefinition().getFormat()) == null) continue;
            for (FieldFormat ff : rf) {
                fields.put(ff.getName(), ff.toString());
            }
        }
        return fields;
    }

    public static Map<String, String> getVariableFields(String mask, String variable, CallerController caller, ContextManager contextManager) {
        List<Context> contexts = ContextUtils.expandMaskToContexts(mask, contextManager, caller);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        for (Context con : contexts) {
            TableFormat rf;
            VariableDefinition vd = con.getVariableDefinition(variable);
            if (vd == null || (rf = vd.getFormat()) == null) continue;
            for (FieldFormat ff : rf) {
                if (ff.isHidden()) continue;
                fields.put(ff.getName(), ff.toString());
            }
        }
        return fields;
    }

    public static ActionDefinition getDefaultActionDefinition(Context context, CallerController caller) {
        List<ActionDefinition> actions = context.getActionDefinitions(caller);
        for (ActionDefinition def : actions) {
            if (!def.isDefault()) continue;
            return def;
        }
        return null;
    }

    public static String createType(Class clazz, String deviceType) {
        return ContextUtils.getTypeForClass(clazz) + "." + deviceType;
    }

    public static boolean isValidContextNameChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public static void changeVariable(Context aContext, String variableNameString, ModifyVariable modifications) throws ContextException {
        ContextManager cm = aContext.getContextManager();
        DataTable variableValue = aContext.getVariableClone(variableNameString, cm.getCallerController());
        modifications.execute(variableValue);
        aContext.setVariable(variableNameString, cm.getCallerController(), variableValue);
    }

    public static String getGroupName(String entityName) {
        if (entityName == null) {
            return null;
        }
        if (entityName.endsWith(ENTITY_GROUP_SUFFIX)) {
            String group = entityName.substring(0, entityName.length() - ENTITY_GROUP_SUFFIX.length());
            return group;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerType(String type) {
        Class<ContextUtils> clazz = ContextUtils.class;
        synchronized (ContextUtils.class) {
            CONTEXT_TYPES.add(type);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static interface ModifyVariable {
        public void execute(DataTable var1);
    }
}

