/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.ContextUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ContextSortingHelper {
    private static final int MAX_INDEX = 0x3FFFFFFF;
    private static final int MULTIPLICATOR = 100;
    private static final List<String> CONTEXTS_ORDER = new LinkedList<String>();

    public static Integer getIndex(String context) {
        if (!CONTEXTS_ORDER.contains(context)) {
            String groupsSuffix = ContextUtils.groupsContextName("");
            if (context.endsWith(groupsSuffix)) {
                return ContextSortingHelper.getIndex(context.replace(groupsSuffix, ""));
            }
            return null;
        }
        return 0x3FFFFFFF - CONTEXTS_ORDER.indexOf(context) * 100;
    }

    public static List<String> getOrderedContextList() {
        return Collections.unmodifiableList(CONTEXTS_ORDER);
    }

    static {
        CONTEXTS_ORDER.add("devices");
        CONTEXTS_ORDER.add("devgroups");
        CONTEXTS_ORDER.add("users");
        CONTEXTS_ORDER.add("applications");
        CONTEXTS_ORDER.add("models");
        CONTEXTS_ORDER.add("dashboards");
        CONTEXTS_ORDER.add("alerts");
        CONTEXTS_ORDER.add("filters");
        CONTEXTS_ORDER.add("classes");
        CONTEXTS_ORDER.add("queries");
        CONTEXTS_ORDER.add("jobs");
        CONTEXTS_ORDER.add("workflows");
        CONTEXTS_ORDER.add("machineLearning");
        CONTEXTS_ORDER.add("correlators");
        CONTEXTS_ORDER.add("uiComponents");
        CONTEXTS_ORDER.add("scripts");
        CONTEXTS_ORDER.add("reports");
        CONTEXTS_ORDER.add("autorun");
        CONTEXTS_ORDER.add("plugins");
        CONTEXTS_ORDER.add("processControl");
        CONTEXTS_ORDER.add("ipsla");
        CONTEXTS_ORDER.add("compliancePolicies");
        CONTEXTS_ORDER.add("organizations");
        CONTEXTS_ORDER.add("cardholders");
        CONTEXTS_ORDER.add("shifts");
        CONTEXTS_ORDER.add("timezones");
        CONTEXTS_ORDER.add("accessPolicies");
        CONTEXTS_ORDER.add("antiPassbackAreas");
        CONTEXTS_ORDER.add("deviceservers");
        CONTEXTS_ORDER.add("common");
        CONTEXTS_ORDER.add("widgets");
        CONTEXTS_ORDER.add("trackers");
        CONTEXTS_ORDER.add("favourites");
        CONTEXTS_ORDER.add("administration");
        CONTEXTS_ORDER.add("config");
        CONTEXTS_ORDER.add("debug");
        CONTEXTS_ORDER.add("events");
        CONTEXTS_ORDER.add("scheduler");
        CONTEXTS_ORDER.add("utilities");
    }
}

