/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.EventData;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.FireEventRequestController;
import com.tibbo.aggregate.common.plugin.PluginDirector;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public interface ContextManager<T extends Context> {
    public boolean isStarted();

    public void start();

    public void restart();

    public void stop();

    public T getRoot();

    public T get(String var1, CallerController var2);

    public T get(String var1);

    public void addMaskEventListener(String var1, String var2, ContextEventListener var3);

    public void addMaskEventListener(String var1, String var2, ContextEventListener var3, boolean var4);

    public void removeMaskEventListener(String var1, String var2, ContextEventListener var3);

    public void contextAdded(T var1);

    public void contextRemoved(T var1);

    public void contextInfoChanged(T var1);

    public void variableAdded(T var1, VariableDefinition var2);

    public void variableRemoved(T var1, VariableDefinition var2);

    public void functionAdded(T var1, FunctionDefinition var2);

    public void functionRemoved(T var1, FunctionDefinition var2);

    public void eventAdded(T var1, EventDefinition var2);

    public void eventRemoved(T var1, EventDefinition var2);

    public void queue(EventData var1, Event var2, FireEventRequestController var3);

    public ExecutorService getExecutorService();

    public <P extends PluginDirector> P getPluginDirector();

    public CallerController getCallerController();

    public int getEventQueueLength();

    public long getEventsScheduled();

    public long getEventsProcessed();

    public Map<String, Long> getEventQueueStatistics();

    default public Optional<FormatCache> getFormatCache() {
        return Optional.empty();
    }

    @Nullable
    default public String getScope() {
        return "";
    }

    default public boolean isServerManager() {
        return false;
    }
}

