/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.CallerData;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.security.PermissionCache;
import com.tibbo.aggregate.common.security.Permissions;
import java.util.Date;
import java.util.Map;

public interface CallerController {
    public String getUsername();

    public String getInheritedUsername();

    public String getEffectiveUsername();

    public String getLogin();

    public boolean isPermissionCheckingEnabled();

    public Permissions getPermissions();

    public PermissionCache getPermissionCache();

    public boolean isLoggedIn();

    public void login(String var1, String var2, Permissions var3) throws ContextException;

    public void logout();

    public void logoutSoftly();

    public boolean isHeadless();

    public Type getType();

    public String getAddress();

    public Date getCreationTime();

    public CallerData getCallerData();

    public Map<String, Object> getProperties();

    public void sendFeedback(int var1, String var2);

    public void sendFeedback(int var1, String var2, Integer var3);

    public Long getSessionIdCounter();

    public String getSessionId();

    public Long getTokenExpirationPeriod();

    public Context lookup(String var1);

    public void cache(String var1, Context var2);

    public void addLockedContext(Context var1);

    public void removeLockedContext(Context var1);

    public void unlockAllContexts();

    public DataTable createLockedContextsTable();

    public boolean isWeb();

    public boolean isConnectionTerminatable();

    default public String getLoginType() {
        Type type = this.getType();
        if (type == null) {
            return null;
        }
        return type.name();
    }

    default public String getClientIP() {
        String clientIP = this.getAddress();
        if (clientIP == null || clientIP.isEmpty()) {
            return null;
        }
        return clientIP;
    }

    public static enum Type {
        DESKTOP,
        WEB_SOCKET,
        WEB_WIDGET_PLAYER,
        WEB_SERVICE,
        CONSUMER,
        WEB,
        REST,
        TEST;


        public boolean isDesktop() {
            return this.equals((Object)DESKTOP) || this.equals((Object)TEST);
        }
    }
}

