/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.context.DefaultRequestController;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class AwaitableRequestController
extends DefaultRequestController {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Result> result = new AtomicReference<Object>(null);
    private final AtomicReference<Throwable> error = new AtomicReference<Object>(null);

    public void markSuccess() {
        if (this.result.compareAndSet(null, Result.SUCCESS)) {
            this.latch.countDown();
        }
    }

    public void markFailure(Throwable t) {
        this.error.set(t);
        if (this.result.compareAndSet(null, Result.FAILURE)) {
            this.latch.countDown();
        }
    }

    public Result await() throws InterruptedException {
        this.latch.await();
        return this.result.get();
    }

    public Optional<Result> await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit) ? Optional.ofNullable(this.result.get()) : Optional.empty();
    }

    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error.get());
    }

    public static enum Result {
        SUCCESS,
        FAILURE;

    }
}

