/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.google.common.collect.ImmutableList;
import com.tibbo.aggregate.common.AggreGateRuntimeException;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.action.BasicActionDefinition;
import com.tibbo.aggregate.common.action.GroupIdentifier;
import com.tibbo.aggregate.common.action.KeyStroke;
import com.tibbo.aggregate.common.action.ResourceMask;
import com.tibbo.aggregate.common.action.TreeMask;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.CompatibilityConverter;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextOperationType;
import com.tibbo.aggregate.common.context.ContextRuntimeException;
import com.tibbo.aggregate.common.context.ContextSecurityException;
import com.tibbo.aggregate.common.context.ContextSortingHelper;
import com.tibbo.aggregate.common.context.ContextStatus;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.ContextVisitor;
import com.tibbo.aggregate.common.context.DefaultContextVisitor;
import com.tibbo.aggregate.common.context.EntityDefinition;
import com.tibbo.aggregate.common.context.EventData;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FireChangeEventRequestController;
import com.tibbo.aggregate.common.context.FunctionData;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.FunctionImplementation;
import com.tibbo.aggregate.common.context.PropertiesLock;
import com.tibbo.aggregate.common.context.RequestController;
import com.tibbo.aggregate.common.context.VariableData;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.context.VariableGetter;
import com.tibbo.aggregate.common.context.VariableStatus;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableReplication;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.Enrichment;
import com.tibbo.aggregate.common.event.EventEnrichmentRule;
import com.tibbo.aggregate.common.event.EventProcessingRule;
import com.tibbo.aggregate.common.event.EventUtils;
import com.tibbo.aggregate.common.event.FireEventRequestController;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.parser.NodeEvaluationDetails;
import com.tibbo.aggregate.common.security.DefaultPermissionChecker;
import com.tibbo.aggregate.common.security.NullPermissionChecker;
import com.tibbo.aggregate.common.security.PermissionChecker;
import com.tibbo.aggregate.common.security.Permissions;
import com.tibbo.aggregate.common.security.ServerPermissionChecker;
import com.tibbo.aggregate.common.structure.Pinpoint;
import com.tibbo.aggregate.common.structure.PinpointFactory;
import com.tibbo.aggregate.common.structure.collector.ApplicationStructureLocator;
import com.tibbo.aggregate.common.structure.trace.Span;
import com.tibbo.aggregate.common.util.Pair;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractContext<C extends Context>
implements Context<C> {
    private static final String IMPLEMENTATION_METHOD_PREFIX = "callF";
    private static final String SETTER_METHOD_PREFIX = "setV";
    private static final String GETTER_METHOD_PREFIX = "getV";
    public static final int EXECUTOR_THREADS_PERCENT_FOR_VISITORS = 10;
    public static final String V_INFO = "info";
    public static final String V_CHILDREN = "children";
    public static final String V_VARIABLES = "variables";
    public static final String V_FUNCTIONS = "functions";
    public static final String V_EVENTS = "events";
    public static final String V_ACTIONS = "actions";
    public static final String V_VARIABLE_STATUSES = "variableStatuses";
    public static final String F_GET_COPY_DATA = "getCopyData";
    public static final String F_COPY = "copy";
    public static final String F_COPY_TO_CHILDREN = "copyToChildren";
    public static final String F_UPDATE_VARIABLE = "updateVariable";
    public static final String F_GET_VARIABLE_STATUS = "getVariableStatus";
    public static final String F_LOCKED_BY = "lockedBy";
    public static final String F_LOCK = "lock";
    public static final String F_UNLOCK = "unlock";
    public static final String F_BREAK_LOCK = "breakLock";
    public static final String F_GET_ALIASES = "getAliases";
    public static final String F_FIRE_CONTEXT_EVENT = "fireContextEvent";
    public static final String E_INFO = "info";
    public static final String E_UPDATED = "updated";
    public static final String E_CHANGE = "change";
    public static final String E_DESTROYED = "destroyed";
    public static final String E_INFO_CHANGED = "infoChanged";
    public static final String E_VARIABLE_ADDED = "variableAdded";
    public static final String E_VARIABLE_REMOVED = "variableRemoved";
    public static final String E_FUNCTION_ADDED = "functionAdded";
    public static final String E_FUNCTION_REMOVED = "functionRemoved";
    public static final String E_EVENT_ADDED = "eventAdded";
    public static final String E_EVENT_REMOVED = "eventRemoved";
    public static final String E_ACTION_ADDED = "actionAdded";
    public static final String E_ACTION_REMOVED = "actionRemoved";
    public static final String E_ACTION_STATE_CHANGED = "actionStateChanged";
    public static final String E_CHILD_REMOVED = "childRemoved";
    public static final String E_CHILD_ADDED = "childAdded";
    public static final String E_VARIABLE_STATUS_CHANGED = "variableStatusChanged";
    public static final String VF_INFO_DESCRIPTION = "description";
    public static final String VF_INFO_TYPE = "type";
    public static final String VF_INFO_GROUP = "group";
    public static final String VF_INFO_ICON = "icon";
    public static final String VF_INFO_LOCAL_ROOT = "localRoot";
    public static final String VF_INFO_PEER_ROOT = "peerRoot";
    public static final String VF_INFO_PEER_PRIMARY_ROOT = "peerPrimaryRoot";
    public static final String VF_INFO_REMOTE_ROOT = "remoteRoot";
    public static final String VF_INFO_REMOTE_PATH = "remotePath";
    public static final String VF_INFO_MAPPED = "mapped";
    public static final String VF_CHILDREN_NAME = "name";
    public static final String VF_CHILDREN_IS_CONTAINER = "container";
    public static final String VF_VARIABLE_STATUSES_COMMENT = "comment";
    public static final String VF_VARIABLE_STATUSES_STATUS = "status";
    public static final String VF_VARIABLE_STATUSES_NAME = "name";
    public static final String FIF_COPY_DATA_RECIPIENTS = "recipients";
    public static final String FIF_COPY_DATA_GROUP = "group";
    public static final String FOF_COPY_DATA_NAME = "name";
    public static final String FOF_COPY_DATA_DESCRIPTION = "description";
    public static final String FOF_COPY_DATA_REPLICATE = "replicate";
    public static final String FOF_COPY_DATA_FIELDS = "fields";
    public static final String FOF_COPY_DATA_VALUE = "value";
    public static final String FIF_REPLICATE_FIELDS_NAME = "name";
    public static final String FIF_REPLICATE_FIELDS_DESCRIPTION = "description";
    public static final String FIF_REPLICATE_FIELDS_REPLICATE = "replicate";
    public static final String FIF_COPY_DATA_RECIPIENTS_RECIPIENT = "recipient";
    public static final String FIF_LOCK_PROPERTIES_EDITOR_UUID = "propertiesEditorUUID";
    public static final String FIF_UNLOCK_PROPERTIES_EDITOR_UUID = "propertiesEditorUUID";
    public static final String FIF_VISIBLE_CHILDREN_FILTER_EXPRESSION = "filterExpression";
    public static final String FIF_VISIBLE_CHILDREN_CONTEXT_MASK = "contextMask";
    public static final String FIF_VISIBLE_CHILDREN_PROPERTY_FILTERS = "propertyFilters";
    public static final String FIF_VISIBLE_CHILDREN_GLOBAL_FILTER = "globalFilter";
    public static final String FIF_VISIBLE_CHILDREN_OFFSET = "offset";
    public static final String FIF_VISIBLE_CHILDREN_COUNT = "count";
    public static final String FIF_VISIBLE_CHILDREN_SMART_FILTER_EXPRESSION = "smartFilterExpression";
    public static final String FIF_FIRE_EVENT_LEVEL = "level";
    public static final String FIF_FIRE_EVENT_EVENT = "event";
    public static final String FIF_FIRE_EVENT_DATA = "data";
    public static final String FOF_FIRE_EVENT_ID = "id";
    public static final String VF_VISIBLE_CHILDREN_PROPERTY_FILTERS_PROPERTY_NAME = "propertyName";
    public static final String VF_VISIBLE_CHILDREN_PROPERTY_FILTERS_PROPERTY_VALUE = "propertyValue";
    public static final String FOF_LOCKED_BY_OWNER_NAME = "lockOwnerName";
    public static final String FOF_LOCK_OWNER_NAME = "lockOwnerName";
    public static final String FOF_UNLOCK_UNLOCKED = "unlocked";
    public static final String FOF_VISIBLE_CHILDREN_BATCH = "batch";
    public static final String FOF_VISIBLE_CHILDREN_TOTAL_COUNT = "total";
    public static final String FOF_GET_ALIASES_ENTITY_TYPE = "entityType";
    public static final String FOF_GET_ALIASES_ALIAS_NAME = "aliasName";
    public static final String FOF_GET_ALIASES_NAME = "name";
    public static final String EF_INFO_INFO = "info";
    public static final String EF_EVENT_REMOVED_NAME = "name";
    public static final String EF_FUNCTION_REMOVED_NAME = "name";
    public static final String EF_VARIABLE_REMOVED_NAME = "name";
    public static final String EF_ACTION_REMOVED_NAME = "name";
    public static final String EF_CHILD_REMOVED_CHILD = "child";
    public static final String EF_CHILD_ADDED_CHILD = "child";
    private static final String FIELD_REPLICATE_CONTEXT = "context";
    public static final String FIELD_REPLICATE_VARIABLE = "variable";
    public static final String FIELD_REPLICATE_SUCCESSFUL = "successful";
    public static final String FIELD_REPLICATE_ERRORS = "errors";
    public static final String V_UPDATE_VARIABLE = "variable";
    public static final String V_UPDATE_VARIABLE_EXPRESSION = "expression";
    public static final String V_VARIABLE_NAME = "variableName";
    public static final String EF_UPDATED_VARIABLE = "variable";
    public static final String EF_UPDATED_VALUE = "value";
    public static final String EF_UPDATED_VALUE_OLD = "valueOld";
    public static final String EF_UPDATED_USER = "user";
    public static final String EF_UPDATED_VARIABLE_STATUS = "status";
    public static final String EF_UPDATED_UPDATE_ORIGINATOR = "updateOriginator";
    public static final String EF_CHANGE_VARIABLE = "variable";
    public static final String EF_CHANGE_VALUE = "value";
    public static final String EF_CHANGE_DATA = "data";
    public static final String EF_CHANGE_FORMAT = "format";
    public static final String FIELD_VD_NAME = "name";
    public static final String FIELD_VD_FORMAT = "format";
    public static final String FIELD_VD_DESCRIPTION = "description";
    public static final String FIELD_VD_READABLE = "readable";
    public static final String FIELD_VD_WRITABLE = "writable";
    public static final String FIELD_VD_HELP = "help";
    public static final String FIELD_VD_GROUP = "group";
    public static final String FIELD_VD_ICON_ID = "iconId";
    public static final String FIELD_VD_HELP_ID = "helpId";
    public static final String FIELD_VD_CACHE_TIME = "cacheTime";
    public static final String FIELD_VD_SERVER_CACHING_MODE = "serverCachingMode";
    public static final String FIELD_VD_ADD_PREVIOUS_VALUE_TO_VARIABLE_UPDATE_EVENT = "addPreviousValueToVariableUpdateEvent";
    private static final String FIELD_VD_READ_PERMISSIONS = "readPermissions";
    private static final String FIELD_VD_WRITE_PERMISSIONS = "writePermissions";
    private static final String FIELD_VD_DEFAULT_VALUE = "defaultValue";
    public static final String FIELD_FD_NAME = "name";
    public static final String FIELD_FD_INPUTFORMAT = "inputformat";
    public static final String FIELD_FD_OUTPUTFORMAT = "outputformat";
    public static final String FIELD_FD_DESCRIPTION = "description";
    public static final String FIELD_FD_HELP = "help";
    public static final String FIELD_FD_GROUP = "group";
    public static final String FIELD_FD_ICON_ID = "iconId";
    public static final String FIELD_FD_CONCURRENT = "concurrent";
    public static final String FIELD_FD_PERMISSIONS = "permissions";
    public static final String FIELD_ED_NAME = "name";
    public static final String FIELD_ED_FORMAT = "format";
    public static final String FIELD_ED_DESCRIPTION = "description";
    public static final String FIELD_ED_HELP = "help";
    public static final String FIELD_ED_LEVEL = "level";
    public static final String FIELD_ED_GROUP = "group";
    public static final String FIELD_ED_ICON_ID = "iconId";
    private static final String FIELD_ED_PERMISSIONS = "permissions";
    public static final int DEFAULT_EVENT_LEVEL = -1;
    public static final TableFormat VARIABLE_DEFINITION_FORMAT = new TableFormat();
    private static final TableFormat VFT_VARIABLE_STATUSES;
    public static final TableFormat VFT_VISIBLE_CHILDREN;
    private static final TableFormat EF_VARIABLE_ADDED;
    public static final TableFormat FUNCTION_DEFINITION_FORMAT;
    public static final TableFormat EF_FUNCTION_ADDED;
    public static final TableFormat EVENT_DEFINITION_FORMAT;
    public static final TableFormat EF_EVENT_ADDED;
    protected static final TableFormat VFT_CHILDREN;
    public static final TableFormat INFO_DEFINITION_FORMAT;
    public static final TableFormat ACTION_DEF_FORMAT;
    public static final TableFormat RESOURCE_MASKS_FORMAT;
    public static final TableFormat FIFT_GET_COPY_DATA;
    public static final TableFormat FIFT_GET_COPY_DATA_RECIPIENTS;
    public static final TableFormat REPLICATE_INPUT_FORMAT;
    public static final TableFormat FIFT_REPLICATE_FIELDS;
    public static final TableFormat REPLICATE_OUTPUT_FORMAT;
    protected static final TableFormat REPLICATE_TO_CHILDREN_OUTPUT_FORMAT;
    public static final TableFormat FIFT_UPDATE_VARIABLE;
    public static final TableFormat FIFT_GET_VARIABLE_STATUS;
    public static final TableFormat FIFT_LOCK;
    public static final TableFormat FIFT_UNLOCK;
    public static final TableFormat FIFT_VISIBLE_CHILDREN;
    public static final TableFormat FOFT_LOCKED_BY;
    public static final TableFormat FOFT_LOCK;
    public static final TableFormat FOFT_UNLOCK;
    public static final TableFormat FOFT_VISIBLE_CHILDREN;
    public static final TableFormat FOFT_GET_ALIASES;
    public static final TableFormat FIFT_FIRE_CONTEXT_EVENT;
    public static final TableFormat FOFT_FIRE_CONTEXT_EVENT;
    public static final TableFormat EF_UPDATED;
    public static final TableFormat EF_CHANGE;
    public static final TableFormat EFT_INFO;
    public static final TableFormat EFT_VARIABLE_REMOVED;
    public static final TableFormat EFT_EVENT_REMOVED;
    public static final TableFormat EFT_FUNCTION_REMOVED;
    public static final TableFormat EFT_CHILD_REMOVED;
    public static final TableFormat EFT_CHILD_ADDED;
    public static final TableFormat EFT_ACTION_REMOVED;
    public static final VariableDefinition VD_INFO;
    public static final VariableDefinition VD_VARIABLES;
    public static final VariableDefinition VD_FUNCTIONS;
    public static final VariableDefinition VD_EVENTS;
    public static final VariableDefinition VD_ACTIONS;
    public static final VariableDefinition VD_CHILDREN;
    protected static final FunctionDefinition FD_GET_COPY_DATA;
    protected static final FunctionDefinition FD_COPY;
    protected static final FunctionDefinition FD_COPY_TO_CHILDREN;
    protected static final FunctionDefinition FD_UPDATE_VARIABLE;
    protected static final FunctionDefinition FD_GET_ALIASES;
    protected static final FunctionDefinition FD_FIRE_CONTEXT_EVENT;
    public static final EventDefinition ED_INFO;
    public static final EventDefinition ED_CHILD_ADDED;
    public static final EventDefinition ED_CHILD_REMOVED;
    public static final EventDefinition ED_VARIABLE_ADDED;
    public static final EventDefinition ED_VARIABLE_REMOVED;
    public static final EventDefinition ED_FUNCTION_ADDED;
    public static final EventDefinition ED_FUNCTION_REMOVED;
    public static final EventDefinition ED_EVENT_ADDED;
    public static final EventDefinition ED_EVENT_REMOVED;
    public static final EventDefinition ED_ACTION_ADDED;
    public static final EventDefinition ED_ACTION_REMOVED;
    public static final EventDefinition ED_ACTION_STATE_CHANGED;
    public static final EventDefinition ED_INFO_CHANGED;
    public static final EventDefinition ED_UPDATED;
    public static final EventDefinition ED_CHANGE;
    public static final EventDefinition ED_DESTROYED;
    private static final Permissions DEFAULT_PERMISSIONS;
    public static final String CALLER_CONTROLLER_PROPERTY_DEBUG = "debug";
    public static final String CALLER_CONTROLLER_PROPERTY_NO_UPDATED_EVENTS = "no_updated_events";
    public static final String CALLER_CONTROLLER_PROPERTY_NO_CHANGE_EVENTS = "no_change_events";
    public static final String CALLER_CONTROLLER_PROPERTY_NO_STATISTICS = "no_statistics";
    public static final String CALLER_CONTROLLER_PROPERTY_NO_VALIDATION = "no_validation";
    public static final int INDEX_HIGHEST = 400;
    public static final int INDEX_VERY_HIGH = 300;
    public static final int INDEX_HIGH = 200;
    public static final int INDEX_HIGHER = 100;
    public static final int INDEX_NORMAL = 0;
    public static final int INDEX_LOWER = -100;
    public static final int INDEX_LOW = -200;
    public static final int INDEX_VERY_LOW = -300;
    public static final int INDEX_LOWEST = -400;
    private static final int VERY_LOW_PERFORMANCE_THRESHOLD = 120000;
    private static final int LOW_PERFORMANCE_THRESHOLD = 20000;
    protected static final int SORT_THRESHOLD = 10000;
    private static final int MOVE_LOCK_TIMEOUT = 2;
    private static final ThreadLocal<Deque<Span>> currentTrace;
    protected static final ThreadLocal<Pinpoint> currentSource;
    private ContextManager<C> contextManager;
    private final Map<String, VariableData> variableData = new LinkedHashMap<String, VariableData>();
    private final Map<String, String> variableNameByAlias = new ConcurrentHashMap<String, String>();
    private final ReentrantReadWriteLock variableDataLock = new ReentrantReadWriteLock();
    private final Map<String, FunctionData> functionData = new LinkedHashMap<String, FunctionData>();
    private final Map<String, String> functionNameByAlias = new ConcurrentHashMap<String, String>();
    private final ReentrantReadWriteLock functionDataLock = new ReentrantReadWriteLock();
    private final Map<String, EventData> eventData = new LinkedHashMap<String, EventData>();
    private final Map<String, String> eventNameByAlias = new ConcurrentHashMap<String, String>();
    private final ReentrantReadWriteLock eventDataLock = new ReentrantReadWriteLock();
    private final List<ActionDefinition> actionDefinitions = new ArrayList<ActionDefinition>();
    private final Map<String, String> actionNameByAlias = new ConcurrentHashMap<String, String>();
    private final ReentrantReadWriteLock actionDefinitionsLock = new ReentrantReadWriteLock();
    private final PropertiesLock propertiesLock = new PropertiesLock(this);
    private String name;
    private String description;
    private String type;
    private String group;
    private String iconId;
    private C parent;
    private boolean setupComplete;
    private boolean started;
    private boolean stopped;
    private Integer index;
    private boolean permissionCheckingEnabled = true;
    private Permissions permissions;
    private Permissions childrenViewPermissions;
    private PermissionChecker permissionChecker = new NullPermissionChecker();
    private final List<C> childrenList = new ArrayList<C>();
    private final Map<String, C> childrenMap = new ConcurrentHashMap<String, C>();
    private final ReentrantReadWriteLock childrenLock = new ReentrantReadWriteLock();
    private boolean valueCheckingEnabled = true;
    private boolean childrenConcurrencyEnabled = false;
    private boolean childrenSortingEnabled = true;
    private boolean fireUpdateEvents = true;
    private ContextStatus status;
    private Map<String, VariableStatus> variableStatuses;
    private DataTable variableStatusesTable = null;
    private boolean variableStatusesUpdated;
    private final ReentrantReadWriteLock variableStatusesLock = new ReentrantReadWriteLock();
    protected final CompletableFuture<C> ready = new CompletableFuture();
    private String path;
    final FunctionImplementation lockImpl = (con, def, caller, request, parameters) -> new SimpleDataTable(FOFT_LOCK, this.propertiesLock.lock(caller, parameters.rec().getString("propertiesEditorUUID")));
    final FunctionImplementation unlockImpl = (con, def, caller, request, parameters) -> {
        SimpleDataTable result = new SimpleDataTable(FOFT_UNLOCK);
        DataRecord record = result.addRecord();
        record.addBoolean(this.propertiesLock.unlock(caller, parameters.rec().getString("propertiesEditorUUID")));
        return result;
    };
    final FunctionImplementation breakLockImpl = (con, def, caller, request, parameters) -> {
        this.propertiesLock.breakLock();
        return null;
    };
    final FunctionImplementation lockedByImpl = (con, def, caller, request, parameters) -> new SimpleDataTable(FOFT_LOCKED_BY, this.propertiesLock.lockedBy());
    final FunctionImplementation getVariableStatusImpl = (con, def, caller, request, parameters) -> {
        String name = parameters.rec().getString(V_VARIABLE_NAME);
        this.ensureVariableStatuses();
        VariableStatus variableStatus = this.variableStatuses.get(name);
        if (variableStatus == null) {
            return new SimpleDataTable(VFT_VARIABLE_STATUSES, name, "", "");
        }
        return new SimpleDataTable(VFT_VARIABLE_STATUSES, name, variableStatus.getStatus(), variableStatus.getComment());
    };

    public AbstractContext(String name) {
        this.setName(name);
        this.index = ContextSortingHelper.getIndex(name);
    }

    @Override
    public final void setup(ContextManager contextManager) {
        this.setContextManager(contextManager);
        this.setup();
    }

    protected final void setup() {
        try {
            if (this.setupComplete) {
                return;
            }
            boolean childrenDebugEnabled = Log.CONTEXT_CHILDREN.isDebugEnabled();
            long startTime = childrenDebugEnabled ? System.currentTimeMillis() : 0L;
            this.setupPermissions();
            this.setupMyself();
            if (childrenDebugEnabled) {
                Log.CONTEXT_CHILDREN.debug((Object)("Set up context  '" + this.getPath() + "' in " + (System.currentTimeMillis() - startTime) + " ms"));
            }
            this.setupComplete = true;
            startTime = childrenDebugEnabled ? System.currentTimeMillis() : 0L;
            this.setupChildren();
            if (childrenDebugEnabled) {
                Log.CONTEXT_CHILDREN.debug((Object)("Set up children of context  '" + this.getPath() + "' in " + (System.currentTimeMillis() - startTime) + " ms"));
            }
            if (!this.ready.isDone()) {
                this.ready.complete(this);
            }
        }
        catch (Exception ex) {
            if (!this.ready.isDone()) {
                this.ready.completeExceptionally(ex);
            }
            throw new ContextRuntimeException("Error setting up context '" + this + "': " + ex.getMessage(), ex);
        }
    }

    public void setupPermissions() {
    }

    public void setupMyself() throws ContextException {
        this.addVariableDefinition(VD_INFO);
        this.addVariableDefinition(VD_VARIABLES);
        this.addVariableDefinition(VD_FUNCTIONS);
        this.addVariableDefinition(VD_EVENTS);
        this.addVariableDefinition(VD_ACTIONS);
        this.addVariableDefinition(VD_CHILDREN);
        this.addFunctionDefinition(FD_GET_COPY_DATA);
        this.addFunctionDefinition(FD_COPY);
        this.addFunctionDefinition(FD_COPY_TO_CHILDREN);
        this.addFunctionDefinition(FD_UPDATE_VARIABLE);
        this.addPropertiesLockFunctionDefinitions();
        this.addFunctionDefinition(FD_GET_ALIASES);
        this.addFunctionDefinition(FD_FIRE_CONTEXT_EVENT);
        this.addEventDefinition(ED_INFO);
        this.addEventDefinition(ED_CHILD_ADDED);
        this.addEventDefinition(ED_CHILD_REMOVED);
        this.addEventDefinition(ED_VARIABLE_ADDED);
        this.addEventDefinition(ED_VARIABLE_REMOVED);
        this.addEventDefinition(ED_FUNCTION_ADDED);
        this.addEventDefinition(ED_FUNCTION_REMOVED);
        this.addEventDefinition(ED_EVENT_ADDED);
        this.addEventDefinition(ED_EVENT_REMOVED);
        this.addEventDefinition(ED_ACTION_ADDED);
        this.addEventDefinition(ED_ACTION_REMOVED);
        this.addEventDefinition(ED_ACTION_STATE_CHANGED);
        this.addEventDefinition(ED_INFO_CHANGED);
        this.addEventDefinition(ED_UPDATED);
        this.addEventDefinition(this.getChangeEventDefinition());
        this.addEventDefinition(ED_DESTROYED);
    }

    private void addPropertiesLockFunctionDefinitions() {
        FunctionDefinition fd = new FunctionDefinition(F_LOCK, FIFT_LOCK, FOFT_LOCK, Cres.get().getString("conPropLockLock"));
        fd.setHidden(true);
        fd.setPermissions(this.getPermissions());
        fd.setImplementation(this.lockImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_UNLOCK, FIFT_UNLOCK, FOFT_UNLOCK, Cres.get().getString("conPropLockUnlock"));
        fd.setHidden(true);
        fd.setPermissions(this.getPermissions());
        fd.setImplementation(this.unlockImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_BREAK_LOCK, null, null, Cres.get().getString("conPropLockBreakLock"));
        fd.setPermissions(this.getPermissions());
        fd.setImplementation(this.breakLockImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_LOCKED_BY, null, FOFT_LOCKED_BY, Cres.get().getString("conPropLockLockedBy"));
        fd.setPermissions(this.getPermissions());
        fd.setImplementation(this.lockedByImpl);
        this.addFunctionDefinition(fd);
    }

    public void setupChildren() throws ContextException {
    }

    @Override
    public void teardown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        LinkedList<Callable<Object>> tasks = new LinkedList<Callable<Object>>();
        this.childrenLock.readLock().lock();
        try {
            for (Context child : this.childrenList) {
                Callable<Object> task = () -> {
                    long startTime = System.currentTimeMillis();
                    child.start();
                    Log.CONTEXT_CHILDREN.debug((Object)("Started context  '" + child.getPath() + "' in " + (System.currentTimeMillis() - startTime) + " ms"));
                    return null;
                };
                tasks.add(task);
            }
        }
        finally {
            this.childrenLock.readLock().unlock();
        }
        this.executeTasks(tasks);
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.stopped = true;
        LinkedList<Callable<Object>> tasks = new LinkedList<Callable<Object>>();
        this.childrenLock.readLock().lock();
        try {
            for (final Context child : this.childrenList) {
                Callable task = new Callable(){

                    public Object call() {
                        long startTime = System.currentTimeMillis();
                        child.stop();
                        Log.CONTEXT_CHILDREN.debug((Object)("Stopped context  '" + child.getPath() + "' in " + (System.currentTimeMillis() - startTime) + " ms"));
                        return null;
                    }
                };
                tasks.add(task);
            }
        }
        finally {
            this.childrenLock.readLock().unlock();
        }
        this.executeTasks(tasks);
        this.started = false;
    }

    @Override
    public int compareTo(Context context) {
        if (this.getIndex() != null || context.getIndex() != null) {
            Integer my = this.getIndex() != null ? this.getIndex() : Integer.valueOf(0);
            Integer other = context.getIndex() != null ? context.getIndex() : Integer.valueOf(0);
            return other.compareTo(my);
        }
        int res = this.getName().compareTo(context.getName());
        if (res == 0 && !this.getName().equals(this.getPath()) && !context.getName().equals(context.getPath())) {
            return this.getPath().compareTo(context.getPath());
        }
        return res;
    }

    @Override
    public List<C> getChildren(CallerController caller) {
        if (!this.checkPermissions(this.getChildrenViewPermissions(), caller, this, null)) {
            return Collections.emptyList();
        }
        LinkedList<C> childList = new LinkedList<C>(this.childrenList);
        Iterator iterator = childList.iterator();
        while (iterator.hasNext()) {
            Context cur = (Context)iterator.next();
            if (this.shouldSeeChild(caller, cur)) continue;
            iterator.remove();
        }
        return childList;
    }

    protected boolean shouldSeeChild(CallerController caller, Context<C> cur) {
        return this.checkPermissions(cur.getPermissions(), caller, cur, null) || this.canSee(caller, cur);
    }

    private boolean canSee(CallerController caller, Context<C> con) {
        if (!this.permissionCheckingEnabled) {
            return true;
        }
        return this.getPermissionChecker().canSee(caller != null ? caller.getPermissions() : null, con.getPath(), this.getContextManager());
    }

    @Override
    public List<C> getChildren() {
        return this.getChildren(null);
    }

    @Override
    public List<C> getVisibleChildren(CallerController caller) {
        return this.getChildren(caller);
    }

    @Override
    public boolean hasVisibleChild(String name, CallerController caller) {
        return this.getChild(name, caller) != null;
    }

    @Override
    public List<C> getVisibleChildren() {
        return this.getVisibleChildren(null);
    }

    @Override
    public boolean isMapped() {
        return false;
    }

    @Override
    public List<C> getMappedChildren(CallerController caller) {
        return this.isMapped() ? this.getVisibleChildren(caller) : this.getChildren(caller);
    }

    @Override
    public List<C> getMappedChildren() {
        return this.getMappedChildren(null);
    }

    @Override
    public boolean hasMappedChild(String contextName, CallerController callerController) {
        return this.isMapped() ? this.hasVisibleChild(contextName, callerController) : this.getChild(contextName, callerController) != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        if (old == null || !old.equals(description)) {
            this.contextInfoChanded();
        }
    }

    @Override
    public C getParent() {
        return this.parent;
    }

    @Override
    public boolean hasParent(C parentContext) {
        if (parentContext == null) {
            return false;
        }
        AbstractContext<C> root = this;
        while (root.getParent() != null) {
            if ((root = root.getParent()) != parentContext) continue;
            return true;
        }
        return false;
    }

    @Override
    public C getRoot() {
        AbstractContext<C> root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return (C)root;
    }

    @Override
    public C get(String contextPath, CallerController caller) {
        Context cached;
        AbstractContext<C> cur;
        if (contextPath == null) {
            return null;
        }
        boolean relative = ContextUtils.isRelative(contextPath);
        if (relative) {
            contextPath = contextPath.substring(1);
        }
        AbstractContext<C> abstractContext = cur = relative ? this : this.getRoot();
        if (contextPath.length() == 0) {
            return (C)cur;
        }
        String fullPath = null;
        if (caller != null && this.getContextManager().isServerManager() && (cached = caller.lookup(fullPath = relative ? ContextUtils.createName(this.getPath(), contextPath) : contextPath)) != null) {
            return (C)cached;
        }
        List<String> names = StringUtils.split(contextPath, ".".charAt(0));
        for (String child : names) {
            if (child.length() == 0) {
                return null;
            }
            if (cur == null) break;
            cur = cur.getChild(child, caller);
        }
        if (caller != null && cur != null && this.getContextManager().isServerManager()) {
            caller.cache(fullPath, cur);
        }
        return (C)cur;
    }

    @Override
    public C get(String contextName) {
        return this.get(contextName, null);
    }

    @Override
    public Permissions getPermissions() {
        if (!this.permissionCheckingEnabled) {
            return DEFAULT_PERMISSIONS;
        }
        if (this.permissions != null) {
            return this.permissions;
        }
        if (this.getParent() != null) {
            return this.getParent().getPermissions();
        }
        return DEFAULT_PERMISSIONS;
    }

    public AbstractContext awaitInitialized() throws ContextException {
        return this;
    }

    protected void setName(String name) {
        this.path = null;
        if (!ContextUtils.isValidContextName(name)) {
            throw new IllegalArgumentException(Cres.get().getString("conIllegalName") + name);
        }
        this.name = name;
    }

    private C getRootWithLookup(CallerController caller) {
        if (caller == null) {
            return this.getRoot();
        }
        Context root = caller.lookup("");
        if (root == null) {
            root = this.getRoot();
            caller.cache("", root);
        }
        return (C)root;
    }

    @Override
    public void setParent(C parent) {
        this.parent = parent;
    }

    protected void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    protected void setPermissionChecker(PermissionChecker permissionChecker) {
        this.permissionChecker = permissionChecker;
    }

    protected void setFireUpdateEvents(boolean fireUpdateEvents) {
        this.fireUpdateEvents = fireUpdateEvents;
    }

    protected boolean isFireUpdateEvents() {
        return this.fireUpdateEvents;
    }

    protected void setContextManager(ContextManager contextManager) {
        if (this.contextManager != null && this.contextManager != contextManager) {
            throw new IllegalStateException("Context manager already set");
        }
        this.contextManager = contextManager;
    }

    protected void setChildrenViewPermissions(Permissions childrenViewPermissions) {
        this.childrenViewPermissions = childrenViewPermissions;
    }

    protected void setChildrenSortingEnabled(boolean childrenSortingEnabled) {
        this.childrenSortingEnabled = childrenSortingEnabled;
    }

    public boolean isChildrenSortingEnabled() {
        return this.childrenSortingEnabled;
    }

    protected void setValueCheckingEnabled(boolean valueCheckingEnabled) {
        this.valueCheckingEnabled = valueCheckingEnabled;
    }

    public boolean isChildrenConcurrencyEnabled() {
        return this.childrenConcurrencyEnabled;
    }

    protected void setChildrenConcurrencyEnabled(boolean childrenConcurrencyEnabled) {
        this.childrenConcurrencyEnabled = childrenConcurrencyEnabled;
    }

    protected void checkPermissions(Permissions needPermissions, CallerController caller, EntityDefinition accessedEntityDefinition) throws ContextSecurityException {
        if (!this.checkPermissions(needPermissions, caller, this, accessedEntityDefinition)) {
            if (this.isEntityProtected(accessedEntityDefinition) && caller != null && caller.isPermissionCheckingEnabled()) {
                throw new ContextSecurityException(MessageFormat.format(Cres.get().getString("conAccessDeniedInProtectedContext"), accessedEntityDefinition.getName(), this.getPath()));
            }
            throw new ContextSecurityException(MessageFormat.format(Cres.get().getString("conAccessDenied"), this.getPath(), caller != null ? caller.getPermissions() : "", needPermissions));
        }
    }

    public boolean checkPermissions(Permissions needPermissions, CallerController caller, Context accessedContext, EntityDefinition accessedEntityDefinition) {
        if (!this.permissionCheckingEnabled) {
            return true;
        }
        if (this.isEntityProtected(accessedEntityDefinition) && caller != null && caller.isPermissionCheckingEnabled()) {
            return false;
        }
        return this.getPermissionChecker().has(caller, needPermissions, accessedContext, accessedEntityDefinition);
    }

    @Override
    public void addChild(C child) {
        this.addChild(child, (Integer)null);
    }

    public void addChild(C child, Integer index) {
        this.addChild(child, index, null);
    }

    public void addChild(C child, DataTable childInfo) {
        this.addChild(child, null, childInfo);
    }

    public void addChild(C child, Integer index, DataTable childInfo) {
        long startTime = System.currentTimeMillis();
        this.addToChildren(child, index);
        try {
            child.setParent((AbstractContext)this);
            child.setup(this.getContextManager());
            this.setChildInfo(child, childInfo);
            if (this.setupComplete && this.fireUpdateEvents) {
                this.fireEvent(E_CHILD_ADDED, child.getName());
            }
            if (this.getContextManager() != null) {
                this.getContextManager().contextAdded(child);
            }
        }
        catch (Exception ex) {
            this.childrenLock.writeLock().lock();
            try {
                this.childrenMap.remove(child.getName());
                this.childrenList.remove(child);
                throw new ContextRuntimeException("Error adding child '" + child + "' to context '" + this + "': " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                this.childrenLock.writeLock().unlock();
                throw throwable;
            }
        }
        Log.CONTEXT_CHILDREN.debug((Object)("Added child '" + child.getName() + "' to '" + this.getPath() + "' in " + (System.currentTimeMillis() - startTime) + " ms"));
    }

    private void setChildInfo(C child, DataTable childInfo) throws ContextException {
        if (childInfo == null) {
            return;
        }
        VariableDefinition vd = child.getVariableDefinition("childInfo");
        if (vd != null) {
            SimpleDataTable settings = new SimpleDataTable(vd.getFormat());
            DataTableReplication.copy(childInfo, settings, true, true, true);
            child.setVariable(vd.getName(), this.getContextManager().getCallerController(), settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToChildren(C child, Integer index) {
        this.childrenLock.writeLock().lock();
        try {
            C existing = this.getChildWithoutCheckingPerms(child.getName());
            if (existing != null) {
                throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("conChildExists"), child.getName(), this.getPath()));
            }
            if (index != null) {
                if (this.childrenSortingEnabled) {
                    throw new IllegalStateException("Cannot add child with pre-defined index as children sorting is enabled");
                }
                this.childrenList.add(index, child);
            } else {
                this.childrenList.add(child);
            }
            this.childrenMap.put(child.getName().toLowerCase(Locale.ENGLISH), child);
            if (this.childrenSortingEnabled && this.childrenList.size() < 10000) {
                Collections.sort(this.childrenList);
            }
        }
        finally {
            this.childrenLock.writeLock().unlock();
        }
    }

    public void removeFromParent() {
        if (this.getParent() != null) {
            this.getParent().removeChild((AbstractContext)this);
        } else {
            Log.CONTEXT_CHILDREN.debug((Object)("Can't remove context '" + this.getPath() + "' from its parent: no parent context was set"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean moving) {
        EventDefinition ed;
        if (!moving) {
            this.stop();
            this.destroyChildren(false);
        }
        if (this.fireUpdateEvents && (ed = this.getEventDefinition(E_DESTROYED)) != null) {
            this.fireEvent(ed.getName());
        }
        this.eventDataLock.readLock().lock();
        try {
            for (EventData ed2 : this.eventData.values()) {
                Logger logger = Log.CONTEXT_EVENTS;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removing all listeners of event '" + ed2.getDefinition().getName() + "'"));
                }
                ed2.clearListeners();
            }
        }
        finally {
            this.eventDataLock.readLock().unlock();
        }
        this.removeFromParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyChildren(boolean moving) {
        this.childrenLock.writeLock().lock();
        try {
            for (Context child : new ArrayList<C>(this.childrenList)) {
                child.destroy(moving);
            }
        }
        finally {
            this.childrenLock.writeLock().unlock();
        }
    }

    @Override
    public void removeChild(C child) {
        block7: {
            child.teardown();
            this.childrenLock.writeLock().lock();
            try {
                if (!this.childrenList.contains(child)) break block7;
                if (this.getContextManager() != null) {
                    try {
                        child.accept(new DefaultContextVisitor<C>(false, false){

                            @Override
                            public boolean shouldVisit(C context) {
                                return true;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void visit(C context) {
                                AbstractContext.this.getContextManager().contextRemoved(context);
                                context.setParent(null);
                                AbstractContext abstractContext = (AbstractContext)context;
                                ReentrantReadWriteLock currentChildLock = abstractContext.childrenLock;
                                currentChildLock.writeLock().lock();
                                try {
                                    abstractContext.childrenList.clear();
                                    abstractContext.childrenMap.clear();
                                }
                                finally {
                                    currentChildLock.writeLock().unlock();
                                }
                            }
                        });
                    }
                    catch (ContextException ex) {
                        throw new ContextRuntimeException(ex);
                    }
                }
                this.childrenMap.remove(child.getName().toLowerCase(Locale.ENGLISH));
                this.childrenList.remove(child);
                if (this.setupComplete && this.fireUpdateEvents) {
                    this.fireEvent(E_CHILD_REMOVED, child.getName());
                }
                child.setParent(null);
            }
            finally {
                this.childrenLock.writeLock().unlock();
            }
        }
    }

    @Override
    public void removeChild(String name) {
        C con = this.getChildWithoutCheckingPerms(name);
        if (con != null) {
            this.removeChild(con);
            return;
        }
        Log.CONTEXT_CHILDREN.debug((Object)("Remove error: child '" + name + "' not found in context " + this.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reorderChild(C child, int index) {
        if (this.childrenSortingEnabled) {
            throw new IllegalStateException("Cannot reorder children when children sorting is enabled");
        }
        this.childrenLock.writeLock().lock();
        try {
            int oi = this.childrenList.indexOf(child);
            if (this.childrenList.remove(child)) {
                this.childrenList.add(index - (oi < index ? 1 : 0), child);
            }
        }
        finally {
            this.childrenLock.writeLock().unlock();
        }
    }

    @Override
    public void destroyChild(C child, boolean moving) {
        child.destroy(moving);
    }

    @Override
    public void updatePrepare() {
    }

    protected void movePrepare(String oldPath, String oldName, String newPath, String newName) throws ContextException {
        for (Context child : this.childrenList) {
            ((AbstractContext)child).movePrepare(ContextUtils.createName(oldPath, child.getName()), child.getName(), ContextUtils.createName(newPath, child.getName()), child.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveInternal(String oldPath, String oldName, String newPath, String newName) throws ContextException {
        this.setName(newName);
        this.eventDataLock.readLock().lock();
        try {
            for (EventData ed : this.eventData.values()) {
                ed.updateContext(oldPath, newPath);
            }
        }
        finally {
            this.eventDataLock.readLock().unlock();
        }
        this.childrenLock.readLock().lock();
        try {
            for (Context child : this.childrenList) {
                ((AbstractContext)child).moveInternal(ContextUtils.createName(oldPath, child.getName()), child.getName(), ContextUtils.createName(newPath, child.getName()), child.getName());
            }
        }
        finally {
            this.childrenLock.readLock().unlock();
        }
    }

    protected void moveFinalize(String oldPath, String oldName, String newPath, String newName) throws ContextException {
        for (Context child : this.childrenList) {
            ((AbstractContext)child).moveFinalize(ContextUtils.createName(oldPath, child.getName()), child.getName(), ContextUtils.createName(newPath, child.getName()), child.getName());
        }
    }

    @Override
    public void move(C newParent, String newName) throws ContextException {
        this.move(this.getPath(), (Context)newParent, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(String oldPath, Context newParent, String newName) throws ContextException {
        Log.CONTEXT.debug((Object)("Moving context " + this.getPath() + " to " + newParent.getPath() + " and/or renaming to " + newName));
        String oldName = this.getName();
        String newPath = ContextUtils.createName(newParent.getPath(), newName);
        this.movePrepare(oldPath, oldName, newPath, newName);
        this.lockUnlockVariables(true);
        try {
            this.getParent().destroyChild((AbstractContext)this, true);
            this.moveInternal(oldPath, oldName, newPath, newName);
            newParent.addChild(this);
        }
        finally {
            this.lockUnlockVariables(false);
        }
        this.moveFinalize(oldPath, oldName, newPath, newName);
    }

    private void lockUnlockVariables(boolean lock) throws ContextException {
        for (VariableDefinition vd : this.getVariableDefinitions(this.contextManager.getCallerController())) {
            VariableData vdata = this.getVariableData(vd.getName());
            if (lock) {
                try {
                    if (vdata.getReadWriteLock().writeLock().tryLock(2L, TimeUnit.MINUTES)) continue;
                    throw new ContextException(Cres.get().getString("conLockFailed"));
                }
                catch (InterruptedException ex) {
                    throw new ContextException(Cres.get().getString("conLockFailed"), ex);
                }
            }
            if (!vdata.getReadWriteLock().writeLock().isHeldByCurrentThread()) continue;
            vdata.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public C getChild(String name, CallerController caller) {
        if (!this.checkPermissions(this.getChildrenViewPermissions(), caller, this, null)) {
            return null;
        }
        C child = this.getChildWithoutCheckingPerms(name);
        if (child != null && this.shouldSeeChild(caller, (Context<C>)child)) {
            return child;
        }
        return null;
    }

    @Override
    public C getChild(String name) {
        return this.getChild(name, null);
    }

    private C getChildWithoutCheckingPerms(String name) {
        return (C)((Context)this.childrenMap.get(name.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public String getPath() {
        if (this.getParent() == null) {
            return this.createPath();
        }
        if (this.path == null) {
            this.path = this.createPath();
        }
        return this.path;
    }

    private String createPath() {
        AbstractContext<C> con = this;
        String nm = this.getName();
        do {
            if ((con = con.getParent()) == null || con.getParent() == null) continue;
            nm = con.getName() + "." + nm;
        } while (con != null);
        return nm;
    }

    @Override
    public boolean addEventListener(String name, ContextEventListener listener) {
        return this.addEventListener(name, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addEventListener(String name, ContextEventListener listener, boolean weak) {
        EventData ed = this.getEventData(name);
        if (ed == null) {
            throw new IllegalArgumentException(Cres.get().getString("conEvtNotAvail") + name);
        }
        try {
            Permissions permissions = ed.getDefinition().getPermissions() != null ? ed.getDefinition().getPermissions() : this.getPermissions();
            this.checkPermissions(permissions, listener.getCallerController(), ed.getDefinition());
        }
        catch (ContextSecurityException ex) {
            Log.CONTEXT_EVENTS.warn((Object)("Error adding listener '" + listener + "' of event '" + ed.getDefinition().getName() + "' in context '" + this.getPath() + "': " + ex.getMessage()), (Throwable)ex);
            return false;
        }
        Logger logger = Log.CONTEXT_EVENTS;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding '" + listener + "' as listener of event '" + ed.getDefinition().getName() + "' in '" + this.getPath() + "'"));
        }
        EventData eventData = ed;
        synchronized (eventData) {
            return ed.addListener(listener, weak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEventListener(String name, ContextEventListener listener) {
        EventData ed = this.getEventData(name);
        if (ed == null) {
            Log.CONTEXT_EVENTS.warn((Object)("Error removing listener of event '" + name + "' in context '" + this.getPath() + "': event definition not found"), (Throwable)new Exception());
            return false;
        }
        Logger logger = Log.CONTEXT_EVENTS;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing '" + listener + "' listener of event '" + ed.getDefinition().getName() + "' in '" + this.getPath() + "'"));
        }
        EventData eventData = ed;
        synchronized (eventData) {
            return ed.removeListener(listener);
        }
    }

    @Override
    public List<VariableDefinition> getVariableDefinitions(CallerController caller) {
        return this.getVariableDefinitions(caller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VariableDefinition> getVariableDefinitions(CallerController caller, boolean includeHidden) {
        ArrayList<VariableDefinition> list = null;
        this.variableDataLock.readLock().lock();
        try {
            Collection<VariableData> values = this.variableData.values();
            list = new ArrayList<VariableDefinition>(values.size());
            boolean debug = caller != null && caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_DEBUG);
            for (VariableData d : values) {
                VariableDefinition def = d.getDefinition();
                if ((caller == null || caller.isPermissionCheckingEnabled()) && !includeHidden && def.isHidden() && !debug) continue;
                Permissions readPermissions = def.getReadPermissions() != null ? def.getReadPermissions() : this.getPermissions();
                Permissions writePermissions = def.getWritePermissions() != null ? def.getWritePermissions() : this.getPermissions();
                writePermissions = new Permissions(writePermissions.getPermissions(), true);
                boolean readAccessGranted = this.checkPermissions(readPermissions, caller, this, def);
                boolean writeAccessGranted = this.checkPermissions(writePermissions, caller, this, def);
                if (!readAccessGranted && !writeAccessGranted) continue;
                if (def.isReadable() == readAccessGranted && def.isWritable() == writeAccessGranted) {
                    list.add(def);
                    continue;
                }
                VariableDefinition clone = def.clone();
                clone.setReadable(def.isReadable() && readAccessGranted);
                clone.setWritable(def.isWritable() && writeAccessGranted);
                list.add(clone);
            }
        }
        finally {
            this.variableDataLock.readLock().unlock();
        }
        return list;
    }

    @Override
    public List<VariableDefinition> getVariableDefinitions() {
        return this.getVariableDefinitions((CallerController)null);
    }

    @Override
    public List<VariableDefinition> getVariableDefinitions(CallerController caller, String group) {
        List<VariableDefinition> vars = this.getVariableDefinitions(caller);
        ArrayList<VariableDefinition> defs = new ArrayList<VariableDefinition>(vars.size());
        for (VariableDefinition vd : vars) {
            if (!this.isBelongedToTheGroup(group, vd.getGroup())) continue;
            defs.add(vd);
        }
        return defs;
    }

    @Override
    public List<VariableDefinition> getVariableDefinitions(String group) {
        return this.getVariableDefinitions(null, group);
    }

    public PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    @Override
    public Permissions getChildrenViewPermissions() {
        return this.childrenViewPermissions != null ? this.childrenViewPermissions : this.getPermissions();
    }

    @Override
    public ContextManager<C> getContextManager() {
        return this.contextManager;
    }

    @Override
    public boolean isSetupComplete() {
        return this.setupComplete;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isEntityProtected(EntityDefinition ed) {
        return false;
    }

    @Override
    public boolean isInitializedStatus() {
        return this.setupComplete;
    }

    @Override
    public boolean isInitializedInfo() {
        return this.setupComplete;
    }

    @Override
    public boolean isInitializedChildren() {
        return this.setupComplete;
    }

    @Override
    public boolean isInitializedVariables() {
        return this.setupComplete;
    }

    @Override
    public boolean isInitializedFunctions() {
        return this.setupComplete;
    }

    @Override
    public boolean isInitializedEvents() {
        return this.setupComplete;
    }

    @Override
    public List<FunctionDefinition> getFunctionDefinitions(CallerController caller) {
        return this.getFunctionDefinitions(caller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionDefinition> getFunctionDefinitions(CallerController caller, boolean includeHidden) {
        LinkedList<FunctionDefinition> list = new LinkedList<FunctionDefinition>();
        boolean debug = caller != null && caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_DEBUG);
        this.functionDataLock.readLock().lock();
        try {
            for (FunctionData d : this.functionData.values()) {
                FunctionDefinition def = d.getDefinition();
                Permissions permissions = def.getPermissions() != null ? def.getPermissions() : this.getPermissions();
                if (!this.checkPermissions(permissions, caller, this, def) || (caller == null || caller.isPermissionCheckingEnabled()) && !includeHidden && def.isHidden() && !debug) continue;
                list.add(def);
            }
        }
        finally {
            this.functionDataLock.readLock().unlock();
        }
        return list;
    }

    @Override
    public List<FunctionDefinition> getFunctionDefinitions() {
        return this.getFunctionDefinitions((CallerController)null);
    }

    @Override
    public List<FunctionDefinition> getFunctionDefinitions(CallerController caller, String group) {
        LinkedList<FunctionDefinition> defs = new LinkedList<FunctionDefinition>();
        for (FunctionDefinition fd : this.getFunctionDefinitions(caller)) {
            if (!this.isBelongedToTheGroup(group, fd.getGroup())) continue;
            defs.add(fd);
        }
        return defs;
    }

    @Override
    public List<FunctionDefinition> getFunctionDefinitions(String group) {
        return this.getFunctionDefinitions(null, group);
    }

    protected ReentrantReadWriteLock getChildrenLock() {
        return this.childrenLock;
    }

    @Override
    public String getType() {
        return this.type != null ? this.type : ContextUtils.getTypeForClass(this.getClass());
    }

    public boolean isPermissionCheckingEnabled() {
        return this.permissionCheckingEnabled;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getLocalRoot(boolean withParent) {
        return "";
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public String getPeerRoot() {
        return null;
    }

    @Override
    public String getRemoteRoot() {
        return null;
    }

    @Override
    public String getRemotePath() {
        return this.getPath();
    }

    @Override
    public String getPeerPath() {
        return this.getPath();
    }

    @Override
    public String getLocalPrimaryRoot() {
        return null;
    }

    public void setType(String type) {
        if (!ContextUtils.isValidContextType(type)) {
            throw new IllegalArgumentException(Cres.get().getString("conIllegalType") + type);
        }
        String old = this.type;
        this.type = type;
        if (old == null || !old.equals(type)) {
            this.contextInfoChanded();
        }
    }

    protected void setPermissionCheckingEnabled(boolean permissionCheckingEnabled) {
        this.permissionCheckingEnabled = permissionCheckingEnabled;
    }

    protected void setIconId(String iconId) {
        String old = this.iconId;
        this.iconId = iconId;
        if (old == null || !old.equals(iconId)) {
            this.contextInfoChanded();
        }
    }

    private void contextInfoChanded() {
        if (this.setupComplete) {
            EventDefinition ed;
            ContextManager<C> cm = this.getContextManager();
            if (cm != null) {
                cm.contextInfoChanged(this);
            }
            if (this.fireUpdateEvents && (ed = this.getEventDefinition(E_INFO_CHANGED)) != null) {
                this.fireEvent(E_INFO_CHANGED, this.createContextInfoTable());
            }
        }
    }

    @Deprecated
    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setGroup(String group) {
        String old = this.group;
        this.group = group;
        if (old == null || !old.equals(group)) {
            this.contextInfoChanded();
        }
    }

    @Override
    public List<EventDefinition> getEventDefinitions(CallerController caller) {
        return this.getEventDefinitions(caller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EventDefinition> getEventDefinitions(CallerController caller, boolean includeHidden) {
        LinkedList<EventDefinition> list = new LinkedList<EventDefinition>();
        boolean debug = caller != null && caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_DEBUG);
        this.eventDataLock.readLock().lock();
        try {
            for (EventData d : this.eventData.values()) {
                Permissions permissions = d.getDefinition().getPermissions() != null ? d.getDefinition().getPermissions() : this.getPermissions();
                if (!this.checkPermissions(permissions, caller, this, d.getDefinition()) || (caller == null || caller.isPermissionCheckingEnabled()) && !includeHidden && d.getDefinition().isHidden() && !debug) continue;
                list.add(d.getDefinition());
            }
        }
        finally {
            this.eventDataLock.readLock().unlock();
        }
        return list;
    }

    @Override
    public List<EventDefinition> getEventDefinitions() {
        return this.getEventDefinitions((CallerController)null);
    }

    @Override
    public List<EventDefinition> getEventDefinitions(CallerController caller, String group) {
        LinkedList<EventDefinition> res = new LinkedList<EventDefinition>();
        for (EventDefinition ed : this.getEventDefinitions(caller)) {
            if (!this.isBelongedToTheGroup(group, ed.getGroup())) continue;
            res.add(ed);
        }
        return res;
    }

    @Override
    public List<EventDefinition> getEventDefinitions(String group) {
        return this.getEventDefinitions(null, group);
    }

    @Override
    public ActionDefinition getActionDefinition(String name) {
        this.actionDefinitionsLock.readLock().lock();
        try {
            ActionDefinition actionDefinition = this.getActionDefinition(this.actionDefinitions, this.actionNameByAlias, name);
            return actionDefinition;
        }
        finally {
            this.actionDefinitionsLock.readLock().unlock();
        }
    }

    @Override
    public ActionDefinition getActionDefinition(String name, CallerController caller) {
        return this.getActionDefinition(this.getActionDefinitions(caller, true), this.actionNameByAlias, name);
    }

    @Override
    public ActionDefinition getDefaultActionDefinition(CallerController caller) {
        for (ActionDefinition ad : this.getActionDefinitions(caller, true)) {
            if (!ad.isDefault()) continue;
            return ad;
        }
        return null;
    }

    @Override
    public List<ActionDefinition> getActionDefinitions(CallerController caller) {
        return this.getActionDefinitions(caller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionDefinition(ActionDefinition def) {
        if (def.getName() == null) {
            throw new NullPointerException("Action name can't be NULL");
        }
        this.actionDefinitionsLock.writeLock().lock();
        try {
            EventDefinition ed;
            Iterator<ActionDefinition> iterator = this.actionDefinitions.iterator();
            while (iterator.hasNext()) {
                ActionDefinition actionDefinition = iterator.next();
                boolean actionAlreadyPresent = def.getName().equals(actionDefinition.getName());
                if (!actionAlreadyPresent) continue;
                iterator.remove();
                break;
            }
            this.actionDefinitions.add(def);
            Collections.sort(this.actionDefinitions);
            if (this.isSetupComplete() && this.isFireUpdateEvents() && (ed = this.getEventDefinition(E_ACTION_ADDED)) != null) {
                this.fireEvent(ed.getName(), this.actDefToDataRecord(def).wrap());
            }
        }
        finally {
            this.actionDefinitionsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActionDefinition> getActionDefinitions(CallerController caller, boolean includeHidden) {
        LinkedList<ActionDefinition> list = new LinkedList<ActionDefinition>();
        boolean debug = caller != null && caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_DEBUG);
        this.actionDefinitionsLock.readLock().lock();
        try {
            for (ActionDefinition d : this.actionDefinitions) {
                if (!this.checkPermissions(d.getPermissions() != null ? d.getPermissions() : this.getPermissions(), caller, this, d) || d.isHidden() && !debug && !includeHidden) continue;
                list.add(d);
            }
        }
        finally {
            this.actionDefinitionsLock.readLock().unlock();
        }
        return list;
    }

    @Override
    public List<ActionDefinition> getActionDefinitions() {
        return this.getActionDefinitions(null);
    }

    protected void applyCachedFormat(Supplier<TableFormat> formatGetter, Consumer<TableFormat> formatSetter) {
        TableFormat format = formatGetter.get();
        if (format == null || !format.isImmutable()) {
            return;
        }
        Optional<FormatCache> formatCacheOpt = this.obtainFormatCache();
        if (formatCacheOpt.isPresent()) {
            FormatCache formatCache = formatCacheOpt.get();
            format.applyCachedFormat(formatCache, formatSetter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionDefinition(String name) {
        ActionDefinition def = this.getActionDefinition(name);
        this.actionDefinitionsLock.writeLock().lock();
        try {
            EventDefinition ed;
            if (this.actionDefinitions.remove(def) && this.isSetupComplete() && this.isFireUpdateEvents() && (ed = this.getEventDefinition(E_ACTION_REMOVED)) != null) {
                this.fireEvent(ed.getName(), name);
            }
        }
        finally {
            this.actionDefinitionsLock.writeLock().unlock();
        }
    }

    public ActionDefinition actDefFromDataRecord(DataRecord rec) {
        DataTable dropSourcesTable;
        BasicActionDefinition def = new BasicActionDefinition(rec.getString("name"));
        def.setDescription(rec.getString("description"));
        def.setHelp(rec.getString("help"));
        String accelerator = rec.getString("accelerator");
        if (accelerator != null) {
            def.setAccelerator(new KeyStroke(accelerator));
        }
        if ((dropSourcesTable = rec.getDataTable("dropSources")) != null && dropSourcesTable.getRecordCount() > 0) {
            LinkedList<ResourceMask> dropSources = new LinkedList<ResourceMask>();
            for (DataRecord ds : dropSourcesTable) {
                dropSources.add(new TreeMask(ds.getString("resourceMask")));
            }
            def.setDropSources(dropSources);
        }
        def.setHidden(rec.getBoolean("hidden"));
        def.setEnabled(rec.getBoolean("enabled"));
        def.setIconId(rec.getString("iconId"));
        def.setGroup(rec.getString("group"));
        String executionGroup = rec.getString("executionGroup");
        if (executionGroup != null) {
            def.setExecutionGroup(new GroupIdentifier(executionGroup));
        }
        if (rec.hasField("permissions")) {
            def.setPermissions(new Permissions(rec.getString("permissions")));
        }
        def.setDefault(rec.getBoolean("default"));
        return def;
    }

    private DataTable getVariable(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        long startTime = System.currentTimeMillis();
        this.setupVariables();
        VariableData data = this.getVariableData(def.getName());
        this.lock(request, data.getReadWriteLock().readLock());
        boolean hasSpan = this.beginSpan(request, def);
        try {
            DataTable result;
            Permissions permissions = def.getReadPermissions() != null ? def.getReadPermissions() : this.getPermissions();
            this.checkPermissions(permissions, caller, def);
            if (Log.CONTEXT_VARIABLES.isDebugEnabled()) {
                Log.CONTEXT_VARIABLES.debug((Object)("Trying to get variable '" + def.getName() + "' from context '" + this.getPath() + "'"));
            }
            if (hasSpan) {
                this.traceOperation(ContextOperationType.GET_VARIABLE);
            }
            if ((result = this.executeGetter(data, caller, request)).isInvalid()) {
                throw new ContextException(result.getInvalidationMessage());
            }
            result = this.checkVariableValue(def, result, caller);
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            if (duration > 20000L) {
                Level level = duration > 120000L ? Level.INFO : Level.DEBUG;
                Log.PERFORMANCE.log((Priority)level, (Object)("Getting value of variable '" + def + "' in context '" + this.getPath() + "' took " + duration + " milliseconds"));
            }
            this.logAsyncSessionExecutionAction(caller, request, ContextOperationType.GET_VARIABLE, def.getName(), null, result, duration);
            DataTable dataTable = result;
            return dataTable;
        }
        catch (Exception ex) {
            throw new ContextException(MessageFormat.format(Cres.get().getString("conErrGettingVar"), def.toString(), this.toString()) + ex.getMessage(), ex);
        }
        finally {
            data.getReadWriteLock().readLock().unlock();
            data.registerGetOperation();
            if (hasSpan) {
                this.endSpan();
            }
        }
    }

    private DataTable checkVariableValue(VariableDefinition def, DataTable val, CallerController caller) throws ContextException {
        String msg;
        if (!this.valueCheckingEnabled) {
            return val;
        }
        DataTable value = val;
        if (!(caller != null && caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_NO_VALIDATION) || (msg = this.checkVariableValueFormat(def, value)) == null)) {
            Log.CONTEXT_VARIABLES.debug((Object)("Invalid value of variable '" + def.getName() + "': " + msg));
            DataTable newValue = this.getDefaultValue(def);
            DataTableReplication.copy(value, newValue, true, true, true, true, true);
            List<CompatibilityConverter> converters = def.getCompatibilityConverters();
            if (converters != null) {
                for (CompatibilityConverter converter : converters) {
                    try {
                        newValue = converter.convert(value, newValue);
                    }
                    catch (Exception ex) {
                        Log.CONTEXT_VARIABLES.warn((Object)("Error converting value of variable '" + def.getName() + "' by '" + converter + "': " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
            value = newValue;
            this.checkVariableValueFormat(def, value);
        }
        return value;
    }

    private String checkVariableValueFormat(VariableDefinition def, DataTable table) {
        String msg;
        if (!this.valueCheckingEnabled) {
            return null;
        }
        if (def.getCompatibilityValidator() != null) {
            return def.getCompatibilityValidator().needConvertVariableFormat(def, table);
        }
        TableFormat requiredFormat = def.getFormat();
        if (requiredFormat != null && (msg = table.conformMessage(requiredFormat)) != null) {
            return "Invalid format: " + msg;
        }
        return null;
    }

    private DataTable executeGetter(VariableData data, CallerController caller, RequestController request) throws IllegalAccessException, ContextException {
        DataTable result = this.executeGetterMethod(data, caller, request);
        if (result != null) {
            return result;
        }
        VariableDefinition def = data.getDefinition();
        if (def.getGetter() != null) {
            result = def.getGetter().get(this, def, caller, request);
        }
        if (result != null) {
            return result;
        }
        result = this.getVariableImpl(def, caller, request);
        if (result != null) {
            return result;
        }
        return this.executeDefaultGetter(def, caller, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTable executeGetterMethod(VariableData data, CallerController caller, RequestController request) throws IllegalArgumentException, IllegalAccessException, ContextException {
        Method getter;
        if (!data.isGetterCached()) {
            Class[] params = new Class[]{VariableDefinition.class, CallerController.class, RequestController.class};
            try {
                String methodName = GETTER_METHOD_PREFIX + data.getDefinition().getName();
                if (Arrays.stream(this.getClass().getMethods()).noneMatch(m -> m.getName().equals(methodName) && Arrays.equals(m.getParameterTypes(), params))) {
                    DataTable dataTable = null;
                    return dataTable;
                }
                Method getter2 = this.getClass().getMethod(methodName, params);
                data.setGetterMethod(getter2);
            }
            catch (NoSuchMethodException ex) {
                DataTable dataTable = null;
                return dataTable;
            }
            finally {
                data.setGetterCached(true);
            }
        }
        if ((getter = data.getGetterMethod()) != null) {
            try {
                return (DataTable)getter.invoke((Object)this, data.getDefinition(), caller, request);
            }
            catch (InvocationTargetException ex) {
                throw new ContextException(ex.getCause().getMessage(), ex.getCause());
            }
        }
        return null;
    }

    public DataTable executeDefaultGetter(String name, CallerController caller) throws ContextException {
        return this.executeDefaultGetter(name, caller, true);
    }

    public DataTable executeDefaultGetter(String name, CallerController caller, boolean check) throws ContextException {
        return this.executeDefaultGetter(name, caller, check, true);
    }

    public DataTable executeDefaultGetter(String name, CallerController caller, boolean check, boolean createDefault) throws ContextException {
        VariableDefinition def = this.getVariableDefinition(name);
        if (def == null) {
            throw new ContextException(MessageFormat.format(Cres.get().getString("conVarNotAvailExt"), name, this.getPath()));
        }
        return this.executeDefaultGetter(def, caller, check, createDefault);
    }

    private DataTable executeDefaultGetter(VariableDefinition def, CallerController caller, boolean check, boolean createDefault) throws ContextException {
        DataTable value = this.executeDefaultGetterImpl(def, caller);
        if (value == null) {
            return createDefault ? this.getDefaultValue(def) : null;
        }
        return check ? this.checkVariableValue(def, value, caller) : value;
    }

    protected DataTable executeDefaultGetterImpl(VariableDefinition vd, CallerController caller) throws ContextException {
        Object value = this.getVariableData(vd.getName()).getValue();
        return value != null ? (DataTable)value : this.getDefaultValue(vd);
    }

    public int hashCode() {
        if (this.getParent() == null) {
            return super.hashCode();
        }
        int prime = 31;
        int result = 1;
        C root = this.getRoot();
        String path = this.getPath();
        result = 31 * result + (root == null ? 0 : root.hashCode());
        result = 31 * result + (path == null ? 0 : path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractContext)) {
            return false;
        }
        AbstractContext other = (AbstractContext)obj;
        if (this.getRoot() != other.getRoot()) {
            return false;
        }
        return Util.equals(this.getPath(), other.getPath());
    }

    @Override
    public DataTable getVariable(String name, CallerController caller, RequestController request) throws ContextException {
        return this.getVariable(this.getAndCheckVariableDefinition(name), caller, request);
    }

    @Override
    public DataTable getVariable(String name, CallerController caller) throws ContextException {
        return this.getVariable(this.getAndCheckVariableDefinition(name), caller, null);
    }

    @Override
    public DataTable getVariable(String name) throws ContextException {
        return this.getVariable(this.getAndCheckVariableDefinition(name), null, null);
    }

    @Override
    public DataTable getVariableClone(String name, CallerController caller) throws ContextException {
        return this.getVariable(name, caller).clone();
    }

    protected DataTable getVariableImpl(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getVariableObject(String name, CallerController caller) {
        try {
            VariableDefinition def = this.getAndCheckVariableDefinition(name);
            VariableData data = this.getVariableData(name);
            data.getReadWriteLock().readLock().lock();
            try {
                if (this.isSetupComplete() && data.getValue() != null) {
                    Object object = data.getValue();
                    return object;
                }
                if (def.getValueClass() == null) {
                    throw new ContextException("Value class not defined for variable: " + def.toDetailedString());
                }
                List value = null;
                DataTable table = this.getVariable(name, caller);
                List list = DataTableConversion.beansFromTable(table, def.getValueClass(), def.getFormat(), true);
                value = def.getFormat().isSingleRecord() ? list.get(0) : list;
                if (this.isSetupComplete() && def.isLocalCachingEnabled() && !data.getReadWriteLock().isWriteLockedByCurrentThread()) {
                    data.setValue(value);
                }
                List list2 = value;
                return list2;
            }
            finally {
                data.getReadWriteLock().readLock().unlock();
            }
        }
        catch (Exception ex) {
            throw new ContextRuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVariable(VariableDefinition def, CallerController caller, RequestController request, DataTable value) throws ContextException {
        boolean readLockedBySameThread;
        this.validateVariableValueToSet(def, value);
        long startTime = System.currentTimeMillis();
        this.setupVariables();
        VariableData data = this.getVariableData(def.getName());
        boolean bl = readLockedBySameThread = data.getReadWriteLock().getReadHoldCount() > 0;
        if (!readLockedBySameThread) {
            this.lock(request, data.getReadWriteLock().writeLock());
        }
        boolean hasSpan = this.beginSpan(request, def);
        try {
            DataTable oldValue;
            DataTable resultingValue;
            block23: {
                boolean valueNotChanged;
                if (value == null) {
                    throw new ContextException("Value cannot be NULL");
                }
                resultingValue = value;
                Permissions writePermissions = def.getWritePermissions() != null ? def.getWritePermissions() : this.getPermissions();
                writePermissions = new Permissions(writePermissions.getPermissions(), true);
                this.checkPermissions(writePermissions, caller, def);
                if (!def.isWritable() && caller != null && caller.isPermissionCheckingEnabled()) {
                    throw new ContextException(Cres.get().getString("conVarReadOnly"));
                }
                if (Log.CONTEXT_VARIABLES.isDebugEnabled()) {
                    Log.CONTEXT_VARIABLES.debug((Object)("Trying to set variable '" + def.getName() + "' in context '" + this.getPath() + "'"));
                }
                if (hasSpan) {
                    this.traceOperation(ContextOperationType.SET_VARIABLE);
                }
                oldValue = null;
                if (def.isAddPreviousValueToVariableUpdateEvent().booleanValue() || def.storeChangesOnlyInHistory()) {
                    oldValue = this.getVariable(def, caller, request);
                }
                if (!def.storeChangesOnlyInHistory() || !(valueNotChanged = value.equals(oldValue))) break block23;
                return;
            }
            try {
                long endTime;
                long duration;
                String msg;
                if (caller == null || !caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_NO_VALIDATION)) {
                    value.validate(this, this.getContextManager(), caller);
                }
                if (value.getTimestamp() == null) {
                    resultingValue = value = value.cloneIfImmutable();
                    value.setTimestamp(new Date());
                }
                if (value.isSimple() && def.getFormat() != null && def.getFormat().hasReadOnlyFields() && caller != null && caller.isPermissionCheckingEnabled()) {
                    resultingValue = this.getVariable(def, caller, request).clone();
                    DataTableReplication.copy(value, resultingValue, false, true, true, true, true);
                    this.checkVariableValueFormat(def, resultingValue);
                }
                if (!(caller != null && caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_NO_VALIDATION) || (msg = this.checkVariableValueFormat(def, resultingValue)) == null)) {
                    Log.CONTEXT_VARIABLES.debug((Object)("Invalid value of variable '" + def.getName() + "': " + msg + " (value: " + resultingValue + ")"));
                    value = resultingValue;
                    resultingValue = this.getVariable(def, caller, request).clone();
                    DataTableReplication.copy(value, resultingValue, true, true, true, true, true);
                }
                if (def.isLocalCachingEnabled()) {
                    data.setValue(null);
                }
                if (this.executeSetter(data, caller, request, resultingValue)) {
                    this.variableUpdated(def, caller, request, resultingValue, oldValue);
                }
                if ((duration = (endTime = System.currentTimeMillis()) - startTime) > 20000L) {
                    Level level = duration > 120000L ? Level.INFO : Level.DEBUG;
                    Log.PERFORMANCE.log((Priority)level, (Object)("Setting value of variable '" + def + "' in context '" + this.getPath() + "' took " + duration + " milliseconds"));
                }
                this.logAsyncSessionExecutionAction(caller, request, ContextOperationType.SET_VARIABLE, def.getName(), value, null, duration);
            }
            catch (ValidationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ContextException(MessageFormat.format(Cres.get().getString("conErrSettingVar"), def.toString(), this.toString()) + ex.getMessage(), ex);
            }
        }
        finally {
            if (!readLockedBySameThread) {
                data.getReadWriteLock().writeLock().unlock();
            }
            data.registerSetOperation();
            if (hasSpan) {
                this.endSpan();
            }
        }
    }

    protected void variableUpdated(VariableDefinition def, CallerController caller, RequestController request, DataTable value, DataTable valueOld) throws ContextException {
        this.fireUpdatedEvent(def, caller, request, value, valueOld);
        this.fireChangeEvent(def, caller, new Date(), value);
    }

    protected void fireUpdatedEvent(VariableDefinition def, CallerController caller, RequestController request, DataTable value, DataTable valueOld) throws ContextException {
        EventDefinition ed;
        boolean callerAllowsUpdatedEvents;
        boolean bl = callerAllowsUpdatedEvents = caller == null || !caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_NO_UPDATED_EVENTS);
        if (this.isAllowUpdatedEvents(def) && callerAllowsUpdatedEvents && (ed = this.getEventDefinition(E_UPDATED)) != null) {
            SimpleDataTable status = new SimpleDataTable(VFT_VARIABLE_STATUSES);
            VariableStatus variableStatus = this.getVariableStatus(def);
            if (variableStatus != null) {
                status = new SimpleDataTable(VFT_VARIABLE_STATUSES, def.getName(), variableStatus.getStatus(), variableStatus.getComment());
            }
            int updateOriginator = request != null ? request.getOriginator().getOriginatorType() : 0;
            this.fireEvent(E_UPDATED, def.getName(), value, valueOld, caller != null ? caller.getUsername() : null, updateOriginator, status);
        }
    }

    public void fireChangeEvent(VariableDefinition def, CallerController caller, Date timestamp, DataTable value) {
        EventDefinition ed;
        boolean callerAllowsChangeEvents;
        boolean bl = callerAllowsChangeEvents = caller == null || !caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_NO_CHANGE_EVENTS);
        if (this.isAllowUpdatedEvents(def) && callerAllowsChangeEvents && (ed = this.getEventDefinition(E_CHANGE)) != null) {
            FireChangeEventRequestController fer = new FireChangeEventRequestController(def.getChangeEventsExpirationPeriod(), def, value);
            SimpleDataTable eventData = new SimpleDataTable(ed.getFormat(), def.getName());
            this.fireEvent(ed, eventData, 0, null, timestamp, null, caller, fer, null);
        }
    }

    protected boolean isAllowUpdatedEvents(VariableDefinition def) {
        return this.setupComplete && this.fireUpdateEvents && def != null && def.isAllowUpdateEvents();
    }

    protected void setupVariables() throws ContextException {
    }

    private boolean executeSetter(VariableData data, CallerController caller, RequestController request, DataTable value) throws IllegalAccessException, ContextException {
        VariableDefinition def = data.getDefinition();
        if (!this.isAllowSetterExecution(def, request, value)) {
            return false;
        }
        if (this.executeSetterMethod(data, caller, request, value)) {
            return true;
        }
        if (def.getSetter() != null && def.getSetter().set(this, def, caller, request, value)) {
            return true;
        }
        if (this.setVariableImpl(def, caller, request, value)) {
            return true;
        }
        this.executeDefaultSetter(def, caller, value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSetterMethod(VariableData data, CallerController caller, RequestController request, DataTable value) throws IllegalArgumentException, IllegalAccessException, ContextException {
        Method setter;
        if (!data.isSetterCached()) {
            Class[] params = new Class[]{VariableDefinition.class, CallerController.class, RequestController.class, DataTable.class};
            try {
                String methodName = SETTER_METHOD_PREFIX + data.getDefinition().getName();
                if (Arrays.stream(this.getClass().getMethods()).noneMatch(m -> m.getName().equals(methodName) && Arrays.equals(m.getParameterTypes(), params))) {
                    boolean bl = false;
                    return bl;
                }
                Method setter2 = this.getClass().getMethod(methodName, params);
                data.setSetterMethod(setter2);
            }
            catch (NoSuchMethodException ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                data.setSetterCached(true);
            }
        }
        if ((setter = data.getSetterMethod()) != null) {
            try {
                setter.invoke((Object)this, data.getDefinition(), caller, request, value);
                return true;
            }
            catch (InvocationTargetException ex) {
                throw new ContextException(ex.getCause().getMessage(), ex.getCause());
            }
        }
        return false;
    }

    public DataTable getDefaultValue(VariableDefinition def) {
        DataTable defaultValue = def.getDefaultValue();
        if (defaultValue != null) {
            return defaultValue;
        }
        return new SimpleDataTable(def.getFormat(), true);
    }

    public void executeDefaultSetter(String name, CallerController caller, DataTable value) throws ContextException {
        VariableDefinition def = this.getVariableDefinition(name);
        if (def == null) {
            throw new ContextException(MessageFormat.format(Cres.get().getString("conVarNotAvailExt"), name, this.getPath()));
        }
        this.executeDefaultSetter(def, caller, value);
    }

    public void executeDefaultSetter(VariableDefinition def, CallerController caller, DataTable value) throws ContextException {
        this.executeDefaultSetterImpl(def, caller, value);
    }

    protected void executeDefaultSetterImpl(VariableDefinition vd, CallerController caller, DataTable value) throws ContextException {
        this.getVariableData(vd.getName()).setValue(value);
    }

    @Override
    public void setVariable(String name, CallerController caller, RequestController request, DataTable value) throws ContextException {
        VariableDefinition def = this.getAndCheckVariableDefinition(name);
        this.setVariable(def, caller, request, value);
    }

    @Override
    public void setVariable(String name, CallerController caller, DataTable value) throws ContextException {
        this.setVariable(name, caller, null, value);
    }

    @Override
    public void setVariable(String name, DataTable value) throws ContextException {
        this.setVariable(name, null, null, value);
    }

    @Override
    public void setVariable(String name, CallerController caller, Object ... value) throws ContextException {
        VariableDefinition def = this.getAndCheckVariableDefinition(name);
        this.setVariable(name, caller, null, (DataTable)new SimpleDataTable(def.getFormat(), value));
    }

    @Override
    public void setVariable(String name, Object ... value) throws ContextException {
        this.setVariable(name, null, value);
    }

    protected boolean setVariableImpl(VariableDefinition def, CallerController caller, RequestController request, DataTable value) throws ContextException {
        return false;
    }

    protected boolean isAllowSetterExecution(VariableDefinition data, RequestController request, DataTable value) throws ContextException {
        return true;
    }

    private VariableDefinition getAndCheckVariableDefinition(String name) throws ContextException {
        this.setupVariables();
        VariableDefinition def = this.getVariableDefinition(name);
        if (def == null) {
            throw new ContextException(MessageFormat.format(Cres.get().getString("conVarNotAvailExt"), name, this.getPath()));
        }
        return def;
    }

    @Override
    public boolean setVariableField(String variable, String field, Object value, CallerController cc) throws ContextException {
        return this.setVariableField(variable, field, 0, value, cc);
    }

    @Override
    public boolean setVariableField(String variable, String field, int record, Object value, CallerController cc, RequestController request) throws ContextException {
        DataTable tab = this.getVariableClone(variable, cc);
        tab.setTimestamp(new Date());
        Object old = tab.getRecord(record).getValue(field);
        tab.getRecord(record).setValue(field, value);
        this.setVariable(variable, cc, request, tab);
        return old == null ? value != null : !old.equals(value);
    }

    @Override
    public void setVariableField(String variable, String field, Object value, String compareField, Object compareValue, CallerController cc) throws ContextException {
        DataTable tab = this.getVariableClone(variable, cc);
        DataRecord rec = tab.select(compareField, compareValue);
        if (rec == null) {
            throw new ContextException("Record with " + compareField + "=" + compareValue + " not found");
        }
        rec.setValue(field, value);
        tab.setTimestamp(new Date());
        this.setVariable(variable, cc, tab);
    }

    public void addVariableRecord(String variable, CallerController cc, DataRecord record) throws ContextException {
        DataTable tab = this.getVariableClone(variable, cc);
        tab.addRecord(record);
        this.setVariable(variable, cc, tab);
    }

    public void addVariableRecord(String variable, CallerController cc, Object ... recordData) throws ContextException {
        DataTable tab = this.getVariableClone(variable, cc);
        DataRecord rec = tab.addRecord();
        for (int i = 0; i < recordData.length; ++i) {
            rec.addValue(recordData[i]);
        }
        this.setVariable(variable, cc, tab);
    }

    public void removeVariableRecords(String variable, CallerController cc, String field, Object value) throws ContextException {
        DataTable tab = this.getVariableClone(variable, cc);
        Iterator<DataRecord> i = tab.iterator();
        while (i.hasNext()) {
            DataRecord rec = i.next();
            if (!Util.equals(rec.getValue(field), value)) continue;
            i.remove();
        }
        this.setVariable(variable, cc, tab);
    }

    protected DataTable callFunction(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        long startTime = System.currentTimeMillis();
        this.setupFunctions();
        FunctionData data = this.getFunctionData(def.getName());
        if (!def.isConcurrent()) {
            this.lock(request, data.getExecutionLock());
        }
        boolean hasSpan = this.beginSpan(request, def);
        try {
            long endTime;
            long duration;
            String msg;
            DataTable result;
            String msg2;
            this.checkPermissions(def.getPermissions() != null ? def.getPermissions() : this.getPermissions(), caller, def);
            Log.CONTEXT_FUNCTIONS.debug((Object)("Trying to call function '" + def.getName() + "' of context '" + this.getPath() + "'"));
            if (def.getPermissions() != null) {
                this.checkPermissions(def.getPermissions(), caller, def);
            }
            if (hasSpan) {
                this.traceOperation(ContextOperationType.CALL_FUNCTION);
            }
            TableFormat requiredInputFormat = def.getInputFormat();
            TableFormat requiredOutputFormat = def.getOutputFormat();
            parameters.validate(this, this.getContextManager(), caller);
            if (this.valueCheckingEnabled && requiredInputFormat != null && (caller == null || !caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_NO_VALIDATION)) && (msg2 = parameters.conformMessage(requiredInputFormat)) != null) {
                Log.CONTEXT_FUNCTIONS.debug((Object)("Invalid input format of function '" + def.getName() + "': " + msg2));
                SimpleDataTable newParameters = new SimpleDataTable(def.getInputFormat(), true);
                DataTableReplication.copy(parameters, newParameters, true, true, true, true, true);
                parameters = newParameters;
                msg2 = parameters.conformMessage(requiredInputFormat);
                if (msg2 != null) {
                    throw new ContextException("Invalid format: " + msg2);
                }
            }
            if ((result = this.executeImplementation(data, caller, request, parameters)).isInvalid()) {
                throw new ContextException(result.getInvalidationMessage());
            }
            if (result.getRecordCount() != null && result.getRecordCount() == 0 && result.getFormat().getFieldCount() == 0) {
                result = result.cloneIfImmutable().setFormat(def.getOutputFormat());
            }
            if (this.valueCheckingEnabled && requiredOutputFormat != null && (caller == null || !caller.getProperties().containsKey(CALLER_CONTROLLER_PROPERTY_NO_VALIDATION)) && (msg = result.conformMessage(requiredOutputFormat)) != null) {
                Log.CONTEXT_FUNCTIONS.debug((Object)("Invalid output format of function '" + def.getName() + "': " + msg));
                SimpleDataTable newResult = new SimpleDataTable(def.getOutputFormat(), true);
                DataTableReplication.copy(result, newResult, true, true, true, true, true);
                result = newResult;
                msg = result.conformMessage(requiredOutputFormat);
                if (msg != null) {
                    throw new ContextException("Function '" + def.getName() + "' of context '" + this.getPath() + "' returned value of invalid format: " + msg);
                }
            }
            if ((duration = (endTime = System.currentTimeMillis()) - startTime) > 20000L) {
                Level level = duration > 120000L ? Level.INFO : Level.DEBUG;
                Log.PERFORMANCE.log((Priority)level, (Object)("Function '" + def + "' in context '" + this.getPath() + "' was executing for " + duration + " milliseconds"));
            }
            this.logAsyncSessionExecutionAction(caller, request, ContextOperationType.CALL_FUNCTION, def.getName(), parameters, result, duration);
            DataTable dataTable = result;
            return dataTable;
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(MessageFormat.format(Cres.get().getString("conErrCallingFunc"), def.toString(), this.toString()) + ex.getMessage(), ex);
        }
        finally {
            if (!def.isConcurrent()) {
                data.getExecutionLock().unlock();
            }
            data.registerExecution();
            if (hasSpan) {
                this.endSpan();
            }
        }
    }

    private DataTable executeImplementation(FunctionData data, CallerController caller, RequestController request, DataTable parameters) throws IllegalAccessException, ContextException {
        DataTable result = this.executeImplementationMethod(data, caller, request, parameters);
        if (result != null) {
            return result;
        }
        FunctionDefinition def = data.getDefinition();
        if (def.getImplementation() != null) {
            result = def.getImplementation().execute(this, def, caller, request, parameters);
            if (result != null) {
                return result;
            }
            return this.getDefaultFunctionOutput(def);
        }
        result = this.callFunctionImpl(def, caller, request, parameters);
        if (result != null) {
            return result;
        }
        throw new ContextException(MessageFormat.format(Cres.get().getString("conFuncNotImpl"), def.getName(), this.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTable executeImplementationMethod(FunctionData data, CallerController caller, RequestController request, DataTable parameters) throws IllegalArgumentException, IllegalAccessException, ContextException {
        Method implementation;
        if (this.isProxy()) {
            return null;
        }
        FunctionDefinition def = data.getDefinition();
        if (!data.isImplementationCached()) {
            Class[] callerParams = new Class[]{FunctionDefinition.class, CallerController.class, RequestController.class, DataTable.class};
            try {
                String methodName = IMPLEMENTATION_METHOD_PREFIX + def.getName();
                if (Arrays.stream(this.getClass().getMethods()).noneMatch(m -> m.getName().equals(methodName) && Arrays.equals(m.getParameterTypes(), callerParams))) {
                    DataTable dataTable = null;
                    return dataTable;
                }
                Method implementation2 = this.getClass().getMethod(methodName, callerParams);
                data.setImplementationMethod(implementation2);
            }
            catch (NoSuchMethodException ex) {
                DataTable implementation2 = null;
                return implementation2;
            }
            finally {
                data.setImplementationCached(true);
            }
        }
        if ((implementation = data.getImplementationMethod()) != null) {
            try {
                DataTable result = (DataTable)implementation.invoke((Object)this, def, caller, request, parameters);
                if (result != null) {
                    return result;
                }
                return this.getDefaultFunctionOutput(def);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                throw new ContextException(cause.getMessage(), cause);
            }
        }
        return null;
    }

    private DataTable getDefaultFunctionOutput(FunctionDefinition def) {
        TableFormat format = def.getOutputFormat();
        return format != null ? new SimpleDataTable(format, true) : new SimpleDataTable();
    }

    protected void setupFunctions() throws ContextException {
    }

    @Override
    public DataTable callFunction(String name, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        FunctionDefinition def = this.getAndCheckFunctionDefinition(name);
        return this.callFunction(def, caller, request, parameters);
    }

    @Override
    public DataTable callFunction(String name, CallerController caller, DataTable parameters) throws ContextException {
        return this.callFunction(name, caller, null, parameters);
    }

    @Override
    public DataTable callFunction(String name, DataTable parameters) throws ContextException {
        return this.callFunction(this.getAndCheckFunctionDefinition(name), null, null, parameters);
    }

    @Override
    public DataTable callFunction(String name) throws ContextException {
        FunctionDefinition def = this.getAndCheckFunctionDefinition(name);
        return this.callFunction(def, null, null, (DataTable)new SimpleDataTable(def.getInputFormat(), true));
    }

    @Override
    public DataTable callFunction(String name, CallerController caller) throws ContextException {
        FunctionDefinition def = this.getAndCheckFunctionDefinition(name);
        return this.callFunction(def, caller, null, (DataTable)new SimpleDataTable(def.getInputFormat(), true));
    }

    @Override
    public DataTable callFunction(String name, CallerController caller, Object ... parameters) throws ContextException {
        FunctionDefinition def = this.getAndCheckFunctionDefinition(name);
        return this.callFunction(name, caller, new SimpleDataTable(def.getInputFormat(), parameters));
    }

    @Override
    public DataTable callFunction(String name, Object ... parameters) throws ContextException {
        return this.callFunction(name, null, parameters);
    }

    protected DataTable callFunctionImpl(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        return null;
    }

    private FunctionDefinition getAndCheckFunctionDefinition(String name) throws ContextException {
        this.setupFunctions();
        FunctionDefinition def = this.getFunctionDefinition(name);
        if (def == null) {
            throw new ContextException(MessageFormat.format(Cres.get().getString("conFuncNotAvailExt"), name, this.getPath()));
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVariableDefinition(VariableDefinition def) {
        this.variableDataLock.writeLock().lock();
        try {
            String normalizedVariableName = def.getName().toLowerCase(Locale.ENGLISH);
            if (this.getVariableDefinition(def.getName()) != null) {
                VariableData variableData = this.variableData.get(normalizedVariableName);
                variableData.setDefinition(def);
                if (variableData.getValue() instanceof DataTable) {
                    DataTable oldValue = (DataTable)variableData.getValue();
                    SimpleDataTable resultingValue = new SimpleDataTable(def.getFormat());
                    DataTableReplication.copy(oldValue, resultingValue, true, true, true, true, true);
                    variableData.setValue(resultingValue);
                }
            } else {
                this.variableData.put(normalizedVariableName, new VariableData(def));
            }
        }
        finally {
            this.variableDataLock.writeLock().unlock();
        }
        if (this.setupComplete && this.fireUpdateEvents && !def.isHidden()) {
            this.fireVariableAdded(def);
        }
        if (this.getContextManager() != null) {
            this.getContextManager().variableAdded(this, def);
        }
    }

    protected void fireVariableAdded(VariableDefinition def) {
        EventDefinition ed = this.getEventDefinition(E_VARIABLE_ADDED);
        if (ed != null) {
            this.fireEvent(ed.getName(), new SimpleDataTable(this.varDefToDataRecord(def, null)));
        }
    }

    @Override
    public void removeVariableDefinition(String name) {
        this.removeVariableDefinition(this.getVariableDefinition(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VariableDefinition> updateVariableDefinitions(Map<String, VariableDefinition> source, String baseGroup, boolean skipRemoval, boolean removeValues, Object owner) {
        HashMap<String, VariableDefinition> definitions = new HashMap<String, VariableDefinition>(source);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.variableDataLock.readLock().lock();
        try {
            Iterator iter = definitions.values().iterator();
            while (iter.hasNext()) {
                VariableDefinition updated = (VariableDefinition)iter.next();
                VariableDefinition existing = this.getVariableDefinition(updated.getName());
                if (existing == null || owner == null || owner == existing.getOwner()) continue;
                this.onIllegalDefinitionUpdated(updated.getName());
                iter.remove();
            }
        }
        finally {
            this.variableDataLock.readLock().unlock();
        }
        if (!skipRemoval) {
            this.variableDataLock.writeLock().lock();
            try {
                for (VariableDefinition vd : this.getVariableDefinitions(this.getContextManager().getCallerController(), baseGroup)) {
                    if (definitions.containsKey(vd.getName()) || owner != null && owner != vd.getOwner()) continue;
                    if (removeValues) {
                        this.removeValues(vd);
                    }
                    this.removeVariableDefinition(vd.getName());
                }
            }
            finally {
                this.variableDataLock.writeLock().unlock();
            }
        }
        this.variableDataLock.writeLock().lock();
        try {
            for (VariableDefinition vd : definitions.values()) {
                VariableDefinition variableDefinition = this.getVariableDefinition(vd.getName());
                if (variableDefinition != null && (variableDefinition.equals(vd) || owner != vd.getOwner())) continue;
                this.addVariableDefinition(vd);
                builder.add((Object)vd);
            }
        }
        finally {
            this.variableDataLock.writeLock().unlock();
        }
        return builder.build();
    }

    protected void removeValues(VariableDefinition vd) {
        throw new AggreGateRuntimeException("Cannot remove variable values since context is not a server context: " + this);
    }

    protected void onIllegalDefinitionUpdated(String definitionName) {
        Log.CONTEXT.warn((Object)("Illegal entity definition: " + definitionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeVariableDefinition(VariableDefinition def) {
        VariableData data;
        if (def == null) {
            return;
        }
        this.variableDataLock.writeLock().lock();
        try {
            data = this.variableData.remove(def.getName().toLowerCase(Locale.ENGLISH));
            if (data == null) {
                return;
            }
        }
        finally {
            this.variableDataLock.writeLock().unlock();
        }
        data.getReadWriteLock().writeLock().lock();
        try {
            EventDefinition ed;
            this.variableStatusesLock.writeLock().lock();
            try {
                if (this.variableStatuses != null) {
                    this.variableStatuses.remove(def.getName());
                    this.variableStatusesTable = null;
                }
            }
            finally {
                this.variableStatusesLock.writeLock().unlock();
            }
            if (this.setupComplete && this.fireUpdateEvents && !def.isHidden() && (ed = this.getEventDefinition(E_VARIABLE_REMOVED)) != null) {
                this.fireEvent(ed.getName(), def.getName());
            }
            if (this.getContextManager() != null) {
                this.getContextManager().variableRemoved(this, def);
            }
        }
        finally {
            data.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void addFunctionDefinition(FunctionDefinition def) {
        this.functionDataLock.writeLock().lock();
        try {
            String normalizedFunctionName = def.getName().toLowerCase(Locale.ENGLISH);
            if (this.getFunctionDefinition(def.getName()) != null) {
                this.functionData.get(normalizedFunctionName).setDefinition(def);
            } else {
                this.functionData.put(normalizedFunctionName, new FunctionData(def));
            }
            if (this.setupComplete && this.fireUpdateEvents && !def.isHidden()) {
                this.fireFunctionAdded(def);
            }
            if (this.getContextManager() != null) {
                this.getContextManager().functionAdded(this, def);
            }
        }
        finally {
            this.functionDataLock.writeLock().unlock();
        }
    }

    protected void fireFunctionAdded(FunctionDefinition def) {
        EventDefinition ed = this.getEventDefinition(E_FUNCTION_ADDED);
        if (ed != null) {
            this.fireEvent(ed.getName(), new SimpleDataTable(this.funcDefToDataRecord(def, null)));
        }
    }

    @Override
    public void removeFunctionDefinition(String name) {
        this.removeFunctionDefinition(this.getFunctionDefinition(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFunctionDefinition(FunctionDefinition def) {
        FunctionData data;
        if (def == null) {
            return;
        }
        this.functionDataLock.writeLock().lock();
        try {
            data = this.functionData.remove(def.getName().toLowerCase(Locale.ENGLISH));
        }
        finally {
            this.functionDataLock.writeLock().unlock();
        }
        data.getExecutionLock().lock();
        try {
            EventDefinition ed;
            if (this.setupComplete && this.fireUpdateEvents && !def.isHidden() && (ed = this.getEventDefinition(E_FUNCTION_REMOVED)) != null) {
                this.fireEvent(ed.getName(), def.getName());
            }
            if (this.getContextManager() != null) {
                this.getContextManager().functionRemoved(this, def);
            }
        }
        finally {
            data.getExecutionLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionDefinition> updateFunctionDefinitions(Map<String, Pair<FunctionDefinition, Boolean>> source, String baseGroup, boolean skipRemoval, Object owner) {
        HashMap<String, Pair<FunctionDefinition, Boolean>> definitions = new HashMap<String, Pair<FunctionDefinition, Boolean>>(source);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.functionDataLock.writeLock().lock();
        try {
            for (FunctionDefinition existing : this.getFunctionDefinitions(this.getContextManager().getCallerController(), baseGroup)) {
                boolean found = false;
                Pair updatedPair = (Pair)definitions.get(existing.getName());
                if (updatedPair != null) {
                    FunctionDefinition updated = (FunctionDefinition)updatedPair.getFirst();
                    if (owner != null && owner != existing.getOwner()) {
                        this.onIllegalDefinitionUpdated(updated.getName());
                        definitions.remove(existing.getName());
                        continue;
                    }
                    found = true;
                }
                if (found || skipRemoval || owner != null && owner != existing.getOwner()) continue;
                this.removeFunctionDefinition(existing.getName());
                ActionDefinition ad = this.getActionDefinition(existing.getName());
                if (ad == null) continue;
                this.removeActionDefinition(existing.getName());
            }
            for (Pair entry : definitions.values()) {
                if (!this.updateFunctionAndAction((FunctionDefinition)entry.getFirst(), (Boolean)entry.getSecond(), owner)) continue;
                builder.add(entry.getFirst());
            }
            Iterator<FunctionDefinition> iterator = builder.build();
            return iterator;
        }
        finally {
            this.functionDataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventDefinition(EventDefinition def) {
        this.eventDataLock.writeLock().lock();
        try {
            String normalizedEventName = def.getName().toLowerCase(Locale.ENGLISH);
            EventDefinition existentDefinition = this.getEventDefinition(def.getName());
            if (existentDefinition != null) {
                this.eventData.get(normalizedEventName).setDefinition(def);
            } else {
                this.eventData.put(normalizedEventName, new EventData(def, this));
            }
        }
        finally {
            this.eventDataLock.writeLock().unlock();
        }
        if (this.setupComplete && this.fireUpdateEvents && !def.isHidden()) {
            this.fireEventAdded(def);
        }
        if (this.getContextManager() != null) {
            this.getContextManager().eventAdded(this, def);
        }
    }

    protected boolean updateFunctionAndAction(FunctionDefinition fd, boolean processAction, Object owner) {
        FunctionDefinition existing = this.getFunctionDefinition(fd.getName());
        if (existing != null && (Util.equals(fd, existing) || !Objects.equals(existing.getOwner(), owner))) {
            return false;
        }
        this.addFunctionDefinition(fd);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EventDefinition> updateEventDefinitions(Map<String, EventDefinition> source, String baseGroup, boolean skipRemoval, Object owner) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashMap<String, EventDefinition> definitions = new HashMap<String, EventDefinition>(source);
        this.eventDataLock.writeLock().lock();
        try {
            for (EventDefinition existing : this.getEventDefinitions(this.getContextManager().getCallerController(), baseGroup)) {
                boolean found = false;
                EventDefinition updated = (EventDefinition)definitions.get(existing.getName());
                if (updated != null) {
                    if (owner != null && owner != existing.getOwner()) {
                        this.onIllegalDefinitionUpdated(updated.getName());
                        definitions.remove(existing.getName());
                        continue;
                    }
                    found = true;
                }
                if (found || skipRemoval || owner != null && owner != existing.getOwner()) continue;
                this.removeEventDefinition(existing.getName());
            }
            for (EventDefinition ed : definitions.values()) {
                if (!this.updateContextEvent(ed, owner)) continue;
                builder.add((Object)ed);
            }
            Iterator<EventDefinition> iterator = builder.build();
            return iterator;
        }
        finally {
            this.eventDataLock.writeLock().unlock();
        }
    }

    private boolean updateContextEvent(EventDefinition ed, Object owner) {
        EventDefinition existing = this.getEventDefinition(ed.getName());
        if (existing != null && (Util.equals(ed, existing) || !Objects.equals(owner, existing.getOwner()))) {
            return false;
        }
        this.addEventDefinition(ed);
        return true;
    }

    protected void fireEventAdded(EventDefinition def) {
        EventDefinition ed = this.getEventDefinition(E_EVENT_ADDED);
        if (ed != null) {
            this.fireEvent(ed.getName(), new SimpleDataTable(this.evtDefToDataRecord(def, null)));
        }
    }

    @Override
    public void removeEventDefinition(String name) {
        this.removeEventDefinition(this.getEventDefinition(name));
    }

    private void removeEventDefinition(EventDefinition def) {
        if (def == null) {
            return;
        }
        this.eventDataLock.writeLock().lock();
        try {
            if (this.eventData.remove(def.getName().toLowerCase(Locale.ENGLISH)) != null) {
                EventDefinition ed;
                if (this.setupComplete && this.fireUpdateEvents && !def.isHidden() && (ed = this.getEventDefinition(E_EVENT_REMOVED)) != null) {
                    this.fireEvent(ed.getName(), def.getName());
                }
                if (this.getContextManager() != null) {
                    this.getContextManager().eventRemoved(this, def);
                }
            }
        }
        finally {
            this.eventDataLock.writeLock().unlock();
        }
    }

    @Override
    public VariableData getVariableData(String name) {
        this.variableDataLock.readLock().lock();
        try {
            VariableData variableData = this.getData(this.variableData, this.variableNameByAlias, name);
            return variableData;
        }
        finally {
            this.variableDataLock.readLock().unlock();
        }
    }

    @Override
    public void addAlias(int entityType, String aliasName, String name) {
        String normalizedName = aliasName.toLowerCase(Locale.ENGLISH);
        switch (entityType) {
            case 1: {
                this.variableNameByAlias.put(normalizedName, name);
                break;
            }
            case 2: {
                this.functionNameByAlias.put(normalizedName, name);
                break;
            }
            case 4: {
                this.eventNameByAlias.put(normalizedName, name);
                break;
            }
            case 8: {
                this.actionNameByAlias.put(normalizedName, name);
            }
        }
    }

    @Override
    public VariableDefinition getVariableDefinition(String name) {
        VariableData data = this.getVariableData(name);
        return data != null ? data.getDefinition() : null;
    }

    @Override
    public VariableDefinition getVariableDefinition(String name, CallerController caller) {
        VariableDefinition def = this.getVariableDefinition(name);
        if (def == null) {
            return null;
        }
        Permissions readPermissions = def.getReadPermissions() != null ? def.getReadPermissions() : this.getPermissions();
        Permissions writePermissions = def.getWritePermissions() != null ? def.getWritePermissions() : this.getPermissions();
        writePermissions = new Permissions(writePermissions.getPermissions(), true);
        boolean readAccessGranted = this.checkPermissions(readPermissions, caller, this, def);
        boolean writeAccessGranted = this.checkPermissions(writePermissions, caller, this, def);
        return readAccessGranted || writeAccessGranted ? def : null;
    }

    @Override
    public FunctionData getFunctionData(String name) {
        this.functionDataLock.readLock().lock();
        try {
            FunctionData functionData = this.getData(this.functionData, this.functionNameByAlias, name);
            return functionData;
        }
        finally {
            this.functionDataLock.readLock().unlock();
        }
    }

    @Override
    public FunctionDefinition getFunctionDefinition(String name) {
        FunctionData data = this.getFunctionData(name);
        return data != null ? data.getDefinition() : null;
    }

    @Override
    public FunctionDefinition getFunctionDefinition(String name, CallerController caller) {
        FunctionDefinition def = this.getFunctionDefinition(name);
        if (def == null) {
            return null;
        }
        Permissions permissions = def.getPermissions() != null ? def.getPermissions() : this.getPermissions();
        boolean accessGranted = this.checkPermissions(permissions, caller, this, def);
        return accessGranted ? def : null;
    }

    @Override
    public EventData getEventData(String name) {
        this.eventDataLock.readLock().lock();
        try {
            EventData eventData = this.getData(this.eventData, this.eventNameByAlias, name);
            return eventData;
        }
        finally {
            this.eventDataLock.readLock().unlock();
        }
    }

    @Override
    public EventDefinition getEventDefinition(String name) {
        EventData ed = this.getEventData(name);
        return ed != null ? ed.getDefinition() : null;
    }

    private <T> T getData(Map<String, T> dataByName, Map<String, String> aliasMap, String name) {
        if (dataByName.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return dataByName.get(name.toLowerCase(Locale.ENGLISH));
        }
        String alias = aliasMap.get(name.toLowerCase(Locale.ENGLISH));
        return alias != null ? (T)dataByName.get(alias.toLowerCase(Locale.ENGLISH)) : null;
    }

    private ActionDefinition getActionDefinition(List<ActionDefinition> dataByName, Map<String, String> aliasMap, String name) {
        String actionName = aliasMap.getOrDefault(name.toLowerCase(Locale.ENGLISH), name);
        for (ActionDefinition entity : dataByName) {
            if (!entity.getName().equalsIgnoreCase(actionName)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public EventDefinition getEventDefinition(String name, CallerController caller) {
        EventDefinition def = this.getEventDefinition(name);
        if (def == null) {
            return null;
        }
        Permissions permissions = def.getPermissions() != null ? def.getPermissions() : this.getPermissions();
        boolean accessGranted = this.checkPermissions(permissions, caller, this, def);
        return accessGranted ? def : null;
    }

    private EventDefinition getAndCheckEventDefinition(String name) {
        this.setupEvents();
        EventDefinition def = this.getEventDefinition(name);
        if (def == null) {
            throw new ContextRuntimeException(MessageFormat.format(Cres.get().getString("conEvtNotAvailExt"), name, this.getPath()));
        }
        return def;
    }

    protected void setupEvents() {
    }

    protected void postEvent(Event ev, EventDefinition ed, CallerController caller, FireEventRequestController request) throws ContextException {
    }

    protected void updateEvent(Event ev, EventDefinition ed, CallerController caller, FireEventRequestController request) throws ContextException {
    }

    protected Event fireEvent(EventDefinition ed, DataTable data, int level, Long id, Date creationtime, Integer listener, CallerController caller, FireEventRequestController request, Permissions permissions) {
        if (id == null) {
            id = EventUtils.generateEventId();
        }
        Event event = new Event(this.getPath(), ed, level == -1 ? ed.getLevel() : level, data, id, creationtime, permissions);
        if (request != null && request.getServerId() != null) {
            event.setServerID(request.getServerId());
        }
        return this.fireEvent(ed, event, listener, caller, request);
    }

    protected Event fireEvent(Event event) {
        return this.fireEvent(this.getAndCheckEventDefinition(event.getName()), event, null, null, null);
    }

    @Override
    public Event fireEvent(String name, FireEventRequestController request, Object ... data) {
        EventDefinition ed = this.getAndCheckEventDefinition(name);
        return this.fireEvent(ed, new SimpleDataTable(ed.getFormat(), data), -1, null, null, null, null, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event fireEvent(EventDefinition ed, Event event, Integer listener, CallerController caller, FireEventRequestController request) {
        Event duplicate;
        EventData edata;
        EventProcessingRule rule;
        block39: {
            Event processed;
            String msg;
            Expression deduplicator;
            Expression prefilter;
            Logger logger = Log.CONTEXT_EVENTS;
            if (caller != null) {
                try {
                    this.checkPermissions(ed.getFirePermissions() != null ? ed.getFirePermissions() : this.getPermissions(), caller, ed);
                }
                catch (ContextSecurityException ex) {
                    throw new ContextRuntimeException(ex);
                }
            }
            Expression expression = prefilter = (rule = this.getEventProcessingRule(event)) != null ? rule.getPrefilterExpression() : null;
            if (prefilter != null) {
                try {
                    Evaluator evaluator = new Evaluator(this.getContextManager(), this, event.getData(), this.getEventProcessingCallerController());
                    if (!evaluator.evaluateToBoolean(prefilter).booleanValue()) {
                        rule.addFiltered();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Event '" + ed + "' in context '" + this.getPath() + "' was suppressed by pre-filter"));
                        }
                        return null;
                    }
                }
                catch (Exception ex) {
                    logger.info((Object)("Error processing pre-filter expression for event '" + ed + "' in context '" + this.getPath() + "': " + ex.getMessage()), (Throwable)ex);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event fired: " + event));
            }
            event.setListener(listener);
            event.setSessionID(caller != null ? caller.getSessionIdCounter() : null);
            event.setUserSessionId(caller != null ? caller.getSessionId() : null);
            if (request != null) {
                event.setOriginator(request.getOriginator().getOriginatorObject());
            }
            if ((edata = this.getEventData(ed.getName())) == null) {
                return null;
            }
            edata.registerFiredEvent();
            Expression expression2 = deduplicator = rule != null ? rule.getDeduplicatorExpression() : null;
            if (deduplicator != null) {
                try {
                    Evaluator evaluator = new Evaluator(this.getContextManager(), this, event.getData(), this.getEventProcessingCallerController());
                    String deduplicationId = evaluator.evaluateToString(deduplicator);
                    event.setDeduplicationId(deduplicationId);
                }
                catch (Exception ex) {
                    logger.info((Object)("Error processing deduplicator expression for event '" + ed + "' in context '" + this.getPath() + "': " + ex.getMessage()), (Throwable)ex);
                }
            }
            if (event.getData().isInvalid()) {
                throw new ContextRuntimeException(event.getData().getInvalidationMessage());
            }
            if (ed.getFormat() != null && (msg = event.getData().conformMessage(ed.getFormat())) != null) {
                logger.debug((Object)("Wrong format data for event '" + ed + "' in context '" + this + "': " + msg));
                SimpleDataTable newData = new SimpleDataTable(ed.getFormat(), true);
                DataTableReplication.copy(event.getData(), newData);
                event.setData(newData);
            }
            this.processBindings(event);
            this.processEnrichments(event, rule, caller);
            Long customExpirationPeriod = null;
            if (request != null && request.getCustomExpirationPeriod() != null) {
                customExpirationPeriod = request.getCustomExpirationPeriod();
            }
            if (customExpirationPeriod != null) {
                if (customExpirationPeriod > 0L) {
                    event.setExpirationtime(new Date(System.currentTimeMillis() + customExpirationPeriod));
                }
            } else {
                Long userDefinedExpirationPeriod;
                Long l = userDefinedExpirationPeriod = rule != null ? Long.valueOf(rule.getPeriod()) : null;
                if (userDefinedExpirationPeriod != null && userDefinedExpirationPeriod > 0L) {
                    event.setExpirationtime(new Date(System.currentTimeMillis() + userDefinedExpirationPeriod));
                }
            }
            Integer customMemoryStorageSize = rule != null ? (rule.getDeduplicator() != null && rule.getDeduplicator().length() > 0 ? Integer.valueOf(rule.getQueue()) : null) : null;
            Event event2 = processed = request != null ? request.process(event) : event;
            if (processed == null) {
                return null;
            }
            edata.getDuplicateProcessingLock().readLock().lock();
            try {
                duplicate = edata.store(processed, customMemoryStorageSize);
                if (duplicate == null) {
                    this.postEvent(event, ed, caller, request);
                    if (rule != null) {
                        rule.addSaved();
                    }
                    break block39;
                }
                edata.getDuplicateProcessingLock().readLock().unlock();
                edata.getDuplicateProcessingLock().writeLock().lock();
                try {
                    this.updateEvent(duplicate, ed, caller, request);
                    if (rule != null) {
                        rule.addDuplicate();
                    }
                }
                finally {
                    edata.getDuplicateProcessingLock().writeLock().unlock();
                    edata.getDuplicateProcessingLock().readLock().lock();
                }
            }
            catch (ContextException ex) {
                throw new ContextRuntimeException(ex);
            }
            finally {
                edata.getDuplicateProcessingLock().readLock().unlock();
            }
        }
        boolean hasSpan = this.beginSpan(request, ed);
        try {
            if (this.contextManager != null && (duplicate == null || rule == null || rule.isDuplicateDispatching())) {
                if (hasSpan) {
                    this.traceOperation(ContextOperationType.FIRE_EVENT);
                }
                this.contextManager.queue(edata, event, request);
            }
        }
        finally {
            if (hasSpan) {
                this.endSpan();
            }
        }
        return duplicate != null ? duplicate : event;
    }

    public Event fireEvent(String name, int level, CallerController caller, FireEventRequestController request, Permissions permissions, DataTable data) {
        EventDefinition ed = this.getAndCheckEventDefinition(name);
        return this.fireEvent(ed, data, level, null, null, null, caller, request, permissions);
    }

    @Override
    public Event fireEvent(String name, DataTable data, int level, Long id, Date creationtime, Integer listener, CallerController caller, FireEventRequestController request) {
        return this.fireEvent(this.getAndCheckEventDefinition(name), data, level, id, creationtime, listener, caller, request, null);
    }

    @Override
    public Event fireEvent(String name, DataTable data) {
        return this.fireEvent(this.getAndCheckEventDefinition(name), data, -1, null, null, null, null, null, null);
    }

    @Override
    public Event fireEvent(String name, CallerController caller, DataTable data) {
        return this.fireEvent(this.getAndCheckEventDefinition(name), data, -1, null, null, null, caller, null, null);
    }

    @Override
    public Event fireEvent(String name, int level, DataTable data) {
        return this.fireEvent(this.getAndCheckEventDefinition(name), data, level, null, null, null, null, null, null);
    }

    @Override
    public Event fireEvent(String name, int level, CallerController caller, DataTable data) {
        return this.fireEvent(this.getAndCheckEventDefinition(name), data, level, null, null, null, caller, null, null);
    }

    @Override
    public Event fireEvent(String name, int level, CallerController caller, FireEventRequestController request, DataTable data) {
        return this.fireEvent(this.getAndCheckEventDefinition(name), data, level, null, null, null, caller, request, null);
    }

    @Override
    public Event fireEvent(String name) {
        EventDefinition ed = this.getAndCheckEventDefinition(name);
        return this.fireEvent(ed, new SimpleDataTable(ed.getFormat(), true), -1, null, null, null, null, null, null);
    }

    @Override
    public Event fireEvent(String name, CallerController caller) {
        EventDefinition ed = this.getAndCheckEventDefinition(name);
        return this.fireEvent(ed, new SimpleDataTable(ed.getFormat(), true), -1, null, null, null, caller, null, null);
    }

    @Override
    public Event fireEvent(String name, Object ... data) {
        EventDefinition ed = this.getAndCheckEventDefinition(name);
        return this.fireEvent(ed, new SimpleDataTable(ed.getFormat(), data), -1, null, null, null, null, null, null);
    }

    protected EventProcessingRule getEventProcessingRule(Event event) {
        return null;
    }

    protected void processBindings(Event event) {
    }

    private void processEnrichments(Event event, EventProcessingRule rule, CallerController caller) {
        if (rule == null || rule.getEnrichments() == null) {
            return;
        }
        Evaluator evaluator = new Evaluator(this.getContextManager(), this, event.getData(), this.getEventProcessingCallerController());
        for (EventEnrichmentRule enrichmentRule : rule.getEnrichments()) {
            String name = enrichmentRule.getName();
            try {
                String result = evaluator.evaluateToString(enrichmentRule.getEnrichmentExpression());
                if (result == null) continue;
                event.addEnrichment(new Enrichment(name, result.toString(), new Date(), caller != null ? caller.getUsername() : null));
            }
            catch (Exception ex) {
                Log.CONTEXT_EVENTS.error((Object)("Error adding enrichment '" + name + "' to event '" + event + "': " + ex));
            }
        }
    }

    protected CallerController getEventProcessingCallerController() {
        return this.getContextManager().getCallerController();
    }

    @Override
    public List<Event> getEventHistory(String name) {
        EventData ed = this.getEventData(name);
        if (ed == null) {
            throw new IllegalStateException(Cres.get().getString("conEvtNotAvail") + name);
        }
        return ed.getHistory();
    }

    private void lock(RequestController request, Lock lock) throws ContextException {
        block4: {
            Long lockTimeout;
            Long l = lockTimeout = request != null && request.getLockTimeout() != null ? request.getLockTimeout() : null;
            if (lockTimeout != null) {
                try {
                    if (!lock.tryLock(lockTimeout, TimeUnit.MILLISECONDS)) {
                        throw new ContextException(Cres.get().getString("conLockFailed"));
                    }
                    break block4;
                }
                catch (InterruptedException ex) {
                    throw new ContextException(Cres.get().getString("interrupted"));
                }
            }
            lock.lock();
        }
    }

    public String toString() {
        String desc = this.getDescription();
        return desc != null ? desc : this.getPath();
    }

    @Override
    public String toDetailedString() {
        String description = this.getDescription();
        return description != null ? description + " (" + this.getPath() + ")" : this.getPath();
    }

    @Override
    public void accept(ContextVisitor visitor) throws ContextException {
        if (visitor.shouldVisit(this)) {
            this.childrenLock.writeLock().lock();
            try {
                if (visitor.isConcurrent()) {
                    if (visitor.isCurrentThenChildrenOrder()) {
                        this.visitInParallel(visitor, this);
                        this.traverseChildren(visitor, this.childrenList);
                    } else {
                        this.traverseChildren(visitor, this.childrenList);
                        this.visitInParallel(visitor, this);
                    }
                } else if (visitor.isCurrentThenChildrenOrder()) {
                    visitor.visit(this);
                    this.traverseChildren(visitor, this.childrenList);
                } else {
                    this.traverseChildren(visitor, this.childrenList);
                    visitor.visit(this);
                }
            }
            finally {
                this.childrenLock.writeLock().unlock();
            }
        }
    }

    private void traverseChildren(ContextVisitor visitor, List<C> childrenList) throws ContextException {
        for (Context child : childrenList) {
            child.accept(visitor);
        }
    }

    private void visitInParallel(ContextVisitor visitor, Context currentContext) throws ContextException {
        ExecutorService executorService = this.getContextManager().getExecutorService();
        int taskPortionSize = 10;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)executorService;
            taskPortionSize = executor.getMaximumPoolSize() / 10;
            taskPortionSize = taskPortionSize == 0 ? 1 : taskPortionSize;
        }
        Callable<Object> task = () -> {
            visitor.visit(currentContext);
            return null;
        };
        boolean root = visitor.isStartContext();
        try {
            visitor.getTasks().add(task);
            if (visitor.getTasks().size() >= taskPortionSize || root) {
                executorService.invokeAll(visitor.getTasks());
                visitor.getTasks().clear();
            }
        }
        catch (InterruptedException ex) {
            throw new ContextException(ex.getMessage(), ex);
        }
    }

    protected EventDefinition getChangeEventDefinition() {
        return ED_CHANGE;
    }

    public DataTable getVvariables(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        SimpleDataTable ans = new SimpleDataTable(def.getFormat());
        for (VariableDefinition vardef : this.getVariableDefinitions(caller)) {
            ans.addRecord(this.varDefToDataRecord(vardef, caller));
        }
        return ans;
    }

    protected synchronized String encodeFormat(TableFormat format, CallerController caller) {
        return format != null ? format.encode(false) : null;
    }

    protected synchronized TableFormat decodeFormat(String source, CallerController caller) {
        return source != null ? new TableFormat(source, new ClassicEncodingSettings(false)) : null;
    }

    protected Optional<FormatCache> obtainFormatCache() {
        return this.contextManager != null ? this.contextManager.getFormatCache() : Optional.empty();
    }

    public DataRecord varDefToDataRecord(VariableDefinition vd) {
        return this.varDefToDataRecord(vd, null);
    }

    protected DataRecord varDefToDataRecord(VariableDefinition vd, CallerController caller) {
        DataRecord rec = new DataRecord(VARIABLE_DEFINITION_FORMAT);
        rec.setValue("name", (Object)vd.getName());
        rec.setValue("format", (Object)this.encodeFormat(vd.getFormat(), caller));
        rec.setValue("description", (Object)vd.getDescription());
        rec.setValue(FIELD_VD_READABLE, (Object)vd.isReadable());
        rec.setValue(FIELD_VD_WRITABLE, (Object)vd.isWritable());
        rec.setValue("help", (Object)vd.getHelp());
        rec.setValue("group", (Object)vd.getGroup());
        rec.setValue("iconId", (Object)vd.getIconId());
        rec.setValue(FIELD_VD_HELP_ID, (Object)vd.getHelpId());
        rec.setValue(FIELD_VD_CACHE_TIME, (Object)vd.getRemoteCacheTime());
        rec.setValue(FIELD_VD_ADD_PREVIOUS_VALUE_TO_VARIABLE_UPDATE_EVENT, (Object)vd.isAddPreviousValueToVariableUpdateEvent());
        if (vd.getReadPermissions() != null) {
            rec.setValue(FIELD_VD_READ_PERMISSIONS, (Object)vd.getReadPermissions().encode());
        }
        if (vd.getWritePermissions() != null) {
            rec.setValue(FIELD_VD_WRITE_PERMISSIONS, (Object)vd.getWritePermissions().encode());
        }
        rec.setValue(FIELD_VD_DEFAULT_VALUE, (Object)vd.getDefaultValue());
        return rec;
    }

    public VariableDefinition varDefFromDataRecord(DataRecord rec) {
        return this.varDefFromDataRecord(rec, null);
    }

    private VariableDefinition varDefFromDataRecord(DataRecord rec, CallerController caller) {
        TableFormat format;
        String variable = rec.getString("name");
        boolean readable = rec.getBoolean(FIELD_VD_READABLE);
        boolean writable = rec.getBoolean(FIELD_VD_WRITABLE);
        try {
            format = this.decodeFormat(rec.getString("format"), caller);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error decoding format of variable '" + variable + "': " + ex.getMessage(), ex);
        }
        VariableDefinition def = new VariableDefinition(variable, format, readable, writable, rec.getString("description"), rec.getString("group"));
        def.setHelp(rec.getString("help"));
        def.setIconId(rec.getString("iconId"));
        if (rec.hasField(FIELD_VD_HELP_ID)) {
            def.setHelpId(rec.getString(FIELD_VD_HELP_ID));
        }
        if (rec.hasField(FIELD_VD_CACHE_TIME)) {
            def.setRemoteCacheTime(rec.getLong(FIELD_VD_CACHE_TIME));
        }
        if (rec.hasField(FIELD_VD_ADD_PREVIOUS_VALUE_TO_VARIABLE_UPDATE_EVENT)) {
            def.setAddPreviousValueToVariableUpdateEvent(rec.getBoolean(FIELD_VD_ADD_PREVIOUS_VALUE_TO_VARIABLE_UPDATE_EVENT));
        }
        if (rec.hasField(FIELD_VD_READ_PERMISSIONS)) {
            def.setReadPermissions(new Permissions(rec.getString(FIELD_VD_READ_PERMISSIONS)));
        }
        if (rec.hasField(FIELD_VD_WRITE_PERMISSIONS)) {
            def.setWritePermissions(new Permissions(rec.getString(FIELD_VD_WRITE_PERMISSIONS)));
        }
        return def;
    }

    public DataTable getVfunctions(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        SimpleDataTable ans = new SimpleDataTable(def.getFormat());
        for (FunctionDefinition funcdef : this.getFunctionDefinitions(caller)) {
            ans.addRecord(this.funcDefToDataRecord(funcdef, caller));
        }
        return ans;
    }

    public DataRecord funcDefToDataRecord(FunctionDefinition fd) {
        return this.funcDefToDataRecord(fd, null);
    }

    protected DataRecord funcDefToDataRecord(FunctionDefinition fd, CallerController caller) {
        DataRecord rec = new DataRecord(FUNCTION_DEFINITION_FORMAT);
        rec.setValue("name", (Object)fd.getName());
        rec.setValue(FIELD_FD_INPUTFORMAT, (Object)this.encodeFormat(fd.getInputFormat(), caller));
        rec.setValue(FIELD_FD_OUTPUTFORMAT, (Object)this.encodeFormat(fd.getOutputFormat(), caller));
        rec.setValue("description", (Object)fd.getDescription());
        rec.setValue("help", (Object)fd.getHelp());
        rec.setValue("group", (Object)fd.getGroup());
        rec.setValue("iconId", (Object)fd.getIconId());
        rec.setValue(FIELD_FD_CONCURRENT, (Object)fd.isConcurrent());
        if (fd.getPermissions() != null) {
            rec.setValue("permissions", (Object)fd.getPermissions().encode());
        }
        return rec;
    }

    public FunctionDefinition funcDefFromDataRecord(DataRecord rec) {
        return this.funcDefFromDataRecord(rec, null);
    }

    private FunctionDefinition funcDefFromDataRecord(DataRecord rec, CallerController caller) {
        TableFormat outputFormat;
        TableFormat inputFormat;
        String function = rec.getString("name");
        try {
            inputFormat = this.decodeFormat(rec.getString(FIELD_FD_INPUTFORMAT), caller);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error decoding input format of function '" + function + "': " + ex.getMessage(), ex);
        }
        try {
            outputFormat = this.decodeFormat(rec.getString(FIELD_FD_OUTPUTFORMAT), caller);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error decoding output format of function '" + function + "': " + ex.getMessage(), ex);
        }
        FunctionDefinition def = new FunctionDefinition(function, inputFormat, outputFormat, rec.getString("description"), rec.getString("group"));
        def.setHelp(rec.getString("help"));
        def.setIconId(rec.getString("iconId"));
        if (rec.hasField(FIELD_FD_CONCURRENT) && rec.getBoolean(FIELD_FD_CONCURRENT) != null) {
            def.setConcurrent(rec.getBoolean(FIELD_FD_CONCURRENT));
        }
        if (rec.hasField("permissions") && rec.getString("permissions") != null) {
            def.setPermissions(new Permissions(rec.getString("permissions")));
        }
        return def;
    }

    public DataTable getVevents(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        SimpleDataTable ans = new SimpleDataTable(def.getFormat());
        for (EventDefinition ed : this.getEventDefinitions(caller)) {
            ans.addRecord(this.evtDefToDataRecord(ed, caller));
        }
        return ans;
    }

    public DataRecord evtDefToDataRecord(EventDefinition ed) {
        return this.evtDefToDataRecord(ed, null);
    }

    protected DataRecord evtDefToDataRecord(EventDefinition ed, CallerController caller) {
        DataRecord rec = new DataRecord(EVENT_DEFINITION_FORMAT).addString(ed.getName()).addString(this.encodeFormat(ed.getFormat(), caller)).addString(ed.getDescription()).addString(ed.getHelp()).addInt(ed.getLevel()).addString(ed.getGroup()).addString(ed.getIconId());
        if (ed.getPermissions() != null) {
            rec.addString(ed.getPermissions().encode());
        }
        return rec;
    }

    public EventDefinition evtDefFromDataRecord(DataRecord rec) {
        return this.evtDefFromDataRecord(rec, null);
    }

    private EventDefinition evtDefFromDataRecord(DataRecord rec, CallerController caller) {
        TableFormat format;
        String event = rec.getString("name");
        try {
            format = this.decodeFormat(rec.getString("format"), caller);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error decoding format of event '" + event + "': " + ex.getMessage(), ex);
        }
        EventDefinition def = new EventDefinition(event, format, rec.getString("description"), rec.getString("group"));
        def.setLevel(rec.getInt("level"));
        def.setHelp(rec.getString("help"));
        def.setIconId(rec.getString("iconId"));
        if (rec.hasField("permissions")) {
            def.setPermissions(new Permissions(rec.getString("permissions")));
        }
        return def;
    }

    public DataTable getVactions(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        SimpleDataTable ans = new SimpleDataTable(def.getFormat());
        for (ActionDefinition adef : this.getActionDefinitions(caller)) {
            ans.addRecord(this.actDefToDataRecord(adef));
        }
        return ans;
    }

    public DataRecord actDefToDataRecord(ActionDefinition def) {
        SimpleDataTable resourceMasks = new SimpleDataTable(RESOURCE_MASKS_FORMAT);
        if (def.getDropSources() != null) {
            for (ResourceMask resourceMask : def.getDropSources()) {
                resourceMasks.addRecord().addString(resourceMask.toString());
            }
        }
        DataRecord rec = new DataRecord(ACTION_DEF_FORMAT);
        rec.addString(def.getName());
        rec.addString(def.getDescription());
        rec.addString(def.getHelp());
        rec.addString(def.getAccelerator() == null ? null : def.getAccelerator().toString());
        rec.addDataTable(resourceMasks);
        rec.addBoolean(def.isHidden());
        rec.addBoolean(def.isEnabled());
        rec.addString(def.getIconId());
        rec.addString(def.getGroup());
        rec.addString(def.getExecutionGroup() == null ? null : def.getExecutionGroup().toString());
        rec.addBoolean(def.isDefault());
        if (def.getPermissions() != null) {
            rec.addString(def.getPermissions().encode());
        }
        return rec;
    }

    protected void executeTasks(List<Callable<Object>> tasks) {
        double minimalLoadFactor = 0.7;
        this.executeTasks(tasks, 0.7);
    }

    protected void executeTasks(List<Callable<Object>> tasks, double loadFactor) {
        if (tasks.isEmpty()) {
            return;
        }
        try {
            if (this.isChildrenConcurrencyEnabled()) {
                this.executeTasksConcurrently(tasks, loadFactor);
            } else {
                for (Callable<Object> task : tasks) {
                    task.call();
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    protected void executeTasksConcurrently(List<Callable<Object>> tasks, double loadFactor) throws Exception {
        if (tasks.isEmpty()) {
            return;
        }
        if (loadFactor < 0.1) {
            Log.CONTEXT.warn((Object)String.format("Context tasks load factor is too low (%f), will be changed to 0.1", loadFactor));
            loadFactor = 0.1;
        }
        if (loadFactor > 0.9) {
            Log.CONTEXT.warn((Object)String.format("Context tasks load factor is too high (%f), will be changed to 0.9", loadFactor));
            loadFactor = 0.9;
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getContextManager().getExecutorService();
        int taskCount = tasks.size();
        int maxWorkers = executor.getMaximumPoolSize();
        int lowerIndex = 0;
        ArrayList allTaskFutures = new ArrayList(taskCount);
        do {
            int curFreeWorkers;
            int numOfTasksToSubmit;
            if ((numOfTasksToSubmit = (int)(loadFactor * (double)(curFreeWorkers = maxWorkers - executor.getActiveCount()))) > 0) {
                int upperIndex = Math.min(lowerIndex + numOfTasksToSubmit, tasks.size());
                List<Callable<Object>> tasksToSubmit = tasks.subList(lowerIndex, upperIndex);
                if (tasksToSubmit.size() != taskCount) {
                    Log.CONTEXT.debug((Object)("Executing only " + tasksToSubmit.size() + " out of " + taskCount + " tasks concurrently due to load factor limit " + loadFactor));
                }
                List bunchFutures = tasksToSubmit.stream().map(executor::submit).collect(Collectors.toList());
                allTaskFutures.addAll(bunchFutures);
                lowerIndex = upperIndex;
                continue;
            }
            Callable<Object> currentTask = tasks.get(lowerIndex);
            Log.CONTEXT.debug((Object)String.format("Due to loadFactor=%f and %d free workers, the task '%s' is going to be executed synchronously", loadFactor, curFreeWorkers, currentTask));
            try {
                currentTask.call();
            }
            catch (Exception e) {
                Log.CONTEXT.warn((Object)"One of synchronously executed tasks failed", (Throwable)e);
            }
            ++lowerIndex;
        } while (lowerIndex < tasks.size());
        long startTime = System.currentTimeMillis();
        int waitTasksCount = 0;
        for (Future taskFuture : allTaskFutures) {
            if (taskFuture.isDone()) continue;
            try {
                taskFuture.get();
            }
            catch (ExecutionException e) {
                Log.CONTEXT.warn((Object)"One of concurrently executed tasks failed", (Throwable)e);
            }
            ++waitTasksCount;
        }
        if (waitTasksCount > 0 && Log.CONTEXT.isDebugEnabled()) {
            Log.CONTEXT.debug((Object)String.format("Waiting on %d unfinished tasks took %d ms", waitTasksCount, System.currentTimeMillis() - startTime));
        }
    }

    protected void enableStatus() throws ContextException {
        this.status = new ContextStatus();
    }

    @Override
    public ContextStatus getStatus() {
        return this.status;
    }

    public void setStatus(int status, String comment) {
        if (this.status == null) {
            throw new IllegalStateException("Status is disabled");
        }
        boolean statusChanged = this.status.getStatus() != status;
        boolean commentChanged = !Util.equals(this.status.getComment(), comment);
        int oldStatus = this.status.getStatus();
        this.status.setStatus(status);
        this.status.setComment(comment);
        if (statusChanged || commentChanged) {
            this.fireStatusChanged(status, comment, oldStatus);
        }
    }

    protected void fireStatusChanged(int status, String comment, int oldStatus) {
    }

    protected void enableVariableStatuses(boolean persistent) {
        VariableDefinition vd = new VariableDefinition(V_VARIABLE_STATUSES, VFT_VARIABLE_STATUSES, true, true);
        vd.setPersistent(persistent);
        vd.setLocalCachingMode(0);
        vd.setGetter(new VariableGetter(){

            @Override
            public DataTable get(Context con, VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
                return AbstractContext.this.getVariableStatusesTable();
            }
        });
        this.addVariableDefinition(vd);
        this.addEventDefinition(new EventDefinition(E_VARIABLE_STATUS_CHANGED, VFT_VARIABLE_STATUSES));
        FunctionDefinition fd = new FunctionDefinition(F_GET_VARIABLE_STATUS, FIFT_GET_VARIABLE_STATUS, VFT_VARIABLE_STATUSES, Cres.get().getString("conGetVariableStatus"));
        fd.setPermissions(this.getPermissions());
        fd.setImplementation(this.getVariableStatusImpl);
        this.addFunctionDefinition(fd);
    }

    private DataTable getVariableStatusesTable() throws ContextException {
        if (this.variableStatusesTable == null) {
            return this.createVariableStatusesTable();
        }
        return this.variableStatusesTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTable createVariableStatusesTable() throws ContextException {
        this.variableStatusesLock.readLock().lock();
        try {
            SimpleDataTable table = new SimpleDataTable(VFT_VARIABLE_STATUSES);
            Map<String, VariableStatus> statuses = this.getVariableStatuses();
            for (String name : statuses.keySet()) {
                VariableStatus vs = statuses.get(name);
                table.addRecord().addString(name).addString(vs.getStatus()).addString(vs.getComment());
            }
            this.variableStatusesTable = table;
            SimpleDataTable simpleDataTable = table;
            return simpleDataTable;
        }
        finally {
            this.variableStatusesLock.readLock().unlock();
        }
    }

    private Map<String, VariableStatus> getVariableStatuses() throws ContextException {
        this.ensureVariableStatuses();
        return Collections.unmodifiableMap(this.variableStatuses);
    }

    protected void ensureVariableStatuses() throws ContextException {
        if (this.variableStatuses == null) {
            this.variableStatuses = Collections.synchronizedMap(new LinkedHashMap());
            DataTable statuses = this.fetchVariableStatuses();
            for (DataRecord rec : statuses) {
                this.variableStatuses.put(rec.getString("name"), VariableStatus.ofDataRecord(rec));
            }
        }
    }

    protected boolean isBelongedToTheGroup(String targetGroup, String entityGroup) {
        return entityGroup != null && (Util.equals(targetGroup, entityGroup) || entityGroup.startsWith(targetGroup + "|"));
    }

    protected DataTable fetchVariableStatuses() throws ContextException {
        return new SimpleDataTable(VFT_VARIABLE_STATUSES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVariableStatus(String variable, VariableStatus status, boolean persistent) throws ContextException {
        boolean changed;
        this.variableStatusesLock.writeLock().lock();
        try {
            this.ensureVariableStatuses();
            VariableStatus old = this.variableStatuses.put(variable, status);
            boolean bl = changed = old == null || !Util.equals(old.getStatus(), status.getStatus());
            if (changed) {
                this.variableStatusesTable = null;
            }
        }
        finally {
            this.variableStatusesLock.writeLock().unlock();
        }
        if (changed) {
            this.variableStatusesUpdated = true;
            this.fireEvent(E_VARIABLE_STATUS_CHANGED, variable, status.getStatus(), status.getComment());
        }
        if (persistent) {
            this.saveVariableStatuses();
        }
    }

    protected void clearVariableStatuses() throws ContextException {
        this.variableStatusesLock.writeLock().lock();
        try {
            if (this.variableStatuses != null) {
                this.variableStatuses.clear();
                this.variableStatusesTable = null;
            }
        }
        finally {
            this.variableStatusesLock.writeLock().unlock();
        }
        this.saveVariableStatuses();
    }

    protected void saveVariableStatuses() throws ContextException {
        if (this.variableStatusesUpdated) {
            this.persistVariableStatuses(this.getVariableStatusesTable());
        }
        this.variableStatusesUpdated = false;
    }

    protected void persistVariableStatuses(DataTable statuses) throws ContextException {
    }

    public VariableStatus getVariableStatus(VariableDefinition variableDefinition) throws ContextException {
        this.variableStatusesLock.readLock().lock();
        try {
            VariableStatus variableStatus = this.getVariableStatuses().get(variableDefinition.getName());
            return variableStatus;
        }
        finally {
            this.variableStatusesLock.readLock().unlock();
        }
    }

    public DataTable getVchildren(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        SimpleDataTable ans = new SimpleDataTable(def.getFormat());
        for (Context con : this.getChildren(caller)) {
            DataRecord record = ans.addRecord();
            record.setValue("name", (Object)con.getName());
            record.setValue(VF_CHILDREN_IS_CONTAINER, (Object)con.isContainer());
        }
        return ans;
    }

    public DataTable getVinfo(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        return this.createContextInfoTable();
    }

    protected DataTable createContextInfoTable() {
        return new SimpleDataTable(INFO_DEFINITION_FORMAT, this.getDescription(), this.getType(), this.getGroup(), this.getIconId(), this.getLocalRoot(true), this.getPeerRoot(), this.getLocalPrimaryRoot(), this.getRemoteRoot(), this.getRemotePath(), this.isMapped());
    }

    public DataTable callFgetCopyData(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        SimpleDataTable result = new SimpleDataTable(def.getOutputFormat().clone());
        String group = parameters.rec().getString("group");
        LinkedList<C> recipients = null;
        DataTable recipientsTable = parameters.rec().getDataTable(FIF_COPY_DATA_RECIPIENTS);
        if (recipientsTable != null) {
            recipients = new LinkedList<C>();
            for (DataRecord rec : recipientsTable) {
                C recipient = this.getContextManager().get(rec.getString(FIF_COPY_DATA_RECIPIENTS_RECIPIENT), caller);
                if (recipient == null) continue;
                recipients.add(recipient);
            }
        }
        for (VariableDefinition vd : this.getVariableDefinitions(caller)) {
            if (group != null && !Util.equals(ContextUtils.getBaseGroup(vd.getGroup()), group) || group == null && vd.getGroup() == null || !vd.isReadable() || vd.getFormat() == null || !vd.getFormat().isReplicated()) continue;
            if (recipients != null) {
                boolean skip = true;
                for (Context recipient : recipients) {
                    VariableDefinition rvd = recipient.getVariableDefinition(vd.getName());
                    if (rvd == null || !rvd.isWritable() || rvd.getFormat() != null && !rvd.getFormat().isReplicated()) continue;
                    skip = false;
                }
                if (skip) continue;
            }
            DataTable value = this.getVariable(vd.getName(), caller);
            TableFormat format = value.getFormat().clone();
            SimpleDataTable fields = new SimpleDataTable(FIFT_REPLICATE_FIELDS);
            for (FieldFormat ff : format) {
                if (ff.isNotReplicated()) {
                    ff.setReadonly(true);
                }
                if (ff.isHidden() || ff.isReadonly() || ff.isNotReplicated()) continue;
                fields.addRecord().addString(ff.getName()).addString(ff.toString()).addBoolean(true);
            }
            result.addRecord().addString(vd.getName()).addString(vd.getDescription()).addBoolean(false).addDataTable(fields).addDataTable(value);
        }
        result.fixRecords();
        return result;
    }

    public DataTable callFcopy(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        SimpleDataTable result = new SimpleDataTable(def.getOutputFormat());
        for (DataRecord rec : parameters) {
            DataTable tgtVal;
            if (!rec.getBoolean("replicate").booleanValue()) continue;
            String varName = rec.getString("name");
            String providedDesc = rec.getString("description");
            DataTable varValue = rec.getDataTable("value");
            VariableDefinition targetVd = this.getVariableDefinition(varName, caller);
            if (targetVd == null) {
                result.addRecord().addString(providedDesc).addBoolean(false).addString(Cres.get().getString("conVarNotAvailInTgt"));
                continue;
            }
            String varDesc = targetVd.getDescription();
            if (!targetVd.isWritable()) {
                result.addRecord().addString(varDesc).addBoolean(false).addString(Cres.get().getString("conVarNotWritableInTgt"));
                continue;
            }
            try {
                tgtVal = this.getVariableClone(varName, caller);
            }
            catch (ContextException ex) {
                result.addRecord().addString(varDesc).addBoolean(false).addString(Cres.get().getString("conErrGettingTgtVar") + ex.getMessage());
                continue;
            }
            LinkedList<String> fields = new LinkedList<String>();
            for (DataRecord fieldRec : rec.getDataTable(FOF_COPY_DATA_FIELDS)) {
                if (!fieldRec.getBoolean("replicate").booleanValue()) continue;
                fields.add(fieldRec.getString("name"));
            }
            Set<String> tableCopyErrors = this.replicateVariableOnCopy(varName, varValue, tgtVal, fields, caller);
            DataTableUtils.inlineData(tgtVal, this.getContextManager(), caller);
            try {
                this.setVariable(targetVd, caller, request, tgtVal);
            }
            catch (ContextException ex) {
                Log.CONTEXT_FUNCTIONS.warn((Object)"Error setting variable during context copy", (Throwable)ex);
                result.addRecord().addString(varDesc).addBoolean(false).addString(Cres.get().getString("conErrSettingTgtVar") + ex.getMessage());
                continue;
            }
            if (tableCopyErrors.size() > 0) {
                result.addRecord().addString(varDesc).addBoolean(false).addString(StringUtils.print(tableCopyErrors, "; "));
                continue;
            }
            result.addRecord().addString(varDesc).addBoolean(true);
        }
        return result;
    }

    public DataTable callFupdateVariable(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        boolean readLockedBySameThread;
        DataRecord rec = parameters.rec();
        String varName = rec.getString("variable");
        Expression expression = new Expression(rec.getString(V_UPDATE_VARIABLE_EXPRESSION));
        DataTable res = null;
        VariableData data = this.getVariableData(varName);
        if (data == null) {
            throw new ContextException(MessageFormat.format(Cres.get().getString("conVarNotAvailExt"), varName, this.getPath()));
        }
        boolean bl = readLockedBySameThread = data.getReadWriteLock().getReadHoldCount() > 0;
        if (!readLockedBySameThread) {
            this.lock(request, data.getReadWriteLock().writeLock());
        }
        try {
            DataTable variableValue = this.getVariable(varName, caller);
            res = new Evaluator(this.getContextManager(), this, variableValue, caller).evaluateToDataTable(expression);
            this.setVariable(varName, caller, res);
        }
        catch (SyntaxErrorException ex) {
            throw new ContextException(ex);
        }
        catch (EvaluationException ex) {
            throw new ContextException(ex);
        }
        finally {
            if (!readLockedBySameThread) {
                data.getReadWriteLock().writeLock().unlock();
            }
        }
        return res;
    }

    public Set<String> replicateVariableOnCopy(String variableName, DataTable variableValue, DataTable targetValue, List<String> fields, CallerController caller) {
        return DataTableReplication.copy(variableValue, targetValue, false, false, true, true, true, fields);
    }

    public DataTable callFcopyToChildren(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        return this.copyTo(def, caller, request, parameters, this.getChildren(caller));
    }

    protected DataTable copyTo(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters, List<C> children) {
        SimpleDataTable result = new SimpleDataTable(def.getOutputFormat());
        for (Context child : children) {
            DataTable conRes;
            String conDesc = child.getDescription() != null ? child.getDescription() : child.getPath();
            try {
                conRes = child.callFunction(F_COPY, caller, request, parameters);
            }
            catch (ContextException ex) {
                result.addRecord().addString(conDesc).addString(null).addBoolean(false).addString(ex.getMessage());
                continue;
            }
            for (DataRecord rec : conRes) {
                result.addRecord().addString(conDesc).addString(rec.getString("variable")).addBoolean(rec.getBoolean(FIELD_REPLICATE_SUCCESSFUL)).addString(rec.getString(FIELD_REPLICATE_ERRORS));
            }
        }
        return result;
    }

    public DataTable callFgetAliases(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        SimpleDataTable result = new SimpleDataTable(def.getOutputFormat());
        this.variableNameByAlias.forEach((alias, name) -> result.addRecord(1, alias, name));
        this.functionNameByAlias.forEach((alias, name) -> result.addRecord(2, alias, name));
        this.eventNameByAlias.forEach((alias, name) -> result.addRecord(4, alias, name));
        this.actionNameByAlias.forEach((alias, name) -> result.addRecord(8, alias, name));
        return result;
    }

    public DataTable callFfireContextEvent(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        Integer level = parameters.rec().getInt("level");
        String event = parameters.rec().getString(FIF_FIRE_EVENT_EVENT);
        DataTable data = parameters.rec().getDataTable("data");
        Event resultEv = this.fireEvent(event, level, caller, data);
        SimpleDataTable result = new SimpleDataTable(FOFT_FIRE_CONTEXT_EVENT, true);
        if (resultEv != null && resultEv.getId() != null) {
            result.rec().setValue(FOF_FIRE_EVENT_ID, (Object)resultEv.getId());
        }
        return result;
    }

    @Override
    public boolean isDebuggingEvaluations() {
        return false;
    }

    @Override
    public void processEvaluation(Evaluator evaluator, Expression expression, Reference holder, Object result, NodeEvaluationDetails details) {
    }

    @Override
    public void processEvaluationError(Evaluator evaluator, Expression expression, Reference holder, Exception error, NodeEvaluationDetails details) {
    }

    @Override
    public boolean isInstallationAllowed(String installableName) {
        return true;
    }

    protected void logAsyncSessionExecutionAction(CallerController caller, RequestController requestController, ContextOperationType operationType, String entityName, DataTable parameters, DataTable output, long duration) throws ContextException {
    }

    protected void validateVariableValueToSet(VariableDefinition variableDefinition, DataTable value) throws ContextException {
    }

    protected Map<String, VariableData> getVariableDataView() {
        return Collections.unmodifiableMap(this.variableData);
    }

    protected Map<String, FunctionData> getFunctionDataView() {
        return Collections.unmodifiableMap(this.functionData);
    }

    protected Map<String, EventData> getEventDataView() {
        return Collections.unmodifiableMap(this.eventData);
    }

    private boolean beginSpan(RequestController request, EntityDefinition entityDefinition) {
        Pinpoint source;
        if (request != null && request.isLoggerRequest()) {
            return false;
        }
        if (request != null && request.obtainPinpoint().isPresent()) {
            source = request.obtainPinpoint().get();
        } else if (!currentTrace.get().isEmpty()) {
            Span lastSpan = currentTrace.get().peek();
            source = lastSpan.getTarget().copy();
        } else if (currentSource.get() != null) {
            source = currentSource.get();
        } else {
            return false;
        }
        Pinpoint target = PinpointFactory.newPinpointFor(this.getPath(), entityDefinition.getName()).withScope(this.contextManager != null ? this.contextManager.getScope() : "");
        Span newSpan = new Span(source, target);
        currentTrace.get().push(newSpan);
        return true;
    }

    private void endSpan() {
        currentTrace.get().pop();
    }

    private void traceOperation(ContextOperationType operType) {
        C root = this.getRoot();
        Object pluginDirector = root.getContextManager().getPluginDirector();
        if (!root.isStarted() || root.isProxy() || pluginDirector == null) {
            return;
        }
        Span currentSpan = currentTrace.get().peek();
        Pinpoint source = currentSpan.getSource();
        Pinpoint target = currentSpan.getTarget();
        ApplicationStructureLocator.obtainStructureCollector(pluginDirector).recordInteraction(source, target, operType);
    }

    static {
        VARIABLE_DEFINITION_FORMAT.addField("<name><S>");
        VARIABLE_DEFINITION_FORMAT.addField("<format><S><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<description><S><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<readable><B>");
        VARIABLE_DEFINITION_FORMAT.addField("<writable><B>");
        VARIABLE_DEFINITION_FORMAT.addField("<help><S><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<group><S><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<iconId><S><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<helpId><S><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<cacheTime><L><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<addPreviousValueToVariableUpdateEvent><B><A=0>");
        VARIABLE_DEFINITION_FORMAT.addField("<readPermissions><S><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<writePermissions><S><F=N>");
        VARIABLE_DEFINITION_FORMAT.addField("<defaultValue><T><F=N>");
        VFT_VARIABLE_STATUSES = new TableFormat();
        VFT_VARIABLE_STATUSES.addField("<name><S>");
        VFT_VARIABLE_STATUSES.addField("<status><S><F=N>");
        VFT_VARIABLE_STATUSES.addField("<comment><S><F=N>");
        VFT_VISIBLE_CHILDREN = new TableFormat();
        VFT_VISIBLE_CHILDREN.addField("<path><S>");
        EF_VARIABLE_ADDED = VARIABLE_DEFINITION_FORMAT.clone();
        EF_VARIABLE_ADDED.setMinRecords(1);
        EF_VARIABLE_ADDED.setMaxRecords(1);
        FUNCTION_DEFINITION_FORMAT = new TableFormat();
        FUNCTION_DEFINITION_FORMAT.addField("<name><S>");
        FUNCTION_DEFINITION_FORMAT.addField("<inputformat><S><F=N>");
        FUNCTION_DEFINITION_FORMAT.addField("<outputformat><S><F=N>");
        FUNCTION_DEFINITION_FORMAT.addField("<description><S><F=N>");
        FUNCTION_DEFINITION_FORMAT.addField("<help><S><F=N>");
        FUNCTION_DEFINITION_FORMAT.addField("<group><S><F=N>");
        FUNCTION_DEFINITION_FORMAT.addField("<iconId><S><F=N>");
        FUNCTION_DEFINITION_FORMAT.addField("<concurrent><B><F=N>");
        FUNCTION_DEFINITION_FORMAT.addField("<permissions><S><F=N>");
        EF_FUNCTION_ADDED = FUNCTION_DEFINITION_FORMAT.clone();
        EF_FUNCTION_ADDED.setMinRecords(1);
        EF_FUNCTION_ADDED.setMaxRecords(1);
        EVENT_DEFINITION_FORMAT = new TableFormat();
        EVENT_DEFINITION_FORMAT.addField("<name><S>");
        EVENT_DEFINITION_FORMAT.addField("<format><S><F=N>");
        EVENT_DEFINITION_FORMAT.addField("<description><S><F=N>");
        EVENT_DEFINITION_FORMAT.addField("<help><S><F=N>");
        EVENT_DEFINITION_FORMAT.addField("<level><I>");
        EVENT_DEFINITION_FORMAT.addField("<group><S><F=N>");
        EVENT_DEFINITION_FORMAT.addField("<iconId><S><F=N>");
        EVENT_DEFINITION_FORMAT.addField("<permissions><S><F=N>");
        EF_EVENT_ADDED = EVENT_DEFINITION_FORMAT.clone();
        EF_EVENT_ADDED.setMinRecords(1);
        EF_EVENT_ADDED.setMaxRecords(1);
        VFT_CHILDREN = new TableFormat();
        FieldFormat ff = FieldFormat.create("name", 'S');
        VFT_CHILDREN.addField(ff);
        ff = FieldFormat.create(VF_CHILDREN_IS_CONTAINER, 'B');
        VFT_CHILDREN.addField(ff);
        INFO_DEFINITION_FORMAT = new TableFormat(1, 1);
        INFO_DEFINITION_FORMAT.addField("<description><S><F=N><D=" + Cres.get().getString("description") + ">");
        INFO_DEFINITION_FORMAT.addField("<type><S><D=" + Cres.get().getString(VF_INFO_TYPE) + ">");
        INFO_DEFINITION_FORMAT.addField("<group><S><F=N><D=" + Cres.get().getString("group") + ">");
        INFO_DEFINITION_FORMAT.addField("<icon><S><F=N><D=" + Cres.get().getString("conIconId") + ">");
        INFO_DEFINITION_FORMAT.addField("<localRoot><S><D=" + Cres.get().getString("conLocalRoot") + ">");
        INFO_DEFINITION_FORMAT.addField("<peerRoot><S><F=N><D=" + Cres.get().getString("conPeerRoot") + ">");
        INFO_DEFINITION_FORMAT.addField("<peerPrimaryRoot><S><F=N><D=" + Cres.get().getString("conPeerPrimaryRoot") + ">");
        INFO_DEFINITION_FORMAT.addField("<remoteRoot><S><F=N><D=" + Cres.get().getString("conRemoteRoot") + ">");
        INFO_DEFINITION_FORMAT.addField("<remotePath><S><D=" + Cres.get().getString("conRemotePath") + ">");
        INFO_DEFINITION_FORMAT.addField("<mapped><B><F=N><D=" + Cres.get().getString("conMapped") + ">");
        ACTION_DEF_FORMAT = new TableFormat();
        ACTION_DEF_FORMAT.addField("<name><S>");
        ACTION_DEF_FORMAT.addField("<description><S><F=N>");
        ACTION_DEF_FORMAT.addField("<help><S><F=N>");
        ACTION_DEF_FORMAT.addField("<accelerator><S><F=N>");
        ACTION_DEF_FORMAT.addField("<dropSources><T><F=N>");
        ACTION_DEF_FORMAT.addField("<hidden><B>");
        ACTION_DEF_FORMAT.addField("<enabled><B>");
        ACTION_DEF_FORMAT.addField("<iconId><S><F=N>");
        ACTION_DEF_FORMAT.addField("<group><S><F=N>");
        ACTION_DEF_FORMAT.addField("<executionGroup><S><F=N>");
        ACTION_DEF_FORMAT.addField("<default><B>");
        ACTION_DEF_FORMAT.addField("<permissions><S><F=N>");
        RESOURCE_MASKS_FORMAT = FieldFormat.create("<resourceMask><S><F=N>").wrap();
        FIFT_GET_COPY_DATA = new TableFormat(1, 1);
        FIFT_GET_COPY_DATA.addField("<group><S><F=N>");
        FIFT_GET_COPY_DATA.addField("<recipients><T><F=N>");
        FIFT_GET_COPY_DATA_RECIPIENTS = FieldFormat.create("<recipient><S>").wrap();
        REPLICATE_INPUT_FORMAT = new TableFormat();
        REPLICATE_INPUT_FORMAT.addField("<name><S><F=RHK>");
        REPLICATE_INPUT_FORMAT.addField("<description><S><F=R><D=" + Cres.get().getString("variable") + ">");
        REPLICATE_INPUT_FORMAT.addField("<replicate><B><A=0><D=" + Cres.get().getString("replicate") + ">");
        REPLICATE_INPUT_FORMAT.addField("<fields><T><D=" + Cres.get().getString(FOF_COPY_DATA_FIELDS) + ">");
        REPLICATE_INPUT_FORMAT.addField("<value><T><D=" + Cres.get().getString("value") + ">");
        FIFT_REPLICATE_FIELDS = new TableFormat();
        FIFT_REPLICATE_FIELDS.addField("<name><S><F=RHK>");
        FIFT_REPLICATE_FIELDS.addField("<description><S><F=R><D=" + Cres.get().getString("field") + ">");
        FIFT_REPLICATE_FIELDS.addField("<replicate><B><A=1><D=" + Cres.get().getString("replicate") + ">");
        FIFT_REPLICATE_FIELDS.setNamingExpression("print({}, '{replicate} ? {description} : null', ', ')");
        REPLICATE_OUTPUT_FORMAT = new TableFormat();
        REPLICATE_OUTPUT_FORMAT.addField("<variable><S><D=" + Cres.get().getString("variable") + ">");
        REPLICATE_OUTPUT_FORMAT.addField("<successful><B><D=" + Cres.get().getString(FIELD_REPLICATE_SUCCESSFUL) + ">");
        REPLICATE_OUTPUT_FORMAT.addField("<errors><S><D=" + Cres.get().getString(FIELD_REPLICATE_ERRORS) + ">");
        REPLICATE_TO_CHILDREN_OUTPUT_FORMAT = new TableFormat();
        REPLICATE_TO_CHILDREN_OUTPUT_FORMAT.addField("<context><S><D=" + Cres.get().getString(FIELD_REPLICATE_CONTEXT) + ">");
        REPLICATE_TO_CHILDREN_OUTPUT_FORMAT.addField("<variable><S><D=" + Cres.get().getString("variable") + ">");
        REPLICATE_TO_CHILDREN_OUTPUT_FORMAT.addField("<successful><B><D=" + Cres.get().getString(FIELD_REPLICATE_SUCCESSFUL) + ">");
        REPLICATE_TO_CHILDREN_OUTPUT_FORMAT.addField("<errors><S><D=" + Cres.get().getString(FIELD_REPLICATE_ERRORS) + ">");
        FIFT_UPDATE_VARIABLE = new TableFormat();
        FIFT_UPDATE_VARIABLE.addField(FieldFormat.create("variable", 'S', Cres.get().getString("variable")));
        FIFT_UPDATE_VARIABLE.addField(FieldFormat.create(V_UPDATE_VARIABLE_EXPRESSION, 'S', Cres.get().getString(V_UPDATE_VARIABLE_EXPRESSION)).setEditor(V_UPDATE_VARIABLE_EXPRESSION));
        FIFT_GET_VARIABLE_STATUS = new TableFormat();
        FIFT_GET_VARIABLE_STATUS.addField(FieldFormat.create(V_VARIABLE_NAME, 'S', Cres.get().getString("variable")));
        FIFT_LOCK = new TableFormat(1, 1);
        FIFT_LOCK.addField(FieldFormat.create("propertiesEditorUUID", 'S'));
        FIFT_UNLOCK = new TableFormat(1, 1);
        FIFT_UNLOCK.addField(FieldFormat.create("propertiesEditorUUID", 'S'));
        FIFT_VISIBLE_CHILDREN = new TableFormat();
        FIFT_VISIBLE_CHILDREN.addField(FieldFormat.create(FIF_VISIBLE_CHILDREN_FILTER_EXPRESSION, 'S', Cres.get().getString("efFilterExpr")));
        FIFT_VISIBLE_CHILDREN.addField(FieldFormat.create(FIF_VISIBLE_CHILDREN_CONTEXT_MASK, 'S', Cres.get().getString("conContextMask")));
        FIFT_VISIBLE_CHILDREN.addField(FieldFormat.create(FIF_VISIBLE_CHILDREN_OFFSET, 'I', Cres.get().getString(FIF_VISIBLE_CHILDREN_OFFSET)));
        FIFT_VISIBLE_CHILDREN.addField(FieldFormat.create(FIF_VISIBLE_CHILDREN_COUNT, 'I', Cres.get().getString(FIF_VISIBLE_CHILDREN_COUNT)));
        FIFT_VISIBLE_CHILDREN.addField(FieldFormat.create(FIF_VISIBLE_CHILDREN_PROPERTY_FILTERS, 'T', Cres.get().getString(FIF_VISIBLE_CHILDREN_PROPERTY_FILTERS)));
        FIFT_VISIBLE_CHILDREN.addField(FieldFormat.create(FIF_VISIBLE_CHILDREN_GLOBAL_FILTER, 'T', Cres.get().getString(FIF_VISIBLE_CHILDREN_GLOBAL_FILTER)));
        FIFT_VISIBLE_CHILDREN.addField(FieldFormat.create(FIF_VISIBLE_CHILDREN_SMART_FILTER_EXPRESSION, 'S', Cres.get().getString(FIF_VISIBLE_CHILDREN_SMART_FILTER_EXPRESSION)));
        FOFT_LOCKED_BY = new TableFormat(1, 1);
        FOFT_LOCKED_BY.addField(FieldFormat.create("lockOwnerName", 'S', Cres.get().getString("conPropLockOwnerName")).setNullable(true));
        FOFT_LOCK = new TableFormat(1, 1);
        FOFT_LOCK.addField(FieldFormat.create("lockOwnerName", 'S', Cres.get().getString("conPropLockOwnerName")).setNullable(true));
        FOFT_UNLOCK = new TableFormat(1, 1);
        FOFT_UNLOCK.addField(FieldFormat.create(FOF_UNLOCK_UNLOCKED, 'B'));
        FOFT_VISIBLE_CHILDREN = new TableFormat(1, 1);
        FOFT_VISIBLE_CHILDREN.addField(FieldFormat.create(FOF_VISIBLE_CHILDREN_BATCH, 'T', "", new SimpleDataTable(VFT_VISIBLE_CHILDREN)));
        FOFT_VISIBLE_CHILDREN.addField("<total><I>");
        FOFT_GET_ALIASES = new TableFormat();
        FOFT_GET_ALIASES.addField(FieldFormat.create(FOF_GET_ALIASES_ENTITY_TYPE, 'I', Cres.get().getString(FOF_GET_ALIASES_ENTITY_TYPE), 1).addSelectionValue(1).addSelectionValue(2).addSelectionValue(4).addSelectionValue(8));
        FOFT_GET_ALIASES.addField(FieldFormat.create(FOF_GET_ALIASES_ALIAS_NAME, 'S', Cres.get().getString("alias")));
        FOFT_GET_ALIASES.addField(FieldFormat.create("name", 'S', Cres.get().getString("realName")));
        FIFT_FIRE_CONTEXT_EVENT = new TableFormat(1, 1);
        FIFT_FIRE_CONTEXT_EVENT.addField(FieldFormat.create("level", 'I', Cres.get().getString("efEventLevel"), -1));
        FIFT_FIRE_CONTEXT_EVENT.addField(FieldFormat.create(FIF_FIRE_EVENT_EVENT, 'S', Cres.get().getString("efEventName")));
        FIFT_FIRE_CONTEXT_EVENT.addField(FieldFormat.create("data", 'T', Cres.get().getString("evtEventData")));
        FOFT_FIRE_CONTEXT_EVENT = new TableFormat(1, 1);
        FOFT_FIRE_CONTEXT_EVENT.addField(FieldFormat.create(FOF_FIRE_EVENT_ID, 'L', Cres.get().getString("evtEventID")).setNullable(true));
        EF_UPDATED = new TableFormat(1, 1);
        EF_UPDATED.addField("<variable><S>");
        EF_UPDATED.addField("<value><T>");
        EF_UPDATED.addField("<valueOld><T><F=N>");
        EF_UPDATED.addField("<user><S><F=N>");
        EF_UPDATED.addField("<updateOriginator><I>");
        EF_UPDATED.addField("<status><T><F=N>");
        EF_CHANGE = new TableFormat(1, 1);
        EF_CHANGE.addField("<variable><S>");
        EF_CHANGE.addField("<value><T><F=N>");
        EF_CHANGE.addField("<data><S><F=N>");
        EF_CHANGE.addField("<format><S><F=N>");
        EFT_INFO = new TableFormat(1, 1, "<info><S><D=" + Cres.get().getString("info") + ">");
        EFT_VARIABLE_REMOVED = new TableFormat(1, 1, "<name><S>");
        EFT_EVENT_REMOVED = new TableFormat(1, 1, "<name><S>");
        EFT_FUNCTION_REMOVED = new TableFormat(1, 1, "<name><S>");
        EFT_CHILD_REMOVED = new TableFormat(1, 1, "<child><S>");
        EFT_CHILD_ADDED = new TableFormat(1, 1, "<child><S>");
        EFT_ACTION_REMOVED = new TableFormat(1, 1, "<name><S>");
        VD_INFO = new VariableDefinition("info", INFO_DEFINITION_FORMAT, true, false, Cres.get().getString("conContextProps"), "system");
        VD_INFO.setHidden(true);
        VD_INFO.setReadPermissions(DefaultPermissionChecker.getNullPermissions());
        VD_VARIABLES = new VariableDefinition(V_VARIABLES, VARIABLE_DEFINITION_FORMAT, true, false, Cres.get().getString("conVarList"));
        VD_VARIABLES.setHidden(true);
        VD_VARIABLES.setReadPermissions(DefaultPermissionChecker.getNullPermissions());
        VD_FUNCTIONS = new VariableDefinition(V_FUNCTIONS, FUNCTION_DEFINITION_FORMAT, true, false, Cres.get().getString("conFuncList"));
        VD_FUNCTIONS.setHidden(true);
        VD_FUNCTIONS.setReadPermissions(DefaultPermissionChecker.getNullPermissions());
        VD_EVENTS = new VariableDefinition(V_EVENTS, EVENT_DEFINITION_FORMAT, true, false, Cres.get().getString("conEvtList"));
        VD_EVENTS.setHidden(true);
        VD_EVENTS.setReadPermissions(DefaultPermissionChecker.getNullPermissions());
        VD_ACTIONS = new VariableDefinition(V_ACTIONS, ACTION_DEF_FORMAT, true, false, Cres.get().getString("conActionList"));
        VD_ACTIONS.setHidden(true);
        VD_ACTIONS.setReadPermissions(DefaultPermissionChecker.getNullPermissions());
        VD_CHILDREN = new VariableDefinition(V_CHILDREN, VFT_CHILDREN, true, false, Cres.get().getString("conChildList"));
        VD_CHILDREN.setHidden(true);
        VD_CHILDREN.setReadPermissions(DefaultPermissionChecker.getNullPermissions());
        FD_GET_COPY_DATA = new FunctionDefinition(F_GET_COPY_DATA, FIFT_GET_COPY_DATA, REPLICATE_INPUT_FORMAT);
        FD_GET_COPY_DATA.setHidden(true);
        FD_COPY = new FunctionDefinition(F_COPY, REPLICATE_INPUT_FORMAT, REPLICATE_OUTPUT_FORMAT, Cres.get().getString("conCopyProperties"));
        FD_COPY.setHidden(true);
        FD_COPY_TO_CHILDREN = new FunctionDefinition(F_COPY_TO_CHILDREN, REPLICATE_INPUT_FORMAT, REPLICATE_TO_CHILDREN_OUTPUT_FORMAT, Cres.get().getString("conCopyToChildren"));
        FD_COPY_TO_CHILDREN.setHidden(true);
        FD_UPDATE_VARIABLE = new FunctionDefinition(F_UPDATE_VARIABLE, FIFT_UPDATE_VARIABLE, null, Cres.get().getString(F_UPDATE_VARIABLE), "system");
        FD_UPDATE_VARIABLE.setConcurrent(true);
        FD_GET_ALIASES = new FunctionDefinition(F_GET_ALIASES, null, FOFT_GET_ALIASES);
        FD_GET_ALIASES.setPermissions(ServerPermissionChecker.getObserverPermissions());
        FD_FIRE_CONTEXT_EVENT = new FunctionDefinition(F_FIRE_CONTEXT_EVENT, FIFT_FIRE_CONTEXT_EVENT, FOFT_FIRE_CONTEXT_EVENT);
        FD_FIRE_CONTEXT_EVENT.setPermissions(ServerPermissionChecker.getObserverPermissions());
        ED_INFO = new EventDefinition("info", EFT_INFO, Cres.get().getString("info"), "default");
        ED_INFO.setLevel(2);
        ED_INFO.setIconId("evt_info");
        ED_INFO.getPersistenceOptions().setDedicatedTablePreferred(true);
        ED_CHILD_ADDED = new EventDefinition(E_CHILD_ADDED, EFT_CHILD_ADDED, Cres.get().getString("conChildAdded"), "system");
        ED_CHILD_ADDED.setConcurrency(EventDefinition.CONCURRENCY_SYNCHRONOUS);
        ED_CHILD_ADDED.setHidden(true);
        ED_CHILD_ADDED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_CHILD_REMOVED = new EventDefinition(E_CHILD_REMOVED, EFT_CHILD_REMOVED, Cres.get().getString("conChildRemoved"), "system");
        ED_CHILD_REMOVED.setConcurrency(EventDefinition.CONCURRENCY_SYNCHRONOUS);
        ED_CHILD_REMOVED.setHidden(true);
        ED_CHILD_REMOVED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_VARIABLE_ADDED = new EventDefinition(E_VARIABLE_ADDED, EF_VARIABLE_ADDED, Cres.get().getString("conVarAdded"), "system");
        ED_VARIABLE_ADDED.setHidden(true);
        ED_VARIABLE_ADDED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_VARIABLE_REMOVED = new EventDefinition(E_VARIABLE_REMOVED, EFT_VARIABLE_REMOVED, Cres.get().getString("conVarRemoved"), "system");
        ED_VARIABLE_REMOVED.setHidden(true);
        ED_VARIABLE_REMOVED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_FUNCTION_ADDED = new EventDefinition(E_FUNCTION_ADDED, EF_FUNCTION_ADDED, Cres.get().getString("conFuncAdded"), "system");
        ED_FUNCTION_ADDED.setHidden(true);
        ED_FUNCTION_ADDED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_FUNCTION_REMOVED = new EventDefinition(E_FUNCTION_REMOVED, EFT_FUNCTION_REMOVED, Cres.get().getString("conFuncRemoved"), "system");
        ED_FUNCTION_REMOVED.setHidden(true);
        ED_FUNCTION_REMOVED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_EVENT_ADDED = new EventDefinition(E_EVENT_ADDED, EF_EVENT_ADDED, Cres.get().getString("conEvtAdded"), "system");
        ED_EVENT_ADDED.setHidden(true);
        ED_EVENT_ADDED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_EVENT_REMOVED = new EventDefinition(E_EVENT_REMOVED, EFT_EVENT_REMOVED, Cres.get().getString("conEvtRemoved"), "system");
        ED_EVENT_REMOVED.setHidden(true);
        ED_EVENT_REMOVED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_ACTION_ADDED = new EventDefinition(E_ACTION_ADDED, ACTION_DEF_FORMAT.clone().setMinRecords(1).setMaxRecords(1), Cres.get().getString("conActionAdded"));
        ED_ACTION_ADDED.setHidden(true);
        ED_ACTION_ADDED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_ACTION_REMOVED = new EventDefinition(E_ACTION_REMOVED, EFT_ACTION_REMOVED, Cres.get().getString("conActionRemoved"));
        ED_ACTION_REMOVED.setHidden(true);
        ED_ACTION_REMOVED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_ACTION_STATE_CHANGED = new EventDefinition(E_ACTION_STATE_CHANGED, ACTION_DEF_FORMAT, Cres.get().getString("conActionStateChanged"));
        ED_ACTION_STATE_CHANGED.setHidden(true);
        ED_ACTION_STATE_CHANGED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_INFO_CHANGED = new EventDefinition(E_INFO_CHANGED, INFO_DEFINITION_FORMAT, Cres.get().getString("conInfoChanged"), "system");
        ED_INFO_CHANGED.setHidden(true);
        ED_INFO_CHANGED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        ED_UPDATED = new EventDefinition(E_UPDATED, EF_UPDATED, Cres.get().getString("conUpdated"), "system");
        ED_UPDATED.setHidden(true);
        ED_UPDATED.setConcurrency(EventDefinition.CONCURRENCY_CONCURRENT);
        ED_UPDATED.setFingerprintExpression("{variable}");
        ED_CHANGE = new EventDefinition(E_CHANGE, EF_CHANGE, Cres.get().getString(E_CHANGE), "system");
        ED_CHANGE.setHidden(true);
        ED_CHANGE.getPersistenceOptions().setDedicatedTablePreferred(true);
        ED_DESTROYED = new EventDefinition(E_DESTROYED, TableFormat.EMPTY_FORMAT, Cres.get().getString("conDestroyedPermanently"), "system");
        ED_DESTROYED.setConcurrency(EventDefinition.CONCURRENCY_SYNCHRONOUS);
        ED_DESTROYED.setHidden(true);
        ED_DESTROYED.setPermissions(DefaultPermissionChecker.getNullPermissions());
        DEFAULT_PERMISSIONS = DefaultPermissionChecker.getNullPermissions();
        currentTrace = ThreadLocal.withInitial(LinkedList::new);
        currentSource = new ThreadLocal();
    }
}

