/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.context;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.CallerData;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.LogoutListener;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.security.PermissionCache;
import com.tibbo.aggregate.common.security.Permissions;
import com.tibbo.aggregate.common.util.WatchdogHolder;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.util.Strings;

public abstract class AbstractCallerController
implements CallerController {
    private static final int CACHE_EXPIRATION_PERIOD = 1000;
    private static final AtomicLong SESSION_ID_COUNTER = new AtomicLong(0L);
    private static final Set<CallerController> CONTROLLERS = Collections.newSetFromMap(new WeakHashMap());
    private static final ReentrantReadWriteLock CONTROLLERS_LOCK = new ReentrantReadWriteLock();
    private static final String FIELD_LOCKED_CONTEXTS_CONTEXT_PATH = "contextPath";
    private static final String FIELD_LOCKED_CONTEXTS_CONTEXT_DESCRIPTION = "contextDescription";
    private static final TableFormat FORMAT_LOCKED_CONTEXTS = new TableFormat();
    private String username;
    private String inheritedUsername;
    private String login;
    private final CallerData callerData;
    private boolean loggedIn = false;
    private CallerController.Type type;
    private String address;
    private final Date creationTime = new Date();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private Long lastCacheOperationTime = null;
    private Map<String, Reference<Context>> cache;
    private final Set<Context> lockedContexts = new HashSet<Context>();
    private final Long sessionIdCounter;
    private String sessionId;
    private Long tokenExpirationPeriod;
    private final List<LogoutListener> logoutListeners = new LinkedList<LogoutListener>();

    public AbstractCallerController(CallerData callerData) {
        this.callerData = callerData;
        this.resetCache();
        CONTROLLERS_LOCK.writeLock().lock();
        CONTROLLERS.add(this);
        CONTROLLERS_LOCK.writeLock().unlock();
        this.sessionIdCounter = SESSION_ID_COUNTER.getAndIncrement();
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    protected void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    @Override
    public boolean isPermissionCheckingEnabled() {
        return true;
    }

    @Override
    public PermissionCache getPermissionCache() {
        return null;
    }

    @Override
    public CallerData getCallerData() {
        return this.callerData;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void sendFeedback(int level, String message) {
        this.sendFeedback(level, message, null);
    }

    @Override
    public void sendFeedback(int level, String message, Integer duration) {
    }

    public static List<CallerController> getControllers() {
        LinkedList<CallerController> list = new LinkedList<CallerController>();
        CONTROLLERS_LOCK.readLock().lock();
        for (CallerController cc : CONTROLLERS) {
            list.add(cc);
        }
        CONTROLLERS_LOCK.readLock().unlock();
        return Collections.unmodifiableList(list);
    }

    public String toString() {
        return (this.type != null ? this.type : this.getClass().getName()) + " (" + (this.loggedIn ? "logged in" : "not logged in") + ")";
    }

    @Override
    public Permissions getPermissions() {
        return null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    protected void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getLogin() {
        return this.login != null ? this.login : this.getEffectiveUsername();
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String getInheritedUsername() {
        return this.inheritedUsername;
    }

    public void setInheritedUsername(String inheritedUsername) {
        this.inheritedUsername = inheritedUsername;
    }

    @Override
    public String getEffectiveUsername() {
        String inheritedUsername = this.getInheritedUsername();
        return Strings.isNotEmpty((CharSequence)inheritedUsername) ? inheritedUsername : this.getUsername();
    }

    @Override
    public CallerController.Type getType() {
        return this.type;
    }

    public void setType(CallerController.Type type) {
        this.type = type;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public Long getTokenExpirationPeriod() {
        return this.tokenExpirationPeriod;
    }

    public void setTokenExpirationPeriod(Long tokenExpirationPeriod) {
        this.tokenExpirationPeriod = tokenExpirationPeriod;
    }

    @Override
    public void login(String username, String inheritedUsername, Permissions permissons) throws ContextException {
        this.setUsername(username);
        this.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void logoutSoftly() {
        List<LogoutListener> list = this.logoutListeners;
        synchronized (list) {
            this.logoutListeners.forEach(logoutListener -> logoutListener.beforeLogout(this.getSessionId()));
        }
        this.logoutInternal(true);
        list = this.logoutListeners;
        synchronized (list) {
            this.logoutListeners.forEach(logoutListener -> logoutListener.afterLogout(this.getSessionId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void logout() {
        List<LogoutListener> list = this.logoutListeners;
        synchronized (list) {
            this.logoutListeners.forEach(logoutListener -> logoutListener.beforeLogout(this.getSessionId()));
        }
        this.logoutInternal(false);
        list = this.logoutListeners;
        synchronized (list) {
            this.logoutListeners.forEach(logoutListener -> logoutListener.afterLogout(this.getSessionId()));
        }
    }

    protected void logoutInternal(boolean softly) {
        if (this.callerData != null) {
            this.callerData.cleanup();
        }
        this.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogoutListener(LogoutListener logoutListener) {
        List<LogoutListener> list = this.logoutListeners;
        synchronized (list) {
            this.logoutListeners.add(logoutListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogoutListener(LogoutListener logoutListener) {
        List<LogoutListener> list = this.logoutListeners;
        synchronized (list) {
            this.logoutListeners.remove(logoutListener);
        }
    }

    @Override
    public Long getSessionIdCounter() {
        return this.sessionIdCounter;
    }

    @Override
    public Context lookup(String path) {
        Reference<Context> ref;
        Context con;
        if (!this.isPermissionCheckingEnabled()) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        if (this.resetCache(currentTime)) {
            return null;
        }
        if (this.lastCacheOperationTime == null) {
            this.lastCacheOperationTime = currentTime;
        }
        Context context = con = (ref = this.cache.get(path)) != null ? ref.get() : null;
        if (con == null) {
            return null;
        }
        if (con.getContextManager() == null || !con.hasParent(con.getContextManager().getRoot())) {
            return null;
        }
        return con;
    }

    @Override
    public void cache(String path, Context context) {
        if (context.getContextManager() == null) {
            return;
        }
        if (!context.getContextManager().isServerManager()) {
            return;
        }
        if (!this.isPermissionCheckingEnabled()) {
            return;
        }
        if (!WatchdogHolder.getInstance().isEnoughMemory()) {
            this.resetCache();
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.resetCache(currentTime);
        this.cache.put(path, new WeakReference<Context>(context));
        if (this.lastCacheOperationTime == null) {
            this.lastCacheOperationTime = currentTime;
        }
    }

    private boolean resetCache(long currentTime) {
        if (this.lastCacheOperationTime != null && currentTime - this.lastCacheOperationTime > 1000L) {
            this.resetCache();
            return true;
        }
        return false;
    }

    private void resetCache() {
        this.cache = new ConcurrentHashMap<String, Reference<Context>>();
        this.lastCacheOperationTime = null;
    }

    @Override
    public void addLockedContext(Context context) {
        this.lockedContexts.add(context);
    }

    @Override
    public void removeLockedContext(Context context) {
        this.lockedContexts.remove(context);
    }

    @Override
    public DataTable createLockedContextsTable() {
        SimpleDataTable result = new SimpleDataTable(FORMAT_LOCKED_CONTEXTS);
        HashSet<Context> clone = new HashSet<Context>(this.lockedContexts);
        for (Context context : clone) {
            result.addRecord(context.getPath(), context.getDescription());
        }
        result.sort(FIELD_LOCKED_CONTEXTS_CONTEXT_PATH, true);
        return result;
    }

    @Override
    public void unlockAllContexts() {
        HashSet<Context> clone = new HashSet<Context>(this.lockedContexts);
        for (Context context : clone) {
            try {
                context.callFunction("breakLock", this);
            }
            catch (ContextException e) {
                Log.CONTEXT.warn((Object)("An error occurred when trying to unlock context '" + context + "' locked by caller '" + this + "'"));
            }
        }
    }

    @Override
    public boolean isWeb() {
        return CallerController.Type.WEB_SOCKET.equals((Object)this.getType());
    }

    @Override
    public boolean isConnectionTerminatable() {
        return this.getUsername() != null && !this.isHeadless() && this.isLoggedIn();
    }

    static {
        FORMAT_LOCKED_CONTEXTS.addField(FieldFormat.create(FIELD_LOCKED_CONTEXTS_CONTEXT_PATH, 'S', Cres.get().getString("conContextPath")));
        FORMAT_LOCKED_CONTEXTS.addField(FieldFormat.create(FIELD_LOCKED_CONTEXTS_CONTEXT_DESCRIPTION, 'S', Cres.get().getString("description")).setNullable(true));
    }
}

