/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.communication;

import com.tibbo.aggregate.common.communication.BufferedCommandParser;
import com.tibbo.aggregate.common.communication.Command;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.nio.channels.ReadableByteChannel;

public abstract class SimpleCommandParser<C extends Command>
extends BufferedCommandParser<C> {
    private Byte startChar;
    private byte endChar;
    private Byte endChar2;
    private boolean needBoth;
    private boolean started;
    private boolean waitingEndChar2;
    private boolean full;

    public SimpleCommandParser(ReadableByteChannel channel, Byte startChar, byte endChar) {
        super(channel);
        this.init(startChar, endChar);
    }

    public SimpleCommandParser(ReadableByteChannel channel, Byte startChar, byte endChar, Byte endChar2, boolean needBoth) {
        super(channel);
        this.init(startChar, endChar);
        this.endChar2 = endChar2;
        this.needBoth = needBoth;
    }

    protected abstract C createCommandFromBufferContent() throws SyntaxErrorException;

    private void init(Byte startChar, byte endChar) {
        this.startChar = startChar;
        this.endChar = endChar;
        this.clearCommand();
    }

    public void clearCommand() {
        this.started = this.startChar == null;
        this.waitingEndChar2 = false;
        this.full = false;
        this.reset();
    }

    @Override
    protected C buildCommand() throws SyntaxErrorException {
        if (this.isFull()) {
            C command = this.createCommandFromBufferContent();
            this.clearCommand();
            return command;
        }
        return null;
    }

    @Override
    protected boolean commandEnded(byte cur) {
        if (this.startChar != null && cur == this.startChar) {
            this.started = true;
            this.reset();
        } else if (this.started) {
            if (this.waitingEndChar2) {
                if (cur == this.endChar2) {
                    this.full = true;
                    return true;
                }
            } else {
                if (cur == this.endChar || this.endChar2 != null && !this.needBoth && cur == this.endChar2) {
                    if (this.endChar2 != null && this.needBoth) {
                        this.waitingEndChar2 = true;
                        this.full = false;
                        return false;
                    }
                    this.full = true;
                    return true;
                }
                this.addData(cur);
            }
        }
        return false;
    }

    public boolean isFull() {
        return this.full;
    }
}

