/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.communication;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.communication.Command;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ReplyMonitor<C extends Command, R extends Command> {
    private C command = null;
    private R reply = null;
    private final long startTime;
    private final long time;
    private final Lock lock = new ReentrantLock();
    private final Condition commandReceivedCondition = this.lock.newCondition();
    private boolean timeoutReset;
    private boolean terminated;

    public ReplyMonitor(C command) {
        this.command = command;
        this.time = this.startTime = System.currentTimeMillis();
    }

    public C getCommand() {
        return this.command;
    }

    public R getReply() {
        return this.reply;
    }

    public void setReply(R reply) {
        this.lock.lock();
        try {
            this.reply = reply;
            this.commandReceivedCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (Log.COMMANDS.isDebugEnabled()) {
            Log.COMMANDS.debug((Object)("Command replied in " + (System.currentTimeMillis() - this.time) + " ms: command '" + this.command + "', reply '" + reply + "'"));
        }
    }

    public void terminate() {
        this.lock.lock();
        try {
            this.terminated = true;
            this.commandReceivedCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.timeoutReset = true;
            this.commandReceivedCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitReply(long timeout) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            do {
                if (this.reply != null) {
                    boolean bl = true;
                    return bl;
                }
                if (this.terminated) {
                    boolean bl = false;
                    return bl;
                }
                this.timeoutReset = false;
                this.commandReceivedCondition.await(timeout, TimeUnit.MILLISECONDS);
            } while (this.timeoutReset);
        }
        finally {
            this.lock.unlock();
        }
        return this.reply != null;
    }

    public long getTime() {
        return this.time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return "ReplyMonitor [command: " + this.command + ", reply: " + this.reply + "]";
    }
}

