/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.communication;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.communication.Command;
import com.tibbo.aggregate.common.communication.ReplyMonitor;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.field.LongFieldFormat;

public class CommandProcessorStatistics {
    public static final TableFormat FORMAT = new TableFormat(1, 1);
    private Long startTime;
    private long commandCount;
    private long eventCount;
    private float averageResponseTime;
    private long outgoingTraffic;
    private long incomingTraffic;
    private long unrepliedCommandCount;

    public void updateOnAsyncCommand(Command command) {
        ++this.eventCount;
        this.incomingTraffic += (long)command.size();
    }

    public void updateOnSyncCommand(ReplyMonitor<? extends Command, ? extends Command> monitor) {
        if (this.commandCount == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.commandCount;
        this.averageResponseTime = (this.averageResponseTime * (new Float(this.commandCount).floatValue() - 1.0f) + new Float(System.currentTimeMillis() - monitor.getStartTime()).floatValue()) / new Float(this.commandCount).floatValue();
        this.outgoingTraffic += (long)monitor.getCommand().size();
        if (monitor.getReply() != null) {
            this.incomingTraffic += (long)monitor.getReply().size();
        } else {
            ++this.unrepliedCommandCount;
        }
    }

    public DataTable toDataTable() {
        try {
            return DataTableConversion.beanToTable(this, FORMAT);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getConnectionTime() {
        return this.startTime != null ? Long.valueOf(System.currentTimeMillis() - this.startTime) : null;
    }

    public long getCommandCount() {
        return this.commandCount;
    }

    public long getEventCount() {
        return this.eventCount;
    }

    public long getAverageResponseTime() {
        return new Float(this.averageResponseTime).longValue();
    }

    public long getOutgoingTraffic() {
        return this.outgoingTraffic;
    }

    public long getIncomingTraffic() {
        return this.incomingTraffic;
    }

    public long getUnrepliedCommandCount() {
        return this.unrepliedCommandCount;
    }

    static {
        FORMAT.addField("<connectionTime><L><F=N><D=" + Cres.get().getString("commConnectionTime") + "><H=" + Cres.get().getString("statisticsServerConnectionHelpTime") + "><E=" + "period" + "><O=" + LongFieldFormat.encodePeriodEditorOptions(1, 4) + ">");
        FORMAT.addField("<commandCount><L><D=" + Cres.get().getString("commCommandCount") + "><H=" + Cres.get().getString("statisticsServerConnectionHelpCommands") + ">");
        FORMAT.addField("<eventCount><L><D=" + Cres.get().getString("commEventCount") + "><H=" + Cres.get().getString("statisticsServerConnectionHelpEvents") + ">");
        FORMAT.addField("<averageResponseTime><L><D=" + Cres.get().getString("commAvgResponseTime") + "><H=" + Cres.get().getString("statisticsServerConnectionHelpResponceTime") + "><E=" + "period" + "><O=" + LongFieldFormat.encodePeriodEditorOptions(0, 0) + ">");
        FORMAT.addField("<incomingTraffic><L><D=" + Cres.get().getString("commIncomingTraffic") + "><H=" + Cres.get().getString("statisticsServerConnectionHelpIncoming") + "><E=" + "bytes" + ">");
        FORMAT.addField("<outgoingTraffic><L><D=" + Cres.get().getString("commOutgoingTraffic") + "><H=" + Cres.get().getString("statisticsServerConnectionHelpOutgoing") + "><E=" + "bytes" + ">");
        FORMAT.addField("<unrepliedCommandCount><L><D=" + Cres.get().getString("commUnrepliedCommandCount") + "><H=" + Cres.get().getString("statisticsServerConnectionHelpUnreplied") + ">");
    }
}

