/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.communication;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.communication.AbstractCommandParser;
import com.tibbo.aggregate.common.communication.Command;
import com.tibbo.aggregate.common.communication.CommandParserListener;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.util.WatchdogHolder;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public abstract class BufferedCommandParser<C extends Command>
extends AbstractCommandParser<C> {
    private static final int BUFFER_SIZE = 1024;
    protected final ByteBuffer buffer = ByteBuffer.allocate(1024);
    protected ReadableByteChannel channel;

    public BufferedCommandParser(ReadableByteChannel channel) {
        this.channel = channel;
        this.buffer.flip();
    }

    protected boolean commandCompleted() {
        while (this.buffer.hasRemaining()) {
            try {
                byte cur = this.buffer.get();
                if (!this.commandEnded(cur)) continue;
                return true;
            }
            catch (BufferUnderflowException ex) {
                Log.COMMANDS.debug((Object)("Buffer underflow error in " + this.toString()), (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public C readCommand() throws IOException, DisconnectionException, SyntaxErrorException {
        int read;
        block3: {
            if (this.commandCompleted()) {
                return this.buildCommand();
            }
            do {
                this.buffer.clear();
                WatchdogHolder.getInstance().awaitForEnoughMemory();
                read = this.getChannel().read(this.buffer);
                this.buffer.flip();
                if (read <= 0) break block3;
                CommandParserListener listener = this.getListener();
                if (listener == null) continue;
                listener.newDataReceived();
            } while (!this.commandCompleted());
            return this.buildCommand();
        }
        if (read == -1) {
            this.getChannel().close();
            throw new DisconnectionException(Cres.get().getString("disconnected"));
        }
        return this.buildCommand();
    }

    protected abstract C buildCommand() throws SyntaxErrorException;

    protected abstract boolean commandEnded(byte var1);

    public ReadableByteChannel getChannel() {
        return this.channel;
    }
}

