/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.communication;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.communication.AbstractDeviceController;
import com.tibbo.aggregate.common.communication.Command;
import com.tibbo.aggregate.common.communication.CommandProcessorStatistics;
import com.tibbo.aggregate.common.communication.ReplyMonitor;
import com.tibbo.aggregate.common.communication.SendersPool;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ClosedByInterruptException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class AsyncCommandProcessor<I extends Command, O extends Command, C extends AbstractDeviceController<I, O>>
extends Thread {
    private static final long PENDING_COMMAND_TIMEOUT = 86400000L;
    private final C controller;
    private final ConcurrentLinkedQueue<ReplyMonitor<O, I>> sentCommandsQueue = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<String, ReplyMonitor<O, I>> sentCommandsMap = new ConcurrentHashMap();
    private final Object commandQueueMonitor = new Object();
    private final CommandProcessorStatistics statistics = new CommandProcessorStatistics();

    public AsyncCommandProcessor(C controller) {
        this.controller = controller;
        this.setName("AsyncCommandProcessor/" + controller.toString() + "/" + this.getName());
    }

    public I sendSyncCommand(O cmd) throws DisconnectionException, IOException, InterruptedException {
        if (Log.COMMANDS.isDebugEnabled() && SwingUtilities.isEventDispatchThread()) {
            Log.COMMANDS.debug((Object)"Device I/O from event dispatch thread", (Throwable)new Exception());
        }
        ReplyMonitor mon = this.sendCommand(cmd);
        if (((Command)cmd).isAsync()) {
            return null;
        }
        I reply = this.waitReplyMonitor(mon);
        this.statistics.updateOnSyncCommand(mon);
        return reply;
    }

    public void sendUnrepliedCommand(O cmd) throws DisconnectionException, IOException {
        this.sendCommandImplementation(cmd);
        if (((AbstractDeviceController)this.controller).getLogger() != null && ((AbstractDeviceController)this.controller).getLogger().isDebugEnabled()) {
            ((AbstractDeviceController)this.controller).getLogger().debug((Object)("Sent command: " + StringUtils.toHexString(((ByteArrayOutputStream)cmd).toByteArray())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSentCommandTimeouts() {
        Object object = this.commandQueueMonitor;
        synchronized (object) {
            this.sentCommandsMap.forEach((s, cur) -> cur.reset());
            this.sentCommandsQueue.forEach((Consumer<ReplyMonitor<O, I>>)((Consumer<ReplyMonitor>)ReplyMonitor::reset));
        }
    }

    private void sendCommandImplementation(O cmd) throws DisconnectionException, IOException {
        try {
            ((AbstractDeviceController)this.controller).send(cmd);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ReplyMonitor sendCommand(O cmd) throws DisconnectionException, IOException, InterruptedException {
        if (!this.isAlive()) {
            Object object = this.commandQueueMonitor;
            synchronized (object) {
                this.sentCommandsMap.forEach((s, cur) -> cur.setReply(null));
                this.sentCommandsQueue.forEach((Consumer<ReplyMonitor<O, I>>)((Consumer<ReplyMonitor>)cur -> cur.setReply(null)));
            }
            throw new DisconnectionException(Cres.get().getString("disconnected"));
        }
        final ReplyMonitor mon = new ReplyMonitor(cmd);
        Future future = SendersPool.get().submit(new Callable((Command)cmd){
            final /* synthetic */ Command val$cmd;
            {
                this.val$cmd = command;
            }

            public Throwable call() throws Exception {
                try {
                    AsyncCommandProcessor.this.addSentCommand(mon);
                    AsyncCommandProcessor.this.sendUnrepliedCommand(this.val$cmd);
                    return null;
                }
                catch (Throwable ex) {
                    return ex;
                }
            }
        });
        try {
            Throwable th = (Throwable)future.get();
            if (th == null) {
                return mon;
            }
            if (th instanceof DisconnectionException) {
                throw (DisconnectionException)th;
            }
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof InterruptedException) {
                throw (InterruptedException)th;
            }
            throw new IOException(th.getMessage(), th);
        }
        catch (ExecutionException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private I waitReplyMonitor(ReplyMonitor<O, I> mon) throws IOException, InterruptedException {
        String id;
        if (mon.getReply() == null) {
            long timeout = ((Command)mon.getCommand()).getTimeout() != null ? ((Command)mon.getCommand()).getTimeout().longValue() : ((AbstractDeviceController)this.controller).getCommandTimeout();
            mon.waitReply(timeout);
        }
        if ((id = ((Command)mon.getCommand()).getId()) != null) {
            this.sentCommandsMap.remove(id);
        } else {
            this.sentCommandsQueue.remove(mon);
        }
        if (mon.getReply() != null) {
            return mon.getReply();
        }
        if (Log.COMMANDS.isDebugEnabled()) {
            throw new IOException(MessageFormat.format(Cres.get().getString("cmdTimeout"), mon.getCommand()));
        }
        throw new IOException(MessageFormat.format(Cres.get().getString("cmdTimeout"), id));
    }

    private void addSentCommand(ReplyMonitor<O, I> mon) {
        String id = ((Command)mon.getCommand()).getId();
        if (id == null) {
            this.sentCommandsQueue.add(mon);
        } else {
            this.sentCommandsMap.put(id, mon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                Object cmd = ((AbstractDeviceController)this.controller).getCommandParser().readCommand();
                if (cmd == null) continue;
                if (((AbstractDeviceController)this.controller).getLogger() != null && ((AbstractDeviceController)this.controller).getLogger().isDebugEnabled()) {
                    ((AbstractDeviceController)this.controller).getLogger().debug((Object)("Received command: " + StringUtils.toHexString(((ByteArrayOutputStream)cmd).toByteArray())));
                }
                if (((Command)cmd).isAsync()) {
                    ((AbstractDeviceController)this.controller).processAsyncCommand(cmd);
                    this.statistics.updateOnAsyncCommand((Command)cmd);
                    continue;
                }
                String commandId = ((Command)cmd).getId();
                ReplyMonitor<O, I> replyMonitor = commandId != null ? this.sentCommandsMap.remove(commandId) : this.sentCommandsQueue.poll();
                if (replyMonitor != null) {
                    ReplyMonitor<O, I> replyMonitor2 = replyMonitor;
                    synchronized (replyMonitor2) {
                        replyMonitor.setReply(cmd);
                    }
                } else if (((AbstractDeviceController)this.controller).getLogger() != null && ((AbstractDeviceController)this.controller).getLogger().isDebugEnabled()) {
                    ((AbstractDeviceController)this.controller).getLogger().debug((Object)("Reply cannot be matched to a sent command: " + (commandId == null ? "commands queue is empty" : "Command Id: " + commandId + ", commands in progress: " + this.sentCommandsMap.size())));
                }
                this.removeExpiredCommands();
            }
            ((AbstractDeviceController)this.controller).disconnectImpl();
        }
        catch (DisconnectionException ex) {
            this.processError(Level.DEBUG, "Disconnection of peer detected in async processor", ex);
        }
        catch (ClosedByInterruptException ex) {
            this.processError(Level.DEBUG, "Async processor interrupted", ex);
        }
        catch (SocketException ex) {
            this.processError(Level.DEBUG, "Socket error in async processor", ex);
        }
        catch (SSLException ex) {
            this.processError(Level.DEBUG, "SSL error in async processor", ex);
        }
        catch (Exception ex) {
            this.processError(Level.ERROR, "Error in async processor", ex);
        }
        finally {
            this.sentCommandsQueue.forEach((Consumer<ReplyMonitor<O, I>>)((Consumer<ReplyMonitor>)ReplyMonitor::terminate));
            this.sentCommandsQueue.clear();
            this.sentCommandsMap.values().forEach(ReplyMonitor::terminate);
            this.sentCommandsMap.clear();
        }
    }

    private void removeExpiredCommands() {
        this.sentCommandsMap.entrySet().removeIf(entry -> this.isExpired((ReplyMonitor)entry.getValue()));
        this.sentCommandsQueue.removeIf(this::isExpired);
    }

    private boolean isExpired(ReplyMonitor<O, I> oiReplyMonitor) {
        long thisTime = System.currentTimeMillis();
        if (thisTime - oiReplyMonitor.getTime() > 86400000L) {
            if (((AbstractDeviceController)this.controller).getLogger() != null && ((AbstractDeviceController)this.controller).getLogger().isInfoEnabled()) {
                ((AbstractDeviceController)this.controller).getLogger().info((Object)("Removing expired reply monitor: " + oiReplyMonitor));
            }
            return true;
        }
        return false;
    }

    private void processError(Level priority, String message, Exception ex) {
        if (((AbstractDeviceController)this.controller).getLogger() != null) {
            ((AbstractDeviceController)this.controller).getLogger().log((Priority)priority, (Object)(message + ": " + ex));
        }
        try {
            ((AbstractDeviceController)this.controller).disconnectImpl();
        }
        catch (Exception ex1) {
            ((AbstractDeviceController)this.controller).getLogger().error((Object)"Disconnection error", (Throwable)ex1);
        }
    }

    public boolean isActive() {
        return !this.sentCommandsQueue.isEmpty() || !this.sentCommandsMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplyMonitor<O, I>> getActiveCommands() {
        LinkedList<ReplyMonitor<O, I>> res = new LinkedList<ReplyMonitor<O, I>>();
        Object object = this.commandQueueMonitor;
        synchronized (object) {
            res.addAll(this.sentCommandsMap.values());
            res.addAll(this.sentCommandsQueue);
        }
        return res;
    }

    @Override
    public void interrupt() {
        Log.CORE_THREAD.debug((Object)("Thread '" + this.getName() + "' is interrupted by '" + Thread.currentThread().getName() + "'"));
        super.interrupt();
    }

    public C getController() {
        return this.controller;
    }

    public CommandProcessorStatistics getStatistics() {
        return this.statistics;
    }
}

