/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.communication;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.communication.AsyncCommandProcessor;
import com.tibbo.aggregate.common.communication.Command;
import com.tibbo.aggregate.common.communication.CommandParser;
import com.tibbo.aggregate.common.communication.CommandParserListener;
import com.tibbo.aggregate.common.communication.CommandProcessorStatistics;
import com.tibbo.aggregate.common.communication.ReplyMonitor;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.RemoteDeviceErrorException;
import com.tibbo.aggregate.common.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractDeviceController<I extends Command, O extends Command>
implements CommandParserListener {
    private long commandTimeout;
    private boolean resetTimeoutsOnData;
    private final Logger logger;
    private CommandParser<I> commandParser;
    private volatile AsyncCommandProcessor<I, O, AbstractDeviceController<I, O>> processor;
    private final Lock connectLock = new ReentrantLock();
    private volatile boolean connecting;
    private volatile boolean connected = false;
    private final Lock loginLock = new ReentrantLock();
    private boolean loggingIn;
    private boolean loggedIn = false;

    public AbstractDeviceController(long commandTimeout, Logger logger) {
        this.commandTimeout = commandTimeout;
        this.logger = logger;
    }

    protected abstract boolean connectImpl() throws DisconnectionException, IOException, InterruptedException, RemoteDeviceErrorException, ContextException;

    protected abstract boolean loginImpl() throws ContextException;

    protected abstract void disconnectImpl() throws IOException, InterruptedException, RemoteDeviceErrorException;

    protected abstract void send(O var1) throws DisconnectionException, IOException, InterruptedException;

    public void connect() throws DisconnectionException, IOException, InterruptedException, RemoteDeviceErrorException, ContextException {
        if (this.isConnected() || this.connecting) {
            return;
        }
        if (!this.connectLock.tryLock()) {
            return;
        }
        try {
            try {
                this.connecting = true;
                if (this.connectImpl()) {
                    this.setConnected(true);
                }
            }
            finally {
                this.connecting = false;
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    protected void checkAndConnect() throws DisconnectionException, IOException, InterruptedException, RemoteDeviceErrorException, ContextException {
        if (SwingUtilities.isEventDispatchThread() && this.logger != null) {
            this.logger.debug((Object)"Net I/O from event dispatcher thread", (Throwable)new Exception());
        }
        this.connect();
    }

    public void login() throws ContextException {
        this.loginLock.lock();
        try {
            if (this.isLoggedIn() || this.loggingIn) {
                return;
            }
            try {
                this.loggingIn = true;
                if (this.loginImpl()) {
                    this.setLoggedIn(true);
                }
            }
            finally {
                this.loggingIn = false;
            }
        }
        finally {
            this.loginLock.unlock();
        }
    }

    public synchronized void disconnect() throws IOException, InterruptedException, RemoteDeviceErrorException {
        if (this.processor != null && !this.processor.isInterrupted()) {
            this.processor.interrupt();
            this.processor.join();
        }
        this.setLoggedIn(false);
        this.setConnected(false);
    }

    public I sendCommand(O cmd) throws DisconnectionException, IOException, InterruptedException, RemoteDeviceErrorException, ContextException {
        I reply;
        this.checkAndConnect();
        try {
            reply = this.processor.sendSyncCommand(cmd);
        }
        catch (DisconnectionException ex) {
            this.setLoggedIn(false);
            this.setConnected(false);
            throw ex;
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Received reply: " + (reply != null ? StringUtils.toHexString(((ByteArrayOutputStream)reply).toByteArray()) : "null") + " to command: " + (cmd != null ? StringUtils.toHexString(((ByteArrayOutputStream)cmd).toByteArray()) : "null")));
        }
        return reply;
    }

    public boolean isActive() {
        if (this.connecting || this.loggingIn) {
            return true;
        }
        if (this.processor != null) {
            return this.processor.isActive();
        }
        return false;
    }

    protected void processAsyncCommand(I cmd) {
        if (this.logger != null && this.logger.isInfoEnabled()) {
            Log.COMMANDS.info((Object)("Received async command: " + cmd));
        }
    }

    @Override
    public void newDataReceived() {
        if (this.resetTimeoutsOnData) {
            this.resetCommandTimeouts();
        }
    }

    protected void resetCommandTimeouts() {
        this.processor.resetSentCommandTimeouts();
    }

    protected void startCommandProcessor() {
        this.processor = new AsyncCommandProcessor(this);
        this.processor.start();
    }

    protected void setCommandParser(CommandParser commandParser) {
        this.commandParser = commandParser;
        commandParser.setListener(this);
        this.startCommandProcessor();
    }

    public boolean isConnected() {
        return this.connected && (this.processor == null || this.processor.isAlive());
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isLoggedIn() {
        return this.isConnected() && this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    protected CommandParser<I> getCommandParser() {
        return this.commandParser;
    }

    public void setResetTimeoutsOnData(boolean resetTimeoutWhenDataReceived) {
        this.resetTimeoutsOnData = resetTimeoutWhenDataReceived;
    }

    public List<ReplyMonitor<O, I>> getActiveCommands() {
        return this.processor != null ? this.processor.getActiveCommands() : new LinkedList();
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setCommandTimeout(long commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CommandProcessorStatistics getStatistics() {
        return this.processor != null ? this.processor.getStatistics() : null;
    }
}

