/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.communication;

import com.tibbo.aggregate.common.communication.Command;
import com.tibbo.aggregate.common.communication.CommandParser;
import com.tibbo.aggregate.common.communication.CommandParserListener;
import java.io.ByteArrayOutputStream;

public abstract class AbstractCommandParser<C extends Command>
implements CommandParser<C> {
    private static final int DEFAULT_SIZE = 1024;
    private ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
    private CommandParserListener listener;

    @Override
    public void reset() {
        if (this.data != null) {
            this.data.reset();
        }
    }

    public byte[] getData() {
        return this.data.toByteArray();
    }

    public byte[] clearData() {
        byte[] dataArray = this.data.toByteArray();
        this.data = new ByteArrayOutputStream(1024);
        return dataArray;
    }

    @Override
    public void addData(int dataByte) {
        this.data.write(dataByte);
    }

    @Override
    public void setListener(CommandParserListener listener) {
        this.listener = listener;
    }

    protected CommandParserListener getListener() {
        return this.listener;
    }

    public String toString() {
        return this.data.toString();
    }
}

