/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.binding;

import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.EvaluationOptions;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.ParsedExpressionCache;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.parser.ASTStart;
import com.tibbo.aggregate.common.expression.util.ReferencesFinderVisitor;
import com.tibbo.aggregate.common.util.PublicCloneable;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ExtendedBinding
implements Cloneable,
PublicCloneable {
    private Binding binding;
    private EvaluationOptions evaluationOptions;
    private String cachedExpression;
    private ASTStart cachedRootNode;

    public ExtendedBinding(Binding binding, EvaluationOptions evaluationOptions) {
        this.binding = binding;
        this.evaluationOptions = evaluationOptions;
    }

    @Override
    public ExtendedBinding clone() {
        try {
            ExtendedBinding clone = (ExtendedBinding)super.clone();
            clone.binding = this.binding.clone();
            clone.evaluationOptions = this.evaluationOptions.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public String toString() {
        return "ExtendedBinding [binding=" + this.binding + "]";
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public EvaluationOptions getEvaluationOptions() {
        return this.evaluationOptions;
    }

    public void setEvaluationOptions(EvaluationOptions evaluationOptions) {
        this.evaluationOptions = evaluationOptions;
    }

    public Collection<Reference> getAllReferences() throws SyntaxErrorException {
        ArrayList<Reference> allReferences = new ArrayList<Reference>();
        if (this.binding.getTarget() != null) {
            allReferences.add(this.binding.getTarget());
        }
        if (this.getEvaluationOptions().getActivator() != null) {
            allReferences.add(this.getEvaluationOptions().getActivator());
        }
        allReferences.addAll(this.findExpressionReferences());
        return allReferences;
    }

    private List<Reference> findExpressionReferences() throws SyntaxErrorException {
        boolean notCachedYet;
        List result = Collections.emptyList();
        Expression expression = this.binding.getExpression();
        if (expression == null) {
            return result;
        }
        boolean bl = notCachedYet = !Util.equals(expression.getText(), this.cachedExpression);
        if (notCachedYet) {
            this.cachedExpression = expression.getText();
            this.cachedRootNode = ParsedExpressionCache.getCachedAstRoot(this.cachedExpression);
        }
        if (this.cachedRootNode != null) {
            ReferencesFinderVisitor visitor = new ReferencesFinderVisitor();
            this.cachedRootNode.jjtAccept(visitor, null);
            result = visitor.getIdentifiers();
        }
        return result;
    }

    public String displayString() {
        return this.binding.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedBinding that = (ExtendedBinding)o;
        if (!this.binding.equals(that.binding)) {
            return false;
        }
        return this.evaluationOptions.equals(that.evaluationOptions);
    }

    public int hashCode() {
        int result = this.binding.hashCode();
        result = 31 * result + this.evaluationOptions.hashCode();
        return result;
    }
}

