/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.binding;

import com.google.common.base.Preconditions;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.ReferenceResolver;
import com.tibbo.aggregate.common.structure.Pinpoint;
import com.tibbo.aggregate.common.structure.PinpointAware;
import com.tibbo.aggregate.common.util.PublicCloneable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class EvaluationOptions
implements Cloneable,
PublicCloneable,
PinpointAware {
    public static final int STARTUP = 1;
    public static final int EVENT = 2;
    public static final int PERIODIC = 4;
    public static final int TEST = 8;
    private int pattern;
    private long period = 0L;
    private Reference activator;
    private Expression condition;
    @Nullable
    private ReferenceResolver customDefaultReferenceResolver;
    @Nullable
    private Pinpoint pinpoint;

    public EvaluationOptions() {
        this(1);
    }

    public EvaluationOptions(boolean startup, boolean event) {
        this(startup, event, 0L);
    }

    public EvaluationOptions(boolean startup, boolean event, long period) {
        if (startup) {
            this.pattern |= 1;
        }
        if (event) {
            this.pattern |= 2;
        }
        if (period > 0L) {
            this.pattern |= 4;
            this.period = period;
        }
    }

    public EvaluationOptions(int pattern) {
        this.pattern = pattern;
    }

    public EvaluationOptions(boolean startup, String activator, String condition) {
        this(startup, activator);
        this.condition = new Expression(condition);
    }

    public EvaluationOptions(boolean startup, String activator) {
        if (startup) {
            this.pattern |= 1;
        }
        this.pattern |= 2;
        this.setActivator(new Reference(activator));
    }

    public int getPattern() {
        return this.pattern;
    }

    public long getPeriod() {
        return this.period;
    }

    public Reference getActivator() {
        return this.activator;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setPattern(int pattern) {
        this.pattern = pattern;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public void setActivator(Reference activator) {
        this.activator = activator;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public boolean isProcessOnStartup() {
        return (this.pattern & 1) > 0;
    }

    public boolean isProcessOnEvent() {
        return (this.pattern & 2) > 0;
    }

    public boolean isProcessPeriodically() {
        return (this.pattern & 4) > 0;
    }

    @Nullable
    public ReferenceResolver getCustomDefaultReferenceResolver() {
        return this.customDefaultReferenceResolver;
    }

    public void setCustomDefaultReferenceResolver(@Nullable ReferenceResolver customDefaultReferenceResolver) {
        this.customDefaultReferenceResolver = customDefaultReferenceResolver;
    }

    @Override
    public EvaluationOptions clone() {
        try {
            EvaluationOptions clone = (EvaluationOptions)super.clone();
            if (this.activator != null) {
                clone.activator = this.activator.clone();
            }
            if (this.condition != null) {
                clone.condition = this.condition.clone();
            }
            if (this.pinpoint != null) {
                clone.pinpoint = this.pinpoint.copy();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationOptions that = (EvaluationOptions)o;
        if (this.pattern != that.pattern) {
            return false;
        }
        if (this.period != that.period) {
            return false;
        }
        if (!Objects.equals(this.activator, that.activator)) {
            return false;
        }
        return Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        int result = this.pattern;
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        result = 31 * result + (this.activator != null ? this.activator.hashCode() : 0);
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        return result;
    }

    public String toString() {
        return (this.isProcessOnStartup() ? "1" : "0") + (this.isProcessOnEvent() ? "1" : "0") + (this.isProcessPeriodically() ? "1" : "0") + (this.isProcessPeriodically() ? ", period=" + this.period : "") + ", activator=" + this.activator + ", condition=" + this.condition + (this.customDefaultReferenceResolver != null ? ", resolver=" + this.customDefaultReferenceResolver : "");
    }

    @Override
    public void assignPinpoint(Pinpoint pinpoint) throws IllegalStateException {
        Preconditions.checkState((this.pinpoint == null ? 1 : 0) != 0, (String)"This '%s' already contains pinpoint '%s' but somebody attempted to assign another one: '%s'", (Object)this, (Object)this.pinpoint, (Object)pinpoint);
        this.pinpoint = pinpoint;
    }

    @Override
    public Optional<Pinpoint> obtainPinpoint() {
        return Optional.ofNullable(this.pinpoint);
    }
}

