/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.binding;

import com.google.common.annotations.VisibleForTesting;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.BindingException;
import com.tibbo.aggregate.common.binding.BindingProcessor;
import com.tibbo.aggregate.common.binding.BindingProvider;
import com.tibbo.aggregate.common.binding.ChangeCache;
import com.tibbo.aggregate.common.binding.EvaluationOptions;
import com.tibbo.aggregate.common.binding.ReferenceListener;
import com.tibbo.aggregate.common.binding.TimerFactory;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.ReferenceResolver;
import com.tibbo.aggregate.common.structure.OriginKind;
import com.tibbo.aggregate.common.structure.Pinpoint;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.util.Util;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class DefaultBindingProcessor
implements BindingProcessor {
    private final BindingProvider provider;
    private final Evaluator evaluator;
    private volatile boolean bufferingEventBindings = false;
    private Timer timer;
    private TimerFactory timerFactory;
    private ExecutorService executionService;
    private boolean disableStartupConcurrency;
    private boolean shareTimer;
    private boolean shareConcurrency;
    private final List<ReferenceListener> listeners = new LinkedList<ReferenceListener>();
    private final List<TimerTask> timerTasks = new LinkedList<TimerTask>();
    private final Set<Future> tasks = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private boolean stopped;
    private boolean enabled = true;
    private final CountDownLatch bindingProcessorLatch;
    private final AtomicInteger unevaluatedStartupBindingsCount = new AtomicInteger();
    private int initialStartupBindingsCount;
    private long evaluationStartTime;
    @Nullable
    private BiConsumer<Integer, Long> startupBindingsEvaluatedCallback;
    private Map<Binding, EvaluationOptions> bindings;
    private final Queue<Callable<Void>> onEventTasksBuffer = new ConcurrentLinkedQueue<Callable<Void>>();

    public DefaultBindingProcessor(BindingProvider provider, Evaluator evaluator) {
        this.provider = provider;
        this.evaluator = evaluator;
        this.bindingProcessorLatch = new CountDownLatch(1);
    }

    public DefaultBindingProcessor(BindingProvider provider, Evaluator evaluator, ExecutorService executionService) {
        this(provider, evaluator);
        this.executionService = executionService;
    }

    public DefaultBindingProcessor(BindingProvider provider, Evaluator evaluator, Timer timer, ExecutorService executionService) {
        this(provider, evaluator);
        this.executionService = executionService;
        this.timer = timer;
        this.shareTimer = true;
        this.shareConcurrency = true;
    }

    public DefaultBindingProcessor(BindingProvider provider, Evaluator evaluator, TimerFactory timerFactory, ExecutorService executionService) {
        this(provider, evaluator);
        this.executionService = executionService;
        this.timerFactory = timerFactory;
        this.shareTimer = true;
        this.shareConcurrency = true;
    }

    public DefaultBindingProcessor(BindingProvider provider, Evaluator evaluator, Timer timer, ExecutorService executionService, boolean bufferingEventBindings) {
        this(provider, evaluator);
        this.executionService = executionService;
        this.timer = timer;
        this.bufferingEventBindings = bufferingEventBindings;
        this.shareTimer = true;
        this.shareConcurrency = true;
    }

    @Override
    public boolean start() {
        this.start(this.executionService != null && !this.disableStartupConcurrency);
        return !this.stopped;
    }

    protected void start(boolean concurrentProcessing) {
        if (this.stopped) {
            throw new IllegalStateException("Cannot reuse binding processor");
        }
        Callable<Object> task = () -> {
            this.startImpl(concurrentProcessing);
            this.bindingProcessorLatch.countDown();
            return null;
        };
        if (!concurrentProcessing) {
            try {
                task.call();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        } else {
            this.submit(task);
        }
    }

    protected void startImpl(boolean concurrentProcessing) {
        this.bindings = this.provider.createBindings();
        this.initAllBindings(concurrentProcessing);
        if (this.stopped) {
            return;
        }
        this.provider.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public synchronized void stop() {
        this.bindingProcessorLatch.countDown();
        this.bufferingEventBindings = false;
        this.onEventTasksBuffer.clear();
        Log.BINDINGS.debug((Object)"Buffer was vanished due stop of binding processor");
        this.stopped = true;
        if (this.shareTimer) {
            var1_1 = this.timerTasks;
            synchronized (var1_1) {
                for (TimerTask task : this.timerTasks) {
                    task.cancel();
                }
            }
        } else if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.shareConcurrency) {
            for (Future future : this.tasks) {
                future.cancel(true);
            }
        } else if (this.executionService != null) {
            var1_1 = this.executionService;
            synchronized (var1_1) {
                this.executionService.shutdownNow();
            }
            try {
                if (this.executionService.awaitTermination(10000L, TimeUnit.MILLISECONDS)) ** GOTO lbl41
                Log.BINDINGS.warn((Object)"Execution service didn't terminate in time");
            }
            catch (InterruptedException ex) {
                Log.BINDINGS.debug((Object)"Interrupted during execution service termination");
                this.executionService.shutdown();
            }
        }
lbl41:
        // 6 sources

        var1_1 = this.listeners;
        synchronized (var1_1) {
            for (ReferenceListener listener : this.listeners) {
                this.provider.removeReferenceListener(listener);
            }
        }
        this.provider.stop();
    }

    @VisibleForTesting
    public void evaluateBindingExpression(int method, Binding binding, EvaluationOptions options) throws EvaluationException, SyntaxErrorException, BindingException {
        this.evaluateBindingExpression(method, binding, options, new EvaluationEnvironment(), null, null);
    }

    protected void evaluateBindingExpression(int method, Binding binding, EvaluationOptions options, EvaluationEnvironment evaluationEnvironment, Reference cause, ChangeCache cache) throws EvaluationException, SyntaxErrorException, BindingException {
        ReferenceResolver customDefaultReferenceResolver = options.getCustomDefaultReferenceResolver();
        if (customDefaultReferenceResolver != null) {
            evaluationEnvironment.addCustomDefaultResolver(customDefaultReferenceResolver);
        }
        if (this.checkCondition(options, evaluationEnvironment, this.evaluator)) {
            options.obtainPinpoint().ifPresent(pinpoint -> evaluationEnvironment.assignPinpoint(pinpoint.withOriginField("expression", OriginKind.EXPRESSION)));
            Pinpoint targetPinpoint = options.obtainPinpoint().map(pinpoint -> pinpoint.withOriginField("target", OriginKind.REFERENCE)).orElse(null);
            Object result = this.evaluator.evaluate(binding.getExpression(), evaluationEnvironment);
            this.provider.processExecution(method, binding, options, cause, result);
            this.writeReference(method, binding, cause, result, cache, targetPinpoint);
        } else if (method == 1) {
            Log.BINDINGS.debug((Object)("Condition '" + options.getCondition() + "' is false for binding: " + binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initBinding(Binding binding, EvaluationOptions options) {
        block15: {
            try {
                if (this.stopped) {
                    return;
                }
                Log.BINDINGS.debug((Object)("Initializing binding: " + binding + ", evaluation options: " + options));
                if ((options.getPattern() & 2) != 0) {
                    if (options.getActivator() != null) {
                        try {
                            this.addReferenceListener(binding, options, options.getActivator());
                        }
                        catch (Exception ex) {
                            this.provider.processError(binding, 2, options.getActivator(), ex);
                        }
                    } else {
                        List<Reference> identifiers = this.provider.getReferences(binding);
                        LinkedList<Reference> added = new LinkedList<Reference>();
                        for (Reference ref : identifiers) {
                            try {
                                if (!added.contains(ref)) {
                                    this.addReferenceListener(binding, options, ref);
                                    added.add(ref);
                                    continue;
                                }
                                Log.BINDINGS.debug((Object)("Adding reference listener was skipped; reference: " + ref + "; binding: " + binding));
                            }
                            catch (Exception ex) {
                                this.provider.processError(binding, 2, ref, ex);
                            }
                        }
                    }
                }
                if ((options.getPattern() & 4) == 0 || options.getPeriod() <= 0L) break block15;
                this.ensureTimer();
                if (this.stopped) break block15;
                EvaluationTimerTask task = new EvaluationTimerTask(binding, options);
                this.timer.schedule((TimerTask)task, options.getPeriod(), options.getPeriod());
                if (!this.shareTimer) break block15;
                DefaultBindingProcessor defaultBindingProcessor = this;
                synchronized (defaultBindingProcessor) {
                    this.timerTasks.add(task);
                }
            }
            catch (Exception ex) {
                Log.BINDINGS.warn((Object)("Error initializing binding: " + binding), (Throwable)ex);
            }
        }
    }

    private void initAllBindings(boolean concurrentProcessing) {
        this.initEventBindings();
        this.evaluateStartupBindings(concurrentProcessing);
    }

    public void processPendingEventBindings() {
        this.bufferingEventBindings = false;
        Log.BINDINGS.debug((Object)MessageFormat.format("Attempt to process {0} tasks from buffer...", this.onEventTasksBuffer.size()));
        this.onEventTasksBuffer.forEach(task -> {
            try {
                this.submit((Callable)task);
            }
            catch (Exception ex) {
                Log.BINDINGS.warn((Object)"Error processing event binding", (Throwable)ex);
            }
        });
        this.onEventTasksBuffer.clear();
        Log.BINDINGS.debug((Object)"Buffer was processed");
    }

    public void initEventBindings() {
        for (Binding bin : this.bindings.keySet()) {
            this.initBinding(bin, this.bindings.get(bin));
        }
    }

    private void evaluateStartupBindings(boolean concurrentProcessing) {
        if (this.stopped || !this.enabled) {
            return;
        }
        this.evaluationStartTime = System.currentTimeMillis();
        this.initialStartupBindingsCount = this.countStartupBindings();
        if (this.initialStartupBindingsCount == 0) {
            Log.BINDINGS.debug((Object)"No startup bindings found for current processor");
            if (this.startupBindingsEvaluatedCallback != null) {
                long evaluationTime = System.currentTimeMillis() - this.evaluationStartTime;
                this.startupBindingsEvaluatedCallback.accept(this.initialStartupBindingsCount, evaluationTime);
            }
            return;
        }
        this.unevaluatedStartupBindingsCount.set(this.initialStartupBindingsCount);
        for (Binding binding : this.bindings.keySet()) {
            EvaluationOptions options = this.bindings.get(binding);
            if (!this.enabled || (options.getPattern() & 1) == 0) continue;
            if (this.executionService != null && concurrentProcessing) {
                try {
                    this.submit(() -> {
                        this.evaluateStartupBinding(binding, options);
                        return null;
                    });
                }
                catch (Exception ex) {
                    this.provider.processError(binding, 1, null, new BindingException(Cres.get().getString("binBindingQueueOverflow"), ex));
                }
                continue;
            }
            this.evaluateStartupBinding(binding, options);
        }
    }

    private int countStartupBindings() {
        int count = 0;
        for (Binding binding : this.bindings.keySet()) {
            if ((this.bindings.get(binding).getPattern() & 1) == 0) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateStartupBinding(Binding binding, EvaluationOptions options) {
        try {
            this.evaluateBindingExpression(1, binding, options);
        }
        catch (Exception ex) {
            this.provider.processError(binding, 1, null, ex);
        }
        finally {
            int current = this.unevaluatedStartupBindingsCount.decrementAndGet();
            if (current == 0 && this.startupBindingsEvaluatedCallback != null) {
                try {
                    long evaluationTime = System.currentTimeMillis() - this.evaluationStartTime;
                    this.startupBindingsEvaluatedCallback.accept(this.initialStartupBindingsCount, evaluationTime);
                }
                catch (Exception e) {
                    this.provider.processError(binding, 1, null, e);
                }
            }
        }
    }

    protected void ensureTimer() {
        if (this.timer == null) {
            this.timer = this.timerFactory != null ? this.timerFactory.createTimer() : new Timer("Timer/DefaultBindingProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReferenceListener(Binding binding, EvaluationOptions options, Reference reference) throws BindingException {
        if (this.stopped) {
            return;
        }
        BindingReferenceListener listener = new BindingReferenceListener(binding, options);
        this.provider.addReferenceListener(reference, listener);
        List<ReferenceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    private void writeReference(int method, Binding binding, Reference cause, Object value, ChangeCache cache, Pinpoint pinpoint) throws BindingException {
        if (this.stopped || !this.enabled) {
            return;
        }
        this.provider.writeReference(method, binding, cause, value, cache, pinpoint);
    }

    protected boolean checkCondition(EvaluationOptions options, EvaluationEnvironment evaluationEnvironment, Evaluator evaluator) throws BindingException {
        try {
            boolean conditionIsAbsent;
            boolean bl = conditionIsAbsent = options == null || options.getCondition() == null || options.getCondition().getText() == null || options.getCondition().getText().isEmpty();
            if (conditionIsAbsent) {
                boolean bl2 = true;
                return bl2;
            }
            options.obtainPinpoint().ifPresent(pinpoint -> evaluationEnvironment.assignPinpoint(pinpoint.withOriginField("condition", OriginKind.EXPRESSION)));
            Object condition = evaluator.evaluate(options.getCondition(), evaluationEnvironment);
            boolean bl3 = condition != null ? Util.convertToBoolean(condition, true, false) : true;
            return bl3;
        }
        catch (Exception e) {
            throw new BindingException(e.getMessage(), e);
        }
        finally {
            evaluationEnvironment.removePinpoint();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public void setStartupBindingsEvaluatedCallback(@Nullable BiConsumer<Integer, Long> startupBindingsEvaluatedCallback) {
        this.startupBindingsEvaluatedCallback = startupBindingsEvaluatedCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Callable task) {
        if (this.stopped || !this.enabled) {
            return;
        }
        if (this.executionService != null) {
            Future future;
            ExecutorService executorService = this.executionService;
            synchronized (executorService) {
                if (this.executionService.isShutdown()) {
                    return;
                }
                future = this.executionService.submit(task);
            }
            if (this.shareConcurrency) {
                this.tasks.add(future);
            }
        } else {
            try {
                task.call();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    public void setExecutionService(ExecutorService service) {
        if (this.executionService != null) {
            this.executionService.shutdown();
            try {
                this.executionService.awaitTermination(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Log.BINDINGS.warn((Object)"Error terminating bindings execution service", (Throwable)e);
            }
        }
        this.executionService = service;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executionService;
    }

    public BindingProvider getProvider() {
        return this.provider;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    public boolean isDisableStartupConcurrency() {
        return this.disableStartupConcurrency;
    }

    public void setDisableStartupConcurrency(boolean disableStartupConcurrency) {
        this.disableStartupConcurrency = disableStartupConcurrency;
    }

    public boolean awaitBindingsProcessorStart(long millis) {
        try {
            return this.bindingProcessorLatch.await(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Log.BINDINGS.error((Object)"Couldn't await CountDownLatch bindingsProcessor", (Throwable)ex);
            return false;
        }
    }

    private class BindingReferenceListener
    implements ReferenceListener<Object> {
        private final Binding binding;
        private Object content;
        private final EvaluationOptions options;

        public BindingReferenceListener(Binding binding, EvaluationOptions options) {
            this.binding = binding;
            this.options = options;
        }

        @Override
        public void referenceChanged(Reference cause, Map<String, Object> environment, ChangeCache cache) throws BindingException {
            this.referenceChanged(cause, environment, cache, null);
        }

        @Override
        public void referenceChanged(Reference cause, Map<String, Object> environment, ChangeCache cache, boolean asynchronousProcessing) throws BindingException {
            this.referenceChanged(cause, environment, cache, (Boolean)asynchronousProcessing);
        }

        private void referenceChanged(Reference cause, Map<String, Object> environment, ChangeCache cache, Boolean asynchronousProcessing) throws BindingException {
            if (DefaultBindingProcessor.this.stopped || !DefaultBindingProcessor.this.enabled) {
                return;
            }
            Callable<Void> task = () -> {
                try {
                    this.processReferenceChange(cause, environment, cache);
                }
                catch (BindingException ex) {
                    DefaultBindingProcessor.this.provider.processError(this.binding, 2, cause, ex);
                }
                return null;
            };
            if (DefaultBindingProcessor.this.bufferingEventBindings) {
                DefaultBindingProcessor.this.onEventTasksBuffer.add(task);
                return;
            }
            boolean async = DefaultBindingProcessor.this.executionService != null && (asynchronousProcessing == null || asynchronousProcessing != false);
            try {
                if (async) {
                    DefaultBindingProcessor.this.submit(task);
                } else {
                    task.call();
                }
            }
            catch (Exception ex) {
                DefaultBindingProcessor.this.provider.processError(this.binding, 2, null, new BindingException(Cres.get().getString("binBindingQueueOverflow"), ex));
            }
        }

        private void processReferenceChange(Reference cause, Map<String, Object> environment, ChangeCache cache) throws BindingException {
            if (DefaultBindingProcessor.this.stopped || !DefaultBindingProcessor.this.enabled) {
                return;
            }
            EvaluationEnvironment evaluationEnvironment = new EvaluationEnvironment(cause, environment);
            try {
                DefaultBindingProcessor.this.evaluateBindingExpression(2, this.binding, this.options, evaluationEnvironment, cause, cache);
            }
            catch (Exception ex) {
                throw new BindingException(ex.getMessage(), ex);
            }
        }

        @Override
        public Binding getBinding() {
            return this.binding;
        }

        @Override
        public void setContent(Object content) {
            this.content = content;
        }

        @Override
        public Object getContent() {
            return this.content;
        }

        @Override
        public BindingProcessor getBindingProcessor() {
            return DefaultBindingProcessor.this;
        }

        @Override
        public EvaluationOptions getEvaluationOptions() {
            return this.options;
        }

        public String toString() {
            return "[binding: " + this.binding + ", options: " + this.options + "]";
        }
    }

    private class EvaluationTimerTask
    extends TimerTask {
        private final Binding binding;
        private final EvaluationOptions options;

        public EvaluationTimerTask(Binding binding, EvaluationOptions options) {
            this.binding = binding;
            this.options = options;
        }

        @Override
        public void run() {
            Callable<Object> task = () -> {
                this.executeEvaluationTask();
                return null;
            };
            try {
                DefaultBindingProcessor.this.submit(task);
            }
            catch (Throwable ex) {
                DefaultBindingProcessor.this.provider.processError(this.binding, 4, null, new BindingException(Cres.get().getString("binBindingQueueOverflow"), ex));
            }
        }

        public void executeEvaluationTask() {
            if (DefaultBindingProcessor.this.stopped || !DefaultBindingProcessor.this.enabled) {
                return;
            }
            try {
                DefaultBindingProcessor.this.evaluateBindingExpression(4, this.binding, this.options);
            }
            catch (Exception ex) {
                DefaultBindingProcessor.this.provider.processError(this.binding, 4, null, ex);
            }
        }
    }

    public static class Builder {
        private final BindingProvider provider;
        private final Evaluator evaluator;
        private boolean bufferingEventBindings = false;
        private Timer timer;
        private ExecutorService executorService;

        public Builder(BindingProvider provider, Evaluator evaluator) {
            this.provider = provider;
            this.evaluator = evaluator;
        }

        public Builder bufferingEventBindings() {
            this.bufferingEventBindings = true;
            return this;
        }

        public DefaultBindingProcessor build() {
            return new DefaultBindingProcessor(this.provider, this.evaluator, this.timer, this.executorService, this.bufferingEventBindings);
        }

        public Builder withTimer(Timer timer) {
            this.timer = timer;
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }
    }
}

