/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.binding;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.BindingProvider;
import com.tibbo.aggregate.common.binding.CallerControllerSelector;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.DefaultRequestController;
import com.tibbo.aggregate.common.context.RequestController;
import com.tibbo.aggregate.common.datatable.DataTable;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class ChangeCache {
    private final Map<Context, Map<String, DataTable>> variableChanges = new Hashtable<Context, Map<String, DataTable>>();
    private final Map<Context, Map<String, RequestController>> requests = new HashMap<Context, Map<String, RequestController>>();
    private CountDownLatch cdl;

    public ChangeCache(int lockCounter) {
        this.cdl = new CountDownLatch(lockCounter);
        Log.BINDINGS.debug((Object)("ChangeCache created with counter " + lockCounter));
    }

    public ChangeCache() {
    }

    public void setVariableField(Context context, String variable, String field, int record, Object value, CallerController cc, DefaultRequestController request) throws ContextException {
        Map changes = this.variableChanges.computeIfAbsent(context, k -> new Hashtable());
        DataTable table = (DataTable)changes.get(variable);
        if (table == null) {
            table = context.getVariableClone(variable, cc);
            changes.put(variable, table);
        }
        table.getRecord(record).setValue(field, value);
        table.setTimestamp(new Date());
        this.requests.computeIfAbsent(context, k -> new HashMap()).put(variable, request);
    }

    public void commit(BindingProvider provider, CallerControllerSelector selector) {
        for (Map.Entry<Context, Map<String, DataTable>> conEntry : this.variableChanges.entrySet()) {
            for (Map.Entry<String, DataTable> varEntry : conEntry.getValue().entrySet()) {
                Context context = conEntry.getKey();
                String variableName = varEntry.getKey();
                try {
                    CallerController cc = selector.select(context, variableName, 1);
                    RequestController request = this.requests.get(context).get(variableName);
                    DataTable variableValue = varEntry.getValue();
                    context.setVariable(variableName, cc, request, variableValue);
                }
                catch (Exception ex) {
                    provider.processError(null, 2, null, ex);
                }
            }
        }
    }

    public void await() {
        try {
            if (this.cdl != null) {
                Log.BINDINGS.debug((Object)"ChangeCache await for lock counter");
                this.cdl.await();
            }
        }
        catch (InterruptedException ex) {
            Log.BINDINGS.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void countDown() {
        if (this.cdl != null) {
            Log.BINDINGS.debug((Object)"ChangeCache count down");
            this.cdl.countDown();
        }
    }
}

