/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.binding;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.EvaluationOptions;
import com.tibbo.aggregate.common.binding.ExtendedBinding;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.validator.LimitsValidator;
import com.tibbo.aggregate.common.datatable.validator.RegexValidator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;
import com.tibbo.aggregate.common.structure.Pinpoint;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

public class Bindings {
    public static final long DEFAULT_EVALUATION_PERIOD = 60000L;
    public static final String FIELD_BINDING_ID = "bindingId";
    public static final String FIELD_TARGET = "target";
    public static final String FIELD_EXPRESSION = "expression";
    public static final String FIELD_ACTIVATOR = "activator";
    public static final String FIELD_CONDITION = "condition";
    public static final String FIELD_ONSTARTUP = "onstartup";
    public static final String FIELD_ONEVENT = "onevent";
    public static final String FIELD_PERIODICALLY = "periodically";
    public static final String FIELD_PERIOD = "period";
    public static final String FIELD_QUEUE = "queue";
    public static final TableFormat FORMAT = new TableFormat();

    public static List<ExtendedBinding> bindingsFromDataTable(DataTable bindingsTable, @Nullable ExecutorService executorService) throws SyntaxErrorException {
        return Bindings.bindingsFromDataTable(bindingsTable, null, executorService);
    }

    public static List<ExtendedBinding> bindingsFromDataTable(DataTable bindingsTable, @Nullable Pinpoint pinpoint, @Nullable ExecutorService executorService) throws SyntaxErrorException {
        ConcurrentHashMap<Long, ExtendedBinding> bindingsById = new ConcurrentHashMap<Long, ExtendedBinding>();
        AtomicInteger bindingIndex = new AtomicInteger(0);
        ReentrantLock bindingsLock = new ReentrantLock();
        if (executorService != null) {
            CompletableFuture[] futures = new CompletableFuture[bindingsTable.getRecordCount().intValue()];
            for (int i = 0; i < bindingsTable.getRecordCount(); ++i) {
                CompletableFuture<Void> future;
                DataRecord rec = bindingsTable.getRecord(i);
                futures[i] = future = Bindings.scheduleBindingValidation(pinpoint, executorService, rec, bindingIndex, i, bindingsById, bindingsLock);
            }
            CompletableFuture.allOf(futures).join();
        } else {
            for (int i = 0; i < bindingsTable.getRecordCount(); ++i) {
                Bindings.processBinding(bindingsTable.getRecord(i), pinpoint, bindingIndex, i, bindingsById, bindingsLock);
            }
        }
        ArrayList<ExtendedBinding> result = new ArrayList<ExtendedBinding>(bindingsById.values());
        result.sort(Comparator.comparingInt(record -> record.getBinding().getRow()));
        return result;
    }

    private static CompletableFuture<Void> scheduleBindingValidation(@Nullable Pinpoint pinpoint, ExecutorService executorService, DataRecord rec, AtomicInteger bindingIndex, int rowIndex, ConcurrentHashMap<Long, ExtendedBinding> bindingsById, ReentrantLock bindingsLock) {
        Runnable bindingProcessingTask = () -> {
            try {
                Bindings.processBinding(rec, pinpoint, bindingIndex, rowIndex, bindingsById, bindingsLock);
            }
            catch (SyntaxErrorException ex) {
                Log.BINDINGS.warn((Object)Cres.get().getString("exprParseErr"));
                Log.BINDINGS.debug((Object)ex);
            }
        };
        return CompletableFuture.runAsync(bindingProcessingTask, executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processBinding(DataRecord bindingRecord, Pinpoint pinpoint, AtomicInteger bindingIndex, int rowIndex, ConcurrentHashMap<Long, ExtendedBinding> bindingsById, ReentrantLock bindingsLock) throws SyntaxErrorException {
        String queue;
        Long id;
        String cond;
        String act;
        String ri = bindingRecord.getString(FIELD_TARGET);
        if (ri == null) {
            ri = "";
        }
        Reference bRef = new Reference(ri);
        Expression bExp = new Expression(bindingRecord.getString(FIELD_EXPRESSION));
        ExpressionUtils.validateSyntax(bExp, true);
        Reference activator = null;
        if (bindingRecord.hasField(FIELD_ACTIVATOR) && (act = bindingRecord.getString(FIELD_ACTIVATOR)) != null && !act.isEmpty()) {
            activator = new Reference(act);
        }
        Expression condition = null;
        if (bindingRecord.hasField(FIELD_CONDITION) && (cond = bindingRecord.getString(FIELD_CONDITION)) != null && !cond.isEmpty()) {
            condition = new Expression(cond);
        }
        int pattern = 0;
        if (bindingRecord.hasField(FIELD_ONSTARTUP) && bindingRecord.getBoolean(FIELD_ONSTARTUP).booleanValue()) {
            pattern |= 1;
        }
        if (bindingRecord.hasField(FIELD_ONEVENT) && bindingRecord.getBoolean(FIELD_ONEVENT).booleanValue()) {
            pattern |= 2;
        }
        if (bindingRecord.hasField(FIELD_PERIODICALLY) && bindingRecord.getBoolean(FIELD_PERIODICALLY).booleanValue()) {
            pattern |= 4;
        }
        EvaluationOptions evalOpts = new EvaluationOptions(pattern);
        evalOpts.setActivator(activator);
        evalOpts.setCondition(condition);
        if (pinpoint != null) {
            evalOpts.assignPinpoint(pinpoint.withOriginRow(bindingIndex.getAndIncrement()));
        }
        long period = 0L;
        if (bindingRecord.hasField(FIELD_PERIOD)) {
            if (evalOpts.isProcessPeriodically()) {
                period = bindingRecord.getLong(FIELD_PERIOD);
            }
            if (period > 0L) {
                evalOpts.setPeriod(period);
            }
        }
        Binding bg = new Binding(bRef, bExp);
        bg.setRow(rowIndex);
        if (bindingRecord.hasField(FIELD_BINDING_ID)) {
            id = bindingRecord.getLong(FIELD_BINDING_ID);
            if (id == null) {
                id = 1L;
            }
        } else {
            id = Math.abs(UUID.randomUUID().getLeastSignificantBits());
        }
        bg.setId(id);
        if (bindingRecord.hasField(FIELD_QUEUE) && !StringUtils.isEmpty(queue = bindingRecord.getString(FIELD_QUEUE))) {
            bg.setQueue(queue);
        }
        bindingsLock.lock();
        try {
            ExtendedBinding previousBinding = bindingsById.get(bg.getId());
            if (previousBinding != null) {
                long newId = ExpressionUtils.generateBindingId();
                Log.BINDINGS.debug((Object)String.format("Duplicate binding detected for '%s'. New binding '%s' will have bindingId=%d", previousBinding, bg, newId));
                bg.setId(newId);
            }
            bindingsById.put(bg.getId(), new ExtendedBinding(bg, evalOpts));
        }
        finally {
            bindingsLock.unlock();
        }
    }

    public static DataTable bindingsToDataTable(Collection<ExtendedBinding> bindings) {
        return Bindings.bindingsToDataTable(bindings, FORMAT);
    }

    public static DataTable bindingsToDataTable(Collection<ExtendedBinding> bindings, TableFormat format) {
        SimpleDataTable dt = new SimpleDataTable(format);
        for (ExtendedBinding bg : bindings) {
            dt.addRecord(Bindings.bindingToDataRecord(bg, format));
        }
        return dt;
    }

    public static DataRecord bindingToDataRecord(ExtendedBinding ebg, TableFormat format) {
        Binding bg = ebg.getBinding();
        DataRecord dr = new DataRecord(format);
        if (bg.getTarget() != null) {
            dr.setValue(FIELD_TARGET, (Object)bg.getTarget().getImage());
        }
        dr.setValue(FIELD_BINDING_ID, (Object)bg.getId());
        dr.setId(String.valueOf(bg.getId()));
        String text = "";
        if (bg.getExpression() != null) {
            text = bg.getExpression().getText();
        }
        dr.setValue(FIELD_EXPRESSION, (Object)text);
        EvaluationOptions eOpts = ebg.getEvaluationOptions();
        dr.setValue(FIELD_ONSTARTUP, (Object)eOpts.isProcessOnStartup());
        dr.setValue(FIELD_ONEVENT, (Object)eOpts.isProcessOnEvent());
        dr.setValue(FIELD_PERIODICALLY, (Object)eOpts.isProcessPeriodically());
        if (eOpts.getActivator() != null) {
            dr.setValue(FIELD_ACTIVATOR, (Object)eOpts.getActivator().getImage());
        }
        if (eOpts.getCondition() != null) {
            dr.setValue(FIELD_CONDITION, (Object)eOpts.getCondition().getText());
        }
        if (eOpts.isProcessPeriodically()) {
            dr.setValue(FIELD_PERIOD, (Object)eOpts.getPeriod());
        } else {
            dr.setValue(FIELD_PERIOD, (Object)60000L);
        }
        if (format.hasField(FIELD_QUEUE)) {
            dr.setValue(FIELD_QUEUE, (Object)(bg.getQueue() != null ? bg.getQueue() : ""));
        }
        return dr;
    }

    static {
        FORMAT.setReorderable(false);
        FieldFormat bidF = FieldFormat.create(FIELD_BINDING_ID, 'L');
        bidF.setNullable(true);
        bidF.addValidator(new LimitsValidator(Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE)));
        bidF.setHidden(true);
        bidF.setNotReplicated(true);
        bidF.setKeyField(true);
        FORMAT.addField(bidF);
        FieldFormat targF = FieldFormat.create(FIELD_TARGET, 'S');
        targF.setDescription(Cres.get().getString(FIELD_TARGET));
        targF.setHelp(Cres.get().getString("wHelpBindingTarget"));
        targF.setEditor(FIELD_TARGET);
        FORMAT.addField(targF);
        FieldFormat exprF = FieldFormat.create(FIELD_EXPRESSION, 'S');
        exprF.setDescription(Cres.get().getString(FIELD_EXPRESSION));
        exprF.setHelp(Cres.get().getString("wHelpBindingExpression"));
        exprF.setEditor(FIELD_EXPRESSION);
        FORMAT.addField(exprF);
        FieldFormat actF = FieldFormat.create(FIELD_ACTIVATOR, 'S');
        actF.setDescription(Cres.get().getString("wActivatorDescr"));
        actF.setHelp(Cres.get().getString("wHelpBindingActivator"));
        actF.setEditor(FIELD_ACTIVATOR);
        FORMAT.addField(actF);
        FieldFormat condition = FieldFormat.create(FIELD_CONDITION, 'S');
        condition.setDescription(Cres.get().getString(FIELD_CONDITION));
        condition.setHelp(Cres.get().getString("wHelpBindingCondition"));
        condition.setEditor(FIELD_EXPRESSION);
        FORMAT.addField(condition);
        FieldFormat osuF = FieldFormat.create(FIELD_ONSTARTUP, 'B');
        osuF.setDescription(Cres.get().getString("wOnStartup"));
        osuF.setHelp(Cres.get().getString("wHelpBindingOnStartup"));
        FORMAT.addField(osuF);
        FieldFormat oeF = FieldFormat.create(FIELD_ONEVENT, 'B');
        oeF.setDescription(Cres.get().getString("wOnEvent"));
        oeF.setHelp(Cres.get().getString("wHelpBindingOnEvent"));
        FORMAT.addField(oeF);
        FieldFormat perF = FieldFormat.create(FIELD_PERIODICALLY, 'B');
        perF.setDescription(Cres.get().getString("wPeriodically"));
        perF.setHelp(Cres.get().getString("wHelpBindingPeriodically"));
        perF.setDefault(false);
        FORMAT.addField(perF);
        FieldFormat epF = FieldFormat.create(FIELD_PERIOD, 'L');
        epF.setDefault(60000L);
        epF.setDescription(Cres.get().getString("wEvaluationPeriod"));
        epF.setHelp(Cres.get().getString("wHelpBindingPeriod"));
        epF.setEditor(FIELD_PERIOD);
        epF.addValidator(new LimitsValidator(Long.valueOf(1L), Long.valueOf(Long.MAX_VALUE)));
        FORMAT.addField(epF);
        FieldFormat quF = FieldFormat.create(FIELD_QUEUE, 'S');
        quF.setAdvanced(true);
        quF.setDescription(Cres.get().getString(FIELD_QUEUE));
        quF.setHelp(Cres.get().getString("wHelpBindingQueue"));
        quF.addValidator(new RegexValidator("\\w*", Cres.get().getString("dtInvalidName")));
        FORMAT.addField(quF);
        String ref = "expression#options";
        String exp = (Object)((Object)DefaultFunctions.EXPRESSION_EDITOR_OPTIONS) + "({.:})";
        FORMAT.addBinding(ref, exp);
        ref = "activator#enabled";
        exp = "{onevent}";
        FORMAT.addBinding(ref, exp);
        String ref1 = "period#enabled";
        String exp1 = "{periodically}";
        FORMAT.addBinding(ref1, exp1);
        String exp2 = "{bindingId}==null ? " + (Object)((Object)DefaultFunctions.LONG) + "(" + (Object)((Object)DefaultFunctions.RANDOM) + "()*" + Long.MAX_VALUE + ") : {" + FIELD_BINDING_ID + "}";
        FORMAT.addBinding(FIELD_BINDING_ID, exp2);
    }
}

